/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.imageio.stream.ImageInputStream;
import org.esa.s1tbx.io.binary.IllegalBinaryFormatException;

public final class BinaryFileReader {
    private static final String EM_EXPECTED_X_FOUND_Y_BYTES = "Expected bytes to read %d, but only found %d";
    private static final String EM_READING_X_TYPE = "Reading '%s'-Type";
    private static final String EM_NOT_PARSABLE_X_STRING = "Not able to parse %s string";
    private final ImageInputStream stream;

    public BinaryFileReader(ImageInputStream stream) {
        this.stream = stream;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void setByteOrder(ByteOrder order) {
        this.stream.setByteOrder(order);
    }

    public void seek(long pos) throws IOException {
        this.stream.seek(pos);
    }

    public void skipBytes(long numBytes) throws IOException {
        this.stream.skipBytes(numBytes);
    }

    public int readB1() throws IOException, IllegalBinaryFormatException {
        long streamPosition = this.stream.getStreamPosition();
        try {
            return this.stream.readByte() & 0xFF;
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B1");
            throw new IllegalBinaryFormatException(message, streamPosition, e);
        }
    }

    public int readUB1() throws IOException, IllegalBinaryFormatException {
        long streamPosition = this.stream.getStreamPosition();
        try {
            return this.stream.readUnsignedByte();
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B2");
            throw new IllegalBinaryFormatException(message, streamPosition, e);
        }
    }

    public short readB2() throws IOException, IllegalBinaryFormatException {
        long streamPosition = this.stream.getStreamPosition();
        try {
            return this.stream.readShort();
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B2");
            throw new IllegalBinaryFormatException(message, streamPosition, e);
        }
    }

    public int readUB2() throws IOException, IllegalBinaryFormatException {
        long streamPosition = this.stream.getStreamPosition();
        try {
            return this.stream.readUnsignedShort();
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B2");
            throw new IllegalBinaryFormatException(message, streamPosition, e);
        }
    }

    public int readB4() throws IOException, IllegalBinaryFormatException {
        long streamPosition = this.stream.getStreamPosition();
        try {
            return this.stream.readInt();
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B4");
            throw new IllegalBinaryFormatException(message, streamPosition, e);
        }
    }

    public long readB8() throws IOException, IllegalBinaryFormatException {
        long streamPosition = this.stream.getStreamPosition();
        try {
            return this.stream.readLong();
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B8");
            throw new IllegalBinaryFormatException(message, streamPosition, e);
        }
    }

    public void read(byte[] array) throws IOException {
        this.stream.readFully(array, 0, array.length);
    }

    public void read(char[] array) throws IOException {
        this.stream.readFully(array, 0, array.length);
    }

    public void read(short[] array) throws IOException {
        this.stream.readFully(array, 0, array.length);
    }

    public void read(int[] array) throws IOException {
        this.stream.readFully(array, 0, array.length);
    }

    public void read(long[] array) throws IOException {
        this.stream.readFully(array, 0, array.length);
    }

    public void read(float[] array) throws IOException {
        this.stream.readFully(array, 0, array.length);
    }

    public void read(double[] array) throws IOException {
        this.stream.readFully(array, 0, array.length);
    }

    public long readIn(int n) throws IOException, IllegalBinaryFormatException {
        long streamPosition = this.stream.getStreamPosition();
        String longStr = this.readAn(n).trim();
        if (longStr.isEmpty()) {
            return 0L;
        }
        return BinaryFileReader.parseLong(longStr, streamPosition);
    }

    private static long parseLong(String integerStr, long streamPosition) throws IllegalBinaryFormatException {
        long number;
        try {
            number = Long.parseLong(integerStr);
        }
        catch (NumberFormatException e) {
            String newStr = BinaryFileReader.createIntegerString(integerStr, new char[]{'.', '-'}, ' ').trim();
            try {
                if (newStr.isEmpty() || newStr.equals(".") || newStr.equals("-")) {
                    return 0L;
                }
                number = Long.parseLong(newStr);
            }
            catch (NumberFormatException e2) {
                String message = String.format("Not able to parse %s string \"" + integerStr + '\"', "integer");
                throw new IllegalBinaryFormatException(message, streamPosition, e);
            }
        }
        return number;
    }

    public double readFn(int n) throws IOException, IllegalBinaryFormatException {
        long streamPosition = this.stream.getStreamPosition();
        String doubleString = this.readAn(n).trim();
        if (doubleString.isEmpty()) {
            return 0.0;
        }
        doubleString = doubleString.replaceAll("D", "E");
        try {
            return Double.parseDouble(doubleString);
        }
        catch (NumberFormatException e) {
            String message = String.format(EM_NOT_PARSABLE_X_STRING, "double");
            throw new IllegalBinaryFormatException(message, streamPosition, e);
        }
    }

    public void readFn(int n, double[] numbers) throws IOException, IllegalBinaryFormatException {
        long streamPosition = this.stream.getStreamPosition();
        for (int i = 0; i < numbers.length; ++i) {
            try {
                numbers[i] = Double.parseDouble(this.readAn(n).trim());
                continue;
            }
            catch (IllegalBinaryFormatException e) {
                String message = String.format(EM_READING_X_TYPE, "Gn[]");
                throw new IllegalBinaryFormatException(message, streamPosition, e);
            }
        }
    }

    public double readEn(int n) throws IOException {
        byte[] b = new byte[n];
        int bytesRead = this.stream.read(b);
        String str = new String(b).trim();
        if (str.isEmpty()) {
            return 0.0;
        }
        ByteBuffer bBuffer = ByteBuffer.wrap(b);
        double d = bBuffer.getDouble();
        return d;
    }

    public String readAn(int n) throws IOException, IllegalBinaryFormatException {
        int bytesRead;
        long streamPosition = this.stream.getStreamPosition();
        byte[] bytes = new byte[n];
        try {
            bytesRead = this.stream.read(bytes);
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "An");
            throw new IllegalBinaryFormatException(message, streamPosition, e);
        }
        if (bytesRead != n) {
            String message = String.format(EM_EXPECTED_X_FOUND_Y_BYTES, n, bytesRead);
            throw new IllegalBinaryFormatException(message, streamPosition);
        }
        String str = new String(bytes);
        if (str.contains("\u0000")) {
            return str.replace("\u0000", " ");
        }
        return str;
    }

    public int[] readInArray(int arraySize, int intValLength) throws IOException, IllegalBinaryFormatException {
        long streamPosition = this.stream.getStreamPosition();
        int[] ints = new int[arraySize];
        for (int i = 0; i < ints.length; ++i) {
            String integerString = this.readAn(intValLength).trim();
            if (integerString.length() <= 0) continue;
            ints[i] = (int)BinaryFileReader.parseLong(integerString, streamPosition + (long)(i * intValLength));
        }
        return ints;
    }

    public long getCurrentPos() throws IOException {
        return this.stream.getStreamPosition();
    }

    public long getLength() throws IOException {
        return this.stream.length();
    }

    private static String createIntegerString(String name, char[] validChars, char replaceChar) {
        char[] sortedValidChars = null;
        sortedValidChars = validChars == null ? new char[]{} : (char[])validChars.clone();
        Arrays.sort(sortedValidChars);
        StringBuilder validName = new StringBuilder(name.length());
        boolean pad = false;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!pad && Character.isDigit(ch)) {
                validName.append(ch);
                continue;
            }
            if (!pad && Arrays.binarySearch(sortedValidChars, ch) >= 0) {
                validName.append(ch);
                continue;
            }
            pad = true;
            validName.append(replaceChar);
        }
        return validName.toString();
    }
}

