/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io;

import com.bc.ceres.core.VirtualDir;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.esa.s1tbx.io.imageio.ImageIOFile;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.util.ZipUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class XMLProductDirectory {
    private VirtualDir productDir = null;
    private final String baseName;
    private File baseDir;
    private String rootFolder = null;
    protected Document xmlDoc = null;
    protected final File productInputFile;
    private boolean isSLC = false;
    private boolean isMapProjected;
    protected final transient Map<String, ImageIOFile> bandImageFileMap = new TreeMap<String, ImageIOFile>();
    protected final transient Map<Band, ImageIOFile.BandInfo> bandMap = new HashMap<Band, ImageIOFile.BandInfo>(3);

    protected XMLProductDirectory(File inputFile) {
        Guardian.assertNotNull((String)"inputFile", (Object)inputFile);
        this.productInputFile = inputFile;
        if (ZipUtils.isZip((File)inputFile)) {
            this.productDir = VirtualDir.create((File)inputFile);
            this.baseDir = inputFile;
            this.baseName = inputFile.getName();
        } else {
            this.productDir = VirtualDir.create((File)inputFile.getParentFile());
            this.baseDir = inputFile.getParentFile();
            this.baseName = inputFile.getParentFile().getName();
        }
    }

    public final String getRootFolder() {
        if (this.rootFolder != null) {
            return this.rootFolder;
        }
        try {
            this.rootFolder = this.productDir.isCompressed() ? ZipUtils.getRootFolder((File)this.baseDir, (String)this.getHeaderFileName()) : "";
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.rootFolder;
    }

    protected String getRelativePathToImageFolder() {
        return this.getRootFolder();
    }

    public void readProductDirectory() throws IOException {
        this.xmlDoc = XMLSupport.LoadXML((InputStream)this.getInputStream(this.getRootFolder() + this.getHeaderFileName()));
    }

    protected abstract String getHeaderFileName();

    protected abstract void addImageFile(String var1, MetadataElement var2) throws IOException;

    public boolean isSLC() {
        return this.isSLC;
    }

    protected void setSLC(boolean flag) {
        this.isSLC = flag;
    }

    public boolean isMapProjected() {
        return this.isMapProjected;
    }

    protected boolean isCompressed() {
        return this.productDir.isCompressed();
    }

    protected final void findImages(String parentPath, MetadataElement newRoot) throws IOException {
        String[] listing;
        try {
            listing = this.productDir.list(parentPath);
        }
        catch (FileNotFoundException e) {
            listing = null;
        }
        if (listing != null) {
            for (String fileName : listing) {
                this.addImageFile(parentPath + fileName, newRoot);
            }
        }
    }

    protected static String getBandFileNameFromImage(String imgPath) {
        return imgPath.substring(imgPath.lastIndexOf(47) + 1, imgPath.length()).toLowerCase();
    }

    protected static Dimension getBandDimensions(MetadataElement newRoot, String bandMetadataName) {
        int height;
        int width;
        MetadataElement absRoot = newRoot.getElement("Abstracted_Metadata");
        MetadataElement bandMetadata = absRoot.getElement(bandMetadataName);
        if (bandMetadata != null) {
            width = bandMetadata.getAttributeInt("num_samples_per_line");
            height = bandMetadata.getAttributeInt("num_output_lines");
        } else {
            width = absRoot.getAttributeInt("num_samples_per_line");
            height = absRoot.getAttributeInt("num_output_lines");
        }
        return new Dimension(width, height);
    }

    protected void findImages(MetadataElement newRoot) throws IOException {
        String parentPath = this.getRelativePathToImageFolder();
        this.findImages(parentPath, newRoot);
    }

    public ImageIOFile.BandInfo getBandInfo(Band destBand) {
        ImageIOFile.BandInfo bandInfo = this.bandMap.get(destBand);
        if (bandInfo == null) {
            for (Band srcBand : this.bandMap.keySet()) {
                if (!srcBand.getName().equals(destBand.getName())) continue;
                bandInfo = this.bandMap.get(srcBand);
            }
        }
        return bandInfo;
    }

    public void close() throws IOException {
        Set<String> keys = this.bandImageFileMap.keySet();
        for (String key : keys) {
            ImageIOFile img = this.bandImageFileMap.get(key);
            img.close();
        }
    }

    protected abstract void addBands(Product var1);

    protected abstract void addGeoCoding(Product var1);

    protected abstract void addTiePointGrids(Product var1);

    protected abstract void addAbstractedMetadataHeader(MetadataElement var1) throws IOException;

    protected abstract String getProductName();

    protected abstract String getProductType();

    protected String getProductDescription() {
        return "";
    }

    protected MetadataElement addMetaData() throws IOException {
        MetadataElement root = new MetadataElement("metadata");
        Element rootElement = this.xmlDoc.getRootElement();
        AbstractMetadataIO.AddXMLMetadata((Element)rootElement, (MetadataElement)AbstractMetadata.addOriginalProductMetadata((MetadataElement)root));
        this.addAbstractedMetadataHeader(root);
        return root;
    }

    protected String[] listFiles(String path) throws IOException {
        try {
            String[] listing = this.productDir.list(path);
            ArrayList<String> files = new ArrayList<String>(listing.length);
            for (String listEntry : listing) {
                if (this.isDirectory(path + '/' + listEntry)) continue;
                files.add(listEntry);
            }
            return files.toArray(new String[files.size()]);
        }
        catch (Exception e) {
            throw new IOException("Product is corrupt or incomplete\n" + e.getMessage());
        }
    }

    private boolean isDirectory(String path) throws IOException {
        if (this.productDir.isCompressed()) {
            if (path.contains(".")) {
                int sepIndex = path.lastIndexOf(47);
                int dotIndex = path.lastIndexOf(46);
                return dotIndex < sepIndex;
            }
            ZipFile productZip = new ZipFile(this.baseDir, 1);
            Optional<ZipEntry> result = productZip.stream().filter(ze -> ze.isDirectory()).filter(ze -> ze.getName().equals(path)).findFirst();
            return result.isPresent();
        }
        return this.productDir.getFile(path).isDirectory();
    }

    public File getFile(String path) throws IOException {
        return this.productDir.getFile(path);
    }

    public boolean exists(String path) {
        return this.productDir.exists(path);
    }

    public InputStream getInputStream(String path) throws IOException {
        InputStream inStream = this.productDir.getInputStream(path);
        if (inStream == null) {
            throw new IOException("Product is corrupt or incomplete: unreadable " + path);
        }
        return inStream;
    }

    protected File getBaseDir() {
        return this.baseDir;
    }

    protected String getBaseName() {
        return this.baseName;
    }

    public Product createProduct() throws Exception {
        MetadataElement newRoot = this.addMetaData();
        this.findImages(newRoot);
        MetadataElement absRoot = newRoot.getElement("Abstracted_Metadata");
        int sceneWidth = absRoot.getAttributeInt("num_samples_per_line");
        int sceneHeight = absRoot.getAttributeInt("num_output_lines");
        Product product = new Product(this.getProductName(), this.getProductType(), sceneWidth, sceneHeight);
        XMLProductDirectory.updateProduct(product, newRoot);
        this.addBands(product);
        InputProductValidator validator = new InputProductValidator(product);
        this.isMapProjected = validator.isMapProjected();
        this.addGeoCoding(product);
        this.addTiePointGrids(product);
        product.setName(this.getProductName());
        product.setProductType(this.getProductType());
        product.setDescription(this.getProductDescription());
        ReaderUtils.addMetadataIncidenceAngles((Product)product);
        ReaderUtils.addMetadataProductSize((Product)product);
        return product;
    }

    protected static void updateProduct(Product product, MetadataElement newRoot) {
        MetadataElement root = product.getMetadataRoot();
        for (MetadataElement elem : newRoot.getElements()) {
            root.addElement(elem);
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        product.setStartTime(absRoot.getAttributeUTC("first_line_time"));
        product.setEndTime(absRoot.getAttributeUTC("last_line_time"));
        product.setProductType(absRoot.getAttributeString("PRODUCT_TYPE"));
        product.setDescription(absRoot.getAttributeString("SPH_DESCRIPTOR"));
    }
}

