/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import org.esa.s1tbx.io.EnhancedRandomAccessFile;

public final class FileImageOutputStreamExtImpl
extends ImageOutputStreamImpl
implements ImageOutputStream {
    protected EnhancedRandomAccessFile eraf;
    protected File file;
    private boolean isClosed = false;

    public static ImageOutputStream createOutputStream(File file) throws IOException {
        return new FileImageOutputStreamExtImpl(file);
    }

    public FileImageOutputStreamExtImpl(File file) throws IOException {
        this.file = file;
        this.eraf = new EnhancedRandomAccessFile(file, "rw");
        this.eraf.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public FileImageOutputStreamExtImpl(File file, int bufSize) throws IOException {
        this.file = file;
        this.eraf = new EnhancedRandomAccessFile(file, "rw", bufSize);
        this.eraf.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        int val = this.eraf.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.bitOffset = 0;
        int nbytes = this.eraf.read(b, off, len);
        if (nbytes != -1) {
            this.streamPos += (long)nbytes;
        }
        return nbytes;
    }

    @Override
    public void write(int b) throws IOException {
        this.flushBits();
        this.eraf.write(b);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.flushBits();
        this.eraf.writeBytes(b, off, len);
        this.streamPos += (long)len;
    }

    @Override
    public long length() {
        try {
            return this.eraf.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("IndexOutOfBounds pos < flushedPos! " + pos + " < " + this.flushedPos);
        }
        this.bitOffset = 0;
        this.streamPos = this.eraf.seek(pos);
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.isClosed) {
                super.close();
                this.eraf.close();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "FileImageOutputStreamExtImpl which points to " + this.file.toString();
    }
}

