/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.esa.s1tbx.io.EnhancedRandomAccessFile;

public final class FileImageInputStreamExtImpl
extends ImageInputStreamImpl
implements ImageInputStream {
    protected File file;
    protected EnhancedRandomAccessFile eraf;
    private boolean isClosed = false;

    public static ImageInputStream createInputStream(File file) throws IOException {
        return new FileImageInputStreamExtImpl(file);
    }

    @Override
    public byte readByte() throws IOException {
        return this.eraf.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.eraf.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.eraf.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.eraf.readFloat();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.eraf.readFully(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.eraf.readFully(b);
    }

    @Override
    public int readInt() throws IOException {
        return this.eraf.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.eraf.readLine();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.eraf.getByteOrder();
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.eraf.getFilePointer();
    }

    @Override
    public boolean isCached() {
        return this.eraf.isCached();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.eraf.read(b);
    }

    @Override
    public long skipBytes(long n) throws IOException {
        return this.eraf.skipBytes(n);
    }

    @Override
    public long readLong() throws IOException {
        return this.eraf.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.eraf.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.eraf.readUnsignedByte();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return this.eraf.readUnsignedInt();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.eraf.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.eraf.readUTF();
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.eraf.setByteOrder(byteOrder);
        super.setByteOrder(byteOrder);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.eraf.skipBytes(n);
    }

    public FileImageInputStreamExtImpl(File f) throws FileNotFoundException, IOException {
        this(f, -1);
    }

    public FileImageInputStreamExtImpl(File f, int bufferSize) throws IOException {
        if (f == null) {
            throw new NullPointerException("f == null!");
        }
        StringBuilder buff = new StringBuilder("Invalid input file provided");
        if (!f.exists() || f.isDirectory()) {
            buff.append("exists: ").append(f.exists()).append("\n");
            buff.append("isDirectory: ").append(f.isDirectory()).append("\n");
            throw new FileNotFoundException(buff.toString());
        }
        if (!f.exists() || f.isDirectory() || !f.canRead()) {
            buff.append("canRead: ").append(f.canRead()).append("\n");
            throw new IOException(buff.toString());
        }
        this.file = f;
        this.eraf = bufferSize <= 0 ? new EnhancedRandomAccessFile(f, "r") : new EnhancedRandomAccessFile(f, "r", bufferSize);
        this.eraf.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        int val = this.eraf.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.bitOffset = 0;
        int nbytes = this.eraf.readBytes(b, off, len);
        if (nbytes != -1) {
            this.streamPos += (long)nbytes;
        }
        return nbytes;
    }

    @Override
    public long length() {
        try {
            return this.eraf.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        this.bitOffset = 0;
        this.streamPos = this.eraf.seek(pos);
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.isClosed) {
                super.close();
                this.eraf.close();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "FileImageInputStreamExtImpl which points to " + this.file.toString();
    }
}

