/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.esa.snap.engine_utilities.gpf.TestProcessor;
import org.esa.snap.runtime.Config;

public class S1TBXTests {
    private static final String S1TBX_TESTS = "s1tbx.tests";
    private static final Preferences testPreferences = Config.instance((String)"s1tbx.tests").load().preferences();
    private static Path workingPath = Paths.get(System.getProperty("user.dir"), new String[0]);
    public static String rootPathTestProducts;
    public static final File[] rootArchivePaths;
    public static final File[] rootPathsTerraSarX;
    public static final File[] rootPathsASAR;
    public static final File[] rootPathsRadarsat2;
    public static final File[] rootPathsRadarsat1;
    public static final File[] rootPathsSentinel1;
    public static final File[] rootPathsERS;
    public static final File[] rootPathsJERS;
    public static final File[] rootPathsALOS;
    public static final File[] rootPathsALOS2;
    public static final File[] rootPathsCosmoSkymed;
    public static int subsetX;
    public static int subsetY;
    public static int subsetWidth;
    public static int subsetHeight;
    public static int maxIteration;
    public static boolean canTestReadersOnAllProducts;
    public static boolean canTestProcessingOnAllProducts;

    private static File[] loadFilePath(String id) {
        if (testPreferences == null) {
            return new File[0];
        }
        ArrayList<File> fileList = new ArrayList<File>(3);
        String pathsStr = testPreferences.get(id, "");
        StringTokenizer st = new StringTokenizer(pathsStr, ",");
        while (st.hasMoreTokens()) {
            fileList.add(new File(st.nextToken()));
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public static TestProcessor createS1TBXTestProcessor() {
        return new TestProcessor(subsetX, subsetY, subsetWidth, subsetHeight, maxIteration, canTestReadersOnAllProducts, canTestProcessingOnAllProducts);
    }

    static {
        if (workingPath.getParent().getParent().endsWith("s1tbx")) {
            workingPath = workingPath.getParent();
        }
        rootPathTestProducts = workingPath.getParent().getParent().resolve("testdata").toString();
        rootArchivePaths = S1TBXTests.loadFilePath("test.rootArchivePaths");
        rootPathsTerraSarX = S1TBXTests.loadFilePath("test.rootPathTerraSarX");
        rootPathsASAR = S1TBXTests.loadFilePath("test.rootPathASAR");
        rootPathsRadarsat2 = S1TBXTests.loadFilePath("test.rootPathRadarsat2");
        rootPathsRadarsat1 = S1TBXTests.loadFilePath("test.rootPathRadarsat1");
        rootPathsSentinel1 = S1TBXTests.loadFilePath("test.rootPathSentinel1");
        rootPathsERS = S1TBXTests.loadFilePath("test.rootPathERS");
        rootPathsJERS = S1TBXTests.loadFilePath("test.rootPathJERS");
        rootPathsALOS = S1TBXTests.loadFilePath("test.rootPathALOS");
        rootPathsALOS2 = S1TBXTests.loadFilePath("test.rootPathALOS2");
        rootPathsCosmoSkymed = S1TBXTests.loadFilePath("test.rootPathCosmoSkymed");
        subsetX = 0;
        subsetY = 0;
        subsetWidth = 0;
        subsetHeight = 0;
        maxIteration = 0;
        canTestReadersOnAllProducts = false;
        canTestProcessingOnAllProducts = false;
        if (testPreferences != null) {
            subsetX = Integer.parseInt(testPreferences.get("test.subsetX", "100"));
            subsetY = Integer.parseInt(testPreferences.get("test.subsetY", "100"));
            subsetWidth = Integer.parseInt(testPreferences.get("test.subsetWidth", "100"));
            subsetHeight = Integer.parseInt(testPreferences.get("test.subsetHeight", "100"));
            maxIteration = Integer.parseInt(testPreferences.get("test.maxProductsPerRootFolder", "1"));
            String testReadersOnAllProducts = testPreferences.get("test.ReadersOnAllProducts", "");
            String testProcessingOnAllProducts = testPreferences.get("test.ProcessingOnAllProducts", "");
            canTestReadersOnAllProducts = testReadersOnAllProducts != null && testReadersOnAllProducts.equalsIgnoreCase("true");
            canTestProcessingOnAllProducts = testProcessingOnAllProducts != null && testProcessingOnAllProducts.equalsIgnoreCase("true");
        }
    }
}

