/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.esa.s1tbx.commons.RGBProfiles;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.TreeCopier;

public class S1TBXSetup {
    public static void installColorPalettes(Class callingClass, String path) {
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath((Class)callingClass);
        Path auxdataDir = S1TBXSetup.getColorPalettesDir();
        Path sourcePath = moduleBasePath.resolve(path);
        ResourceInstaller resourceInstaller = new ResourceInstaller(sourcePath, auxdataDir);
        try {
            resourceInstaller.install(".*.cpd", ProgressMonitor.NULL);
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to install colour palettes " + moduleBasePath + " to " + auxdataDir + " " + e.getMessage());
        }
    }

    private static Path getColorPalettesDir() {
        return SystemUtils.getAuxDataPath().resolve("color_palettes");
    }

    private static Path getGraphsDir() {
        return SystemUtils.getApplicationDataDir().toPath().resolve("graphs");
    }

    public static void installGraphs(Class callingClass, String path) {
        S1TBXSetup.installFiles(callingClass, path, S1TBXSetup.getGraphsDir());
    }

    public static void installFiles(Class callingClass, String srcResPath, Path dstPath) {
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath((Class)callingClass);
        Path srcGraphPath = moduleBasePath.resolve(srcResPath);
        try {
            if (!Files.exists(dstPath, new LinkOption[0])) {
                Files.createDirectories(dstPath, new FileAttribute[0]);
            }
            TreeCopier.copy((Path)srcGraphPath, (Path)dstPath);
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to install files " + srcGraphPath + " to " + dstPath + " " + e.getMessage());
        }
    }

    static {
        RGBProfiles.registerRGBProfiles();
    }
}

