/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.spot;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import java.io.File;
import java.io.IOException;
import org.esa.beam.dataio.spot.SpotVgtProductReaderPlugIn;
import org.esa.beam.dataio.spot.TestDataDir;
import org.esa.beam.dataio.spot.TestDirRunner;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=TestDirRunner.class)
public class SpotVgtProductReaderPlugInTest {
    @Test
    public void testGetBandName() {
        Assert.assertEquals((Object)"VZA", (Object)SpotVgtProductReaderPlugIn.getBandName((String)"VZA.HDF"));
        Assert.assertEquals((Object)"VZA", (Object)SpotVgtProductReaderPlugIn.getBandName((String)"_VZA.HDF"));
        Assert.assertEquals((Object)"B2", (Object)SpotVgtProductReaderPlugIn.getBandName((String)"0001_B2.HDF"));
        Assert.assertEquals((Object)"MIR", (Object)SpotVgtProductReaderPlugIn.getBandName((String)"0001_MIR.HDF"));
    }

    @Test
    public void testPhysVolumeDescriptor() throws IOException {
        File dir = TestDataDir.get();
        File file = new File(dir, "decode_qual_intended/PHYS_VOL.TXT");
        PropertySet physVolDescriptor = SpotVgtProductReaderPlugIn.readPhysVolDescriptor((File)file);
        Assert.assertNotNull((Object)physVolDescriptor);
        Property[] properties = physVolDescriptor.getProperties();
        Assert.assertEquals((long)24L, (long)properties.length);
        Assert.assertEquals((Object)"1", (Object)physVolDescriptor.getValue("PHYS_VOL_NUMBER"));
        Assert.assertEquals((Object)"V2KRNS10__20060721E", (Object)physVolDescriptor.getValue("PRODUCT_#0001_ID"));
        Assert.assertEquals((Object)"_MIR.HDF", (Object)physVolDescriptor.getValue("PRODUCT_#0001_PLAN_09"));
    }

    @Test
    public void testDecodeQualification() {
        SpotVgtProductReaderPlugIn plugIn = new SpotVgtProductReaderPlugIn();
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification(null));
        File dir = TestDataDir.get();
        File file = new File(dir, "decode_qual_intended.zip");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)plugIn.getDecodeQualification((Object)file));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)plugIn.getDecodeQualification((Object)file.getPath()));
        file = new File(dir, "decode_qual_intended");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)plugIn.getDecodeQualification((Object)file));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)plugIn.getDecodeQualification((Object)file.getPath()));
        file = new File(dir, "decode_qual_intended/PHYS_VOL.TXT");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)plugIn.getDecodeQualification((Object)file));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)plugIn.getDecodeQualification((Object)file.getPath()));
        file = new File(dir, "decode_qual_unable_1");
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file.getPath()));
        file = new File(dir, "decode_qual_unable_1/PHYS_VOL.TXT");
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file.getPath()));
        file = new File(dir, "decode_qual_unable_2");
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file.getPath()));
        file = new File(dir, "decode_qual_unable_2/PHYS_VOL.TXT");
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file.getPath()));
        file = new File(dir, "decode_qual_unable_3");
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file.getPath()));
        file = new File(dir, "decode_qual_unable_3/TEST.TXT");
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file.getPath()));
        file = new File(dir, "decode_qual_unable_3/NON_EXISTENT");
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)plugIn.getDecodeQualification((Object)file.getPath()));
    }

    public static void main(String[] args) throws IOException {
        Product product = ProductIO.readProduct((File)new File(args[0]));
        System.out.println("product = " + product);
        Band[] bands = product.getBands();
        for (int i = 0; i < bands.length; ++i) {
            Band band = bands[i];
            System.out.println("band[" + i + "] = " + band);
        }
        product.closeIO();
    }
}

