/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.spot;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;
import org.esa.beam.dataio.spot.LogVolDescriptor;
import org.esa.beam.dataio.spot.TestDataDir;
import org.esa.beam.dataio.spot.TestDirRunner;
import org.esa.beam.framework.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=TestDirRunner.class)
public class LogVolDescriptorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIt() throws IOException, ParseException {
        File dir = TestDataDir.get();
        File file = new File(dir, "decode_qual_intended/0001/0001_LOG.TXT");
        try (FileReader reader = new FileReader(file);){
            LogVolDescriptor descriptor = new LogVolDescriptor((Reader)reader);
            Assert.assertEquals((Object)"V2KRNS10__20060721E", (Object)descriptor.getProductId());
            Assert.assertNotNull((Object)descriptor.getGeoCoding());
            Assert.assertEquals((Object)"20-JUL-2006 22:31:32.000000", (Object)ProductData.UTC.create((Date)descriptor.getStartDate(), (long)0L).toString());
            Assert.assertEquals((Object)"30-JUL-2006 23:56:28.000000", (Object)ProductData.UTC.create((Date)descriptor.getEndDate(), (long)0L).toString());
            Rectangle bounds = descriptor.getImageBounds();
            Assert.assertNotNull((Object)bounds);
            Assert.assertEquals((long)0L, (long)bounds.x);
            Assert.assertEquals((long)0L, (long)bounds.y);
            Assert.assertEquals((long)8177L, (long)bounds.width);
            Assert.assertEquals((long)5601L, (long)bounds.height);
        }
    }
}

