/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat.tgz;

import com.bc.ceres.core.VirtualDir;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.esa.beam.util.io.FileUtils;
import org.xeustechnologies.jtar.TarEntry;
import org.xeustechnologies.jtar.TarInputStream;
import ucar.unidata.io.bzip2.CBZip2InputStream;

public class VirtualDirTgz
extends VirtualDir {
    private final File archiveFile;
    private File extractDir;

    public VirtualDirTgz(File tgz) throws IOException {
        if (tgz == null) {
            throw new IllegalArgumentException("Input file shall not be null");
        }
        this.archiveFile = tgz;
        this.extractDir = null;
    }

    public String getBasePath() {
        return this.archiveFile.getPath();
    }

    public InputStream getInputStream(String path) throws IOException {
        File file = this.getFile(path);
        return new BufferedInputStream(new FileInputStream(file));
    }

    public File getFile(String path) throws IOException {
        this.ensureUnpacked();
        File file = new File(this.extractDir, path);
        if (!file.isFile() && !file.isDirectory()) {
            throw new IOException();
        }
        return file;
    }

    public String[] list(String path) throws IOException {
        File file = this.getFile(path);
        return file.list();
    }

    public String[] listAllFiles() throws IOException {
        TarEntry entry;
        TarInputStream tis = this.getTarInputStream();
        ArrayList<String> entryNames = new ArrayList<String>();
        while ((entry = tis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            entryNames.add(entry.getName());
        }
        return entryNames.toArray(new String[entryNames.size()]);
    }

    public void close() {
        if (this.extractDir != null) {
            FileUtils.deleteTree((File)this.extractDir);
            this.extractDir = null;
        }
    }

    public boolean isCompressed() {
        return VirtualDirTgz.isTgz(this.archiveFile.getName()) || VirtualDirTgz.isTbz(this.archiveFile.getName());
    }

    public boolean isArchive() {
        return true;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public File getTempDir() throws IOException {
        return this.extractDir;
    }

    static String getFilenameFromPath(String path) {
        int lastSepIndex = path.lastIndexOf("/");
        if (lastSepIndex == -1 && (lastSepIndex = path.lastIndexOf("\\")) == -1) {
            return path;
        }
        return path.substring(lastSepIndex + 1, path.length());
    }

    static boolean isTgz(String filename) {
        String lcName = filename.toLowerCase();
        return lcName.endsWith(".tar.gz") || lcName.endsWith(".tgz");
    }

    static boolean isTbz(String filename) {
        String lcName = filename.toLowerCase();
        return lcName.endsWith(".tar.bz") || lcName.endsWith(".tbz") || lcName.endsWith(".tar.bz2") || lcName.endsWith(".tbz2");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ensureUnpacked() throws IOException {
        if (this.extractDir != null) return;
        this.extractDir = VirtualDir.createUniqueTempDir();
        try (TarInputStream tis = this.getTarInputStream();){
            TarEntry entry;
            while ((entry = tis.getNextEntry()) != null) {
                BufferedOutputStream outStream;
                block26: {
                    String entryName = entry.getName();
                    if (entry.isDirectory()) {
                        File directory = new File(this.extractDir, entryName);
                        this.ensureDirectory(directory);
                        continue;
                    }
                    String fileNameFromPath = VirtualDirTgz.getFilenameFromPath(entryName);
                    int pathIndex = entryName.indexOf(fileNameFromPath);
                    String tarPath = null;
                    if (pathIndex > 0) {
                        tarPath = entryName.substring(0, pathIndex - 1);
                    }
                    File targetDir = tarPath != null ? new File(this.extractDir, tarPath) : this.extractDir;
                    this.ensureDirectory(targetDir);
                    File targetFile = new File(targetDir, fileNameFromPath);
                    if (targetFile.isFile()) continue;
                    if (!targetFile.createNewFile()) {
                        throw new IOException("Unable to create file: " + targetFile.getAbsolutePath());
                    }
                    outStream = new BufferedOutputStream(new FileOutputStream(targetFile));
                    Throwable throwable = null;
                    try {
                        int count;
                        byte[] data = new byte[0x100000];
                        while ((count = tis.read(data)) != -1) {
                            ((OutputStream)outStream).write(data, 0, count);
                        }
                        if (outStream == null) continue;
                        if (throwable == null) break block26;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (outStream == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)outStream).close();
                                    throw throwable3;
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                            }
                            ((OutputStream)outStream).close();
                            throw throwable3;
                        }
                    }
                    try {
                        ((OutputStream)outStream).close();
                        continue;
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                        continue;
                    }
                }
                ((OutputStream)outStream).close();
            }
            return;
        }
    }

    private TarInputStream getTarInputStream() throws IOException {
        TarInputStream tis;
        if (VirtualDirTgz.isTgz(this.archiveFile.getName())) {
            tis = new TarInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.archiveFile))));
        } else if (VirtualDirTgz.isTbz(this.archiveFile.getName())) {
            BufferedInputStream bstream = new BufferedInputStream(new FileInputStream(this.archiveFile));
            tis = new TarInputStream((InputStream)new CBZip2InputStream((InputStream)bstream, true));
        } else {
            tis = new TarInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.archiveFile)));
        }
        return tis;
    }

    private void ensureDirectory(File targetDir) throws IOException {
        if (!targetDir.isDirectory() && !targetDir.mkdirs()) {
            throw new IOException("unable to create directory: " + targetDir.getAbsolutePath());
        }
    }
}

