/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat.geotiff;

import java.awt.Dimension;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.esa.beam.dataio.landsat.geotiff.AbstractLandsatMetadata;
import org.esa.beam.dataio.landsat.geotiff.Landsat8Metadata;
import org.esa.beam.dataio.landsat.geotiff.LandsatLegacyMetadata;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;

class LandsatReprocessedMetadata
extends AbstractLandsatMetadata {
    private static final float[] ETM_PLUS_WAVELENGTHS = new float[]{485.0f, 560.0f, 660.0f, 835.0f, 1650.0f, 11450.0f, 2220.0f, 710.0f};
    private static final float[] ETM_PLUS_BANDWIDTHS = new float[]{70.0f, 80.0f, 60.0f, 130.0f, 200.0f, 2100.0f, 260.0f, 380.0f};
    private final LandsatLegacyMetadata landsatLegacyMetadataDelegate = new LandsatLegacyMetadata(this.getMetaDataElementRoot());
    private final Landsat8Metadata landsat8MetadataDelegate = new Landsat8Metadata(this.getMetaDataElementRoot());
    private final String sensorId = this.getMetaDataElementRoot().getElement("PRODUCT_METADATA").getAttribute("SENSOR_ID").getData().getElemString();

    public LandsatReprocessedMetadata(FileReader fileReader) throws IOException {
        super(fileReader);
    }

    @Override
    public Dimension getReflectanceDim() {
        return this.landsat8MetadataDelegate.getReflectanceDim();
    }

    @Override
    public Dimension getThermalDim() {
        return this.landsat8MetadataDelegate.getThermalDim();
    }

    @Override
    public Dimension getPanchromaticDim() {
        return this.landsat8MetadataDelegate.getPanchromaticDim();
    }

    @Override
    public String getProductType() {
        return this.landsat8MetadataDelegate.getProductType();
    }

    @Override
    public MetadataElement getProductMetadata() {
        return this.landsat8MetadataDelegate.getProductMetadata();
    }

    @Override
    public double getScalingFactor(String bandId) {
        return this.landsat8MetadataDelegate.getScalingFactor(bandId);
    }

    @Override
    public double getScalingOffset(String bandId) {
        return this.landsat8MetadataDelegate.getScalingOffset(bandId);
    }

    @Override
    public ProductData.UTC getCenterTime() {
        return this.landsat8MetadataDelegate.getCenterTime();
    }

    @Override
    public Pattern getOpticalBandFileNamePattern() {
        return this.landsat8MetadataDelegate.getOpticalBandFileNamePattern();
    }

    @Override
    public float getWavelength(String bandNumber) {
        if (this.sensorId.startsWith("ETM")) {
            String bandIndexNumber = bandNumber.substring(0, 1);
            int index = Integer.parseInt(bandIndexNumber) - 1;
            return ETM_PLUS_WAVELENGTHS[index];
        }
        return this.landsatLegacyMetadataDelegate.getWavelength(bandNumber);
    }

    @Override
    public float getBandwidth(String bandNumber) {
        if (this.sensorId.startsWith("ETM")) {
            String bandIndexNumber = bandNumber.substring(0, 1);
            int index = Integer.parseInt(bandIndexNumber) - 1;
            return ETM_PLUS_BANDWIDTHS[index];
        }
        return this.landsatLegacyMetadataDelegate.getBandwidth(bandNumber);
    }

    @Override
    public String getBandDescription(String bandNumber) {
        return this.landsatLegacyMetadataDelegate.getBandDescription(bandNumber);
    }

    @Override
    public String getQualityBandNameKey() {
        return this.landsatLegacyMetadataDelegate.getQualityBandNameKey();
    }

    @Override
    public String getBandNamePrefix(String bandNumber) {
        return this.landsatLegacyMetadataDelegate.getBandNamePrefix(bandNumber);
    }
}

