/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat.geotiff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.esa.beam.dataio.landsat.geotiff.Landsat8Metadata;
import org.esa.beam.dataio.landsat.geotiff.LandsatLegacyMetadata;
import org.esa.beam.dataio.landsat.geotiff.LandsatMetadata;
import org.esa.beam.dataio.landsat.geotiff.LandsatReprocessedMetadata;
import org.esa.beam.framework.dataio.ProductIOException;

class LandsatMetadataFactory {
    LandsatMetadataFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LandsatMetadata create(File mtlFile) throws IOException {
        LandsatLegacyMetadata landsatMetadata = new LandsatLegacyMetadata(new FileReader(mtlFile));
        if (landsatMetadata.isLegacyFormat()) {
            if (landsatMetadata.isLandsatTM() || landsatMetadata.isLandsatETM_Plus()) {
                return landsatMetadata;
            }
            throw new ProductIOException("Product is of a legacy landsat format, not a legacy Landsat5 or Landsat7 ETM+ product.");
        }
        try (BufferedReader reader = null;){
            FileReader fileReader = new FileReader(mtlFile);
            reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            while (line != null) {
                if (line.contains("SPACECRAFT_ID")) {
                    if (line.contains("LANDSAT_8")) {
                        Landsat8Metadata landsat8Metadata = new Landsat8Metadata(new FileReader(mtlFile));
                        return landsat8Metadata;
                    }
                    LandsatReprocessedMetadata landsatReprocessedMetadata = new LandsatReprocessedMetadata(new FileReader(mtlFile));
                    return landsatReprocessedMetadata;
                }
                line = reader.readLine();
            }
        }
        throw new IllegalStateException("File '" + mtlFile + "' does not contain spacecraft information. (Field 'SPACECRAFT_ID' missing)");
    }
}

