/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import org.esa.beam.dataio.geotiff.GeoTiffProductReaderPlugIn;
import org.esa.beam.dataio.landsat.geotiff.LandsatGeotiffReaderPlugin;
import org.esa.beam.dataio.landsat.geotiff.LandsatMetadata;
import org.esa.beam.dataio.landsat.geotiff.LandsatMetadataFactory;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.logging.BeamLogManager;

public class LandsatGeotiffReader
extends AbstractProductReader {
    static final String SYSPROP_READ_AS = "landsat.reader.readAs";
    private static final String SYSPROP_READER_DO_NOT_SCALE_TO_PAN_RESOLUTION = "landsat.reader.donotscaletopanresolution";
    private static final String RADIANCE_UNITS = "W/(m^2*sr*\u00b5m)";
    private static final String REFLECTANCE_UNITS = "dl";
    private LandsatMetadata landsatMetadata;
    private List<Product> bandProducts;
    private VirtualDir input;

    public LandsatGeotiffReader(ProductReaderPlugIn readerPlugin) {
        super(readerPlugin);
    }

    protected Product readProductNodesImpl() throws IOException {
        this.input = LandsatGeotiffReaderPlugin.getInput(this.getInput());
        String[] fileList = this.input.listAllFiles();
        File mtlFile = null;
        String basePath = null;
        for (String filePath : fileList) {
            File file = new File(filePath);
            basePath = file.getParent();
            if (!LandsatGeotiffReaderPlugin.isMetadataFilename(file.getName())) continue;
            mtlFile = this.input.getFile(filePath);
            basePath = basePath == null ? "" : basePath + "/";
            break;
        }
        if (mtlFile == null) {
            throw new IOException("Can not find metadata file.");
        }
        if (!mtlFile.canRead()) {
            throw new IOException("Can not read metadata file: " + mtlFile.getAbsolutePath());
        }
        this.landsatMetadata = LandsatMetadataFactory.create(mtlFile);
        Dimension refDim = this.landsatMetadata.getReflectanceDim();
        Dimension thmDim = this.landsatMetadata.getThermalDim();
        Dimension panDim = this.landsatMetadata.getPanchromaticDim();
        Dimension productDim = new Dimension(0, 0);
        productDim = LandsatGeotiffReader.max(productDim, refDim);
        productDim = LandsatGeotiffReader.max(productDim, thmDim);
        if (!Boolean.getBoolean(SYSPROP_READER_DO_NOT_SCALE_TO_PAN_RESOLUTION)) {
            productDim = LandsatGeotiffReader.max(productDim, panDim);
        }
        MetadataElement metadataElement = this.landsatMetadata.getMetaDataElementRoot();
        Product product = new Product(LandsatGeotiffReader.getProductName(mtlFile), this.landsatMetadata.getProductType(), productDim.width, productDim.height);
        product.setFileLocation(mtlFile);
        product.getMetadataRoot().addElement(metadataElement);
        ProductData.UTC utcCenter = this.landsatMetadata.getCenterTime();
        product.setStartTime(utcCenter);
        product.setEndTime(utcCenter);
        this.addBands(product, this.input, basePath);
        return product;
    }

    private static String getProductName(File mtlfile) {
        String filename = mtlfile.getName();
        int extensionIndex = filename.toLowerCase().indexOf("_mtl.txt");
        return filename.substring(0, extensionIndex);
    }

    private static Dimension max(Dimension dim1, Dimension dim2) {
        if (dim2 != null) {
            int width = Math.max(dim1.width, dim2.width);
            int height = Math.max(dim1.height, dim2.height);
            return new Dimension(width, height);
        }
        return dim1;
    }

    private void addBands(Product product, VirtualDir folder, String basePath) throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        MetadataAttribute[] productAttributes = this.landsatMetadata.getProductMetadata().getAttributes();
        Pattern pattern = this.landsatMetadata.getOpticalBandFileNamePattern();
        this.bandProducts = new ArrayList<Product>();
        for (MetadataAttribute metadataAttribute : productAttributes) {
            String attributeName = metadataAttribute.getName();
            Matcher matcher = pattern.matcher(attributeName);
            if (matcher.matches()) {
                String bandNumber = matcher.group(1);
                String fileName = metadataAttribute.getData().getElemString();
                File bandFile = folder.getFile(basePath + fileName);
                ProductReader productReader = plugIn.createReaderInstance();
                Product bandProduct = productReader.readProductNodes((Object)bandFile, null);
                if (bandProduct == null) continue;
                this.bandProducts.add(bandProduct);
                Band srcBand = bandProduct.getBandAt(0);
                String bandName = this.landsatMetadata.getBandNamePrefix(bandNumber);
                Band band = product.addBand(bandName, srcBand.getDataType());
                band.setScalingFactor(this.landsatMetadata.getScalingFactor(bandNumber));
                band.setScalingOffset(this.landsatMetadata.getScalingOffset(bandNumber));
                band.setNoDataValue(0.0);
                band.setNoDataValueUsed(true);
                band.setSpectralWavelength(this.landsatMetadata.getWavelength(bandNumber));
                band.setSpectralBandwidth(this.landsatMetadata.getBandwidth(bandNumber));
                band.setDescription(this.landsatMetadata.getBandDescription(bandNumber));
                band.setUnit(RADIANCE_UNITS);
                String readAs = System.getProperty(SYSPROP_READ_AS);
                if (readAs == null) continue;
                if (readAs.trim().equals("reflectance")) {
                    band.setDescription(this.landsatMetadata.getBandDescription(bandNumber) + " , as TOA Reflectance");
                    band.setUnit(REFLECTANCE_UNITS);
                    continue;
                }
                Logger systemLogger = BeamLogManager.getSystemLogger();
                systemLogger.warning(String.format("Property '%s' has unsupported value '%s'", SYSPROP_READ_AS, readAs));
                continue;
            }
            if (!attributeName.equals(this.landsatMetadata.getQualityBandNameKey())) continue;
            String fileName = metadataAttribute.getData().getElemString();
            File bandFile = folder.getFile(fileName);
            ProductReader productReader = plugIn.createReaderInstance();
            Product bandProduct = productReader.readProductNodes((Object)bandFile, null);
            if (bandProduct == null) continue;
            this.bandProducts.add(bandProduct);
            Band srcBand = bandProduct.getBandAt(0);
            String bandName = "flags";
            Band band = product.addBand(bandName, srcBand.getDataType());
            band.setNoDataValue(0.0);
            band.setNoDataValueUsed(true);
            band.setDescription("Quality Band");
            FlagCoding flagCoding = this.createFlagCoding(bandName);
            band.setSampleCoding((SampleCoding)flagCoding);
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
            List<Mask> masks = this.createMasks(product);
            for (Mask mask : masks) {
                product.getMaskGroup().add((ProductNode)mask);
            }
        }
        ImageLayout imageLayout = new ImageLayout();
        for (Product bandProduct : this.bandProducts) {
            if (product.getGeoCoding() != null || product.getSceneRasterWidth() != bandProduct.getSceneRasterWidth() || product.getSceneRasterHeight() != bandProduct.getSceneRasterHeight()) continue;
            product.setGeoCoding(bandProduct.getGeoCoding());
            Dimension tileSize = bandProduct.getPreferredTileSize();
            if (tileSize != null) {
                tileSize = ImageManager.getPreferredTileSize((Product)bandProduct);
            }
            product.setPreferredTileSize(tileSize);
            imageLayout.setTileWidth(tileSize.width);
            imageLayout.setTileHeight(tileSize.height);
            break;
        }
        for (int i = 0; i < this.bandProducts.size(); ++i) {
            Product bandProduct = this.bandProducts.get(i);
            Band band = product.getBandAt(i);
            MultiLevelImage sourceImage = bandProduct.getBandAt(0).getSourceImage();
            if (product.getSceneRasterWidth() == bandProduct.getSceneRasterWidth() && product.getSceneRasterHeight() == bandProduct.getSceneRasterHeight()) {
                band.setSourceImage(sourceImage);
                continue;
            }
            RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
            RenderedOp image = LandsatGeotiffReader.createScaledImage(product.getSceneRasterWidth(), product.getSceneRasterHeight(), bandProduct.getSceneRasterWidth(), bandProduct.getSceneRasterHeight(), (RenderedImage)sourceImage, renderingHints);
            band.setSourceImage((RenderedImage)image);
        }
    }

    private List<Mask> createMasks(Product product) {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        masks.add(Mask.BandMathsType.create((String)"designated_fill", (String)"Designated Fill", (int)width, (int)height, (String)"flags.designated_fill", (Color)ColorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"dropped_frame", (String)"Dropped Frame", (int)width, (int)height, (String)"flags.dropped_frame", (Color)ColorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"terrain_occlusion", (String)"Terrain Occlusion", (int)width, (int)height, (String)"flags.terrain_occlusion", (Color)ColorIterator.next(), (double)0.5));
        masks.addAll(this.createConfidenceMasks("water_confidence", "Water confidence", width, height));
        masks.addAll(this.createConfidenceMasks("vegetation_confidence", "Vegetation confidence", width, height));
        masks.addAll(this.createConfidenceMasks("snow_ice_confidence", "Snow/ice confidence", width, height));
        masks.addAll(this.createConfidenceMasks("cirrus_confidence", "Cirrus confidence", width, height));
        masks.addAll(this.createConfidenceMasks("cloud_confidence", "Cloud confidence", width, height));
        return masks;
    }

    private List<Mask> createConfidenceMasks(String flagMaskBaseName, String descriptionBaseName, int width, int height) {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        masks.add(Mask.BandMathsType.create((String)(flagMaskBaseName + "_low"), (String)(descriptionBaseName + " 0-35%"), (int)width, (int)height, (String)("flags." + flagMaskBaseName + "_one and not flags." + flagMaskBaseName + "_two"), (Color)ColorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)(flagMaskBaseName + "_mid"), (String)(descriptionBaseName + " 36-64%"), (int)width, (int)height, (String)("not flags." + flagMaskBaseName + "_one and flags." + flagMaskBaseName + "_two"), (Color)ColorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)(flagMaskBaseName + "_high"), (String)(descriptionBaseName + " 65-100%"), (int)width, (int)height, (String)("flags." + flagMaskBaseName + "_one and flags." + flagMaskBaseName + "_two"), (Color)ColorIterator.next(), (double)0.5));
        return masks;
    }

    private FlagCoding createFlagCoding(String bandName) {
        FlagCoding flagCoding = new FlagCoding(bandName);
        flagCoding.addFlag("designated_fill", 1, "Designated Fill");
        flagCoding.addFlag("dropped_frame", 2, "Dropped Frame");
        flagCoding.addFlag("terrain_occlusion", 4, "Terrain Occlusion");
        flagCoding.addFlag("reserved_1", 8, "Reserved for a future 1-bit class artifact designation");
        flagCoding.addFlag("water_confidence_one", 16, "Water confidence bit one");
        flagCoding.addFlag("water_confidence_two", 32, "Water confidence bit two");
        flagCoding.addFlag("reserved_2_one", 64, "Reserved for a future 2-bit class artifact designation");
        flagCoding.addFlag("reserved_2_two", 128, "Reserved for a future 2-bit class artifact designation");
        flagCoding.addFlag("vegetation_confidence_one", 256, "Vegetation confidence bit one");
        flagCoding.addFlag("vegetation_confidence_two", 512, "Vegetation confidence bit two");
        flagCoding.addFlag("snow_ice_confidence_one", 1024, "Snow/ice confidence bit one");
        flagCoding.addFlag("snow_ice_confidence_two", 2048, "Snow/ice confidence bit two");
        flagCoding.addFlag("cirrus_confidence_one", 4096, "Cirrus confidence bit one");
        flagCoding.addFlag("cirrus_confidence_two", 8192, "Cirrus confidence bit two");
        flagCoding.addFlag("cloud_confidence_one", 16384, "Cloud confidence bit one");
        flagCoding.addFlag("cloud_confidence_two", 32768, "Cloud confidence bit two");
        return flagCoding;
    }

    private static RenderedOp createScaledImage(int targetWidth, int targetHeight, int sourceWidth, int sourceHeight, RenderedImage srcImg, RenderingHints renderingHints) {
        float xScale = (float)targetWidth / (float)sourceWidth;
        float yScale = (float)targetHeight / (float)sourceHeight;
        RenderedOp tempImg = ScaleDescriptor.create((RenderedImage)srcImg, (Float)Float.valueOf(xScale), (Float)Float.valueOf(yScale), (Float)Float.valueOf(0.5f), (Float)Float.valueOf(0.5f), (Interpolation)Interpolation.getInstance((int)0), (RenderingHints)renderingHints);
        return CropDescriptor.create((RenderedImage)tempImg, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(targetWidth), (Float)Float.valueOf(targetHeight), (RenderingHints)renderingHints);
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException();
    }

    public void close() throws IOException {
        for (Product bandProduct : this.bandProducts) {
            bandProduct.closeIO();
        }
        this.bandProducts.clear();
        this.input.close();
        this.input = null;
        super.close();
    }

    private static class ColorIterator {
        static ArrayList<Color> colors = new ArrayList();
        static Iterator<Color> colorIterator;

        private ColorIterator() {
        }

        static Color next() {
            if (!colorIterator.hasNext()) {
                colorIterator = colors.iterator();
            }
            return colorIterator.next();
        }

        static {
            colors.add(Color.red);
            colors.add(Color.red);
            colors.add(Color.red);
            colors.add(Color.blue);
            colors.add(Color.blue.darker());
            colors.add(Color.blue.darker().darker());
            colors.add(Color.green);
            colors.add(Color.green.darker());
            colors.add(Color.green.darker().darker());
            colors.add(Color.yellow);
            colors.add(Color.yellow.darker());
            colors.add(Color.yellow.darker().darker());
            colors.add(Color.magenta);
            colors.add(Color.magenta.darker());
            colors.add(Color.magenta.darker().darker());
            colors.add(Color.pink);
            colors.add(Color.pink.darker());
            colors.add(Color.pink.darker().darker());
            colorIterator = colors.iterator();
        }
    }
}

