/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat.ceos;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.esa.beam.dataio.landsat.AbstractLandsatImageSources;
import org.esa.beam.dataio.landsat.LandsatTMFile;

public final class Landsat5CEOSImageSource
extends AbstractLandsatImageSources {
    public Landsat5CEOSImageSource(LandsatTMFile file) throws ZipException, IOException {
        super(file);
        this.setImageLocations();
    }

    @Override
    protected final void setImageFiles() {
        File folder = new File(this.file.getFileLocation());
        Object[] files = folder.listFiles(new FileFilter(){
            Pattern bandFilenamePattern = Pattern.compile("dat_0[\\d].001");

            @Override
            public boolean accept(File file) {
                return file.isFile() && this.bandFilenamePattern.matcher(file.getName().toLowerCase()).matches();
            }
        });
        Arrays.sort(files);
        this.imageSources = files;
    }

    @Override
    protected final void setImageZipEntries() throws IOException {
    }
}

