/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import java.io.IOException;
import java.util.List;
import org.esa.beam.dataio.landsat.LandsatConstants;
import org.esa.beam.dataio.landsat.LandsatImageInputStream;
import org.esa.beam.dataio.landsat.LandsatUtils;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;

public final class RadiometricData {
    private static final int BEFORE1990 = 1;
    private static final int AFTER1990 = 0;
    private double[] maxRadiance;
    private double[] minRadiance;
    private final int[] bandsPresent;

    private RadiometricData(int[] maxRadOffset, int[] minRadOffset, int size, LandsatImageInputStream input, int[] bandsAvailable) throws IOException {
        Guardian.assertTrue((String)"maxRadOffset.length == minRadOffset.length", (maxRadOffset.length == minRadOffset.length ? 1 : 0) != 0);
        Guardian.assertTrue((String)"maxRadOffset.length >= bandsAvailable.length", (maxRadOffset.length >= bandsAvailable.length ? 1 : 0) != 0);
        int length = bandsAvailable.length;
        this.maxRadiance = new double[length];
        this.minRadiance = new double[length];
        this.bandsPresent = bandsAvailable;
        for (int i = 0; i < length; ++i) {
            this.minRadiance[i] = Double.parseDouble(LandsatUtils.getValueFromLandsatFile(input, minRadOffset[i], size));
            this.maxRadiance[i] = Double.parseDouble(LandsatUtils.getValueFromLandsatFile(input, maxRadOffset[i], size));
        }
        List<LandsatConstants.NomRadiance> nominalRadVals = LandsatConstants.NomRadiance.getAfter2003Radiances();
        if (this.isGainBias(this.maxRadiance, this.minRadiance, nominalRadVals)) {
            this.maxRadiance = RadiometricData.calculateLmax(this.maxRadiance, this.minRadiance, 0);
        } else if (this.isLmaxLmin(this.maxRadiance, this.minRadiance, nominalRadVals)) {
            this.maxRadiance = this.trans2DefaultForm(this.maxRadiance);
            this.minRadiance = this.trans2DefaultForm(this.minRadiance);
        } else {
            Debug.trace((String)"The found radiance data can't be read in");
            this.maxRadiance = null;
            this.minRadiance = null;
        }
    }

    private boolean isLmaxLmin(double[] maxRad, double[] minRad, List nominalRadVals) {
        Guardian.assertTrue((String)"maxRad.length == minRad.length", (maxRad.length == minRad.length ? 1 : 0) != 0);
        if (RadiometricData.isThermalBandpresent(this.bandsPresent)) {
            int[] bandsWithoutThermal = this.getBandsWithoutThermal();
            double[] nominalLmax = RadiometricData.getNomLmax(nominalRadVals, bandsWithoutThermal);
            double[] nominalLmin = RadiometricData.getNomLmin(nominalRadVals, bandsWithoutThermal);
            double[] maxRadWithoutThermal = this.getRadianceWithoutThermal(this.trans2DefaultForm(maxRad));
            double[] minRadWithoutThermal = this.getRadianceWithoutThermal(this.trans2DefaultForm(minRad));
            return RadiometricData.getDistance(nominalLmin, minRadWithoutThermal) < 0.5 && RadiometricData.getDistance(nominalLmax, maxRadWithoutThermal) < 10.0;
        }
        double[] nominalLmax = RadiometricData.getNomLmax(nominalRadVals, this.bandsPresent);
        double[] nominalLmin = RadiometricData.getNomLmin(nominalRadVals, this.bandsPresent);
        return RadiometricData.getDistance(nominalLmin, minRad) < 0.5 && RadiometricData.getDistance(nominalLmax, maxRad) < 0.5;
    }

    public final boolean isEnabled() {
        return this.maxRadiance != null && this.minRadiance != null;
    }

    private boolean isGainBias(double[] maxRad, double[] minRad, List nominalRadVals) {
        double[] nominalGain = RadiometricData.getNomGains(nominalRadVals, this.bandsPresent);
        double[] nominalLmin = RadiometricData.getNomLmin(nominalRadVals, this.bandsPresent);
        return RadiometricData.getDistance(nominalGain, maxRad) < 0.5 && RadiometricData.getDistance(nominalLmin, minRad) < 0.5;
    }

    public static RadiometricData createRadiometricData(int[] maxRadOffset, int[] minRadOffset, int size, LandsatImageInputStream input, int[] bandsAvailable) throws IOException {
        if (maxRadOffset.length == minRadOffset.length) {
            return new RadiometricData(maxRadOffset, minRadOffset, size, input, bandsAvailable);
        }
        return null;
    }

    public final double getMaxRadianceAt(int bandnumber) {
        return this.maxRadiance[bandnumber];
    }

    public final double getMinRadianceAt(int bandnumber) {
        return this.minRadiance[bandnumber];
    }

    private double[] trans2DefaultForm(double[] radiances) {
        return RadiometricData.trans2DefaultForm(radiances, this.bandsPresent);
    }

    private static double[] trans2DefaultForm(double[] radiances, int[] bandsPresents) {
        double[] transRad = new double[bandsPresents.length];
        for (int i = 0; i < radiances.length; ++i) {
            LandsatConstants.ConstBand band = LandsatConstants.ConstBand.getConstantBandAt(bandsPresents[i]);
            transRad[i] = radiances[i] * 10000.0 / (double)band.getBandwidth();
        }
        return transRad;
    }

    private static double[] getNomGains(List nominalRadVals, int[] bandsPresent) {
        double[] nomGains = new double[bandsPresent.length];
        int i = 0;
        for (int j = 0; j < bandsPresent.length; ++j) {
            for (LandsatConstants.NomRadiance element : nominalRadVals) {
                if (element.getBandNumber() != bandsPresent[j]) continue;
                nomGains[i] = element.getGain();
                ++i;
            }
        }
        return nomGains;
    }

    private static double[] getNomLmin(List nominalRadVals, int[] bandsPresent) {
        double[] nomLmin = new double[bandsPresent.length];
        int i = 0;
        for (int j = 0; j < bandsPresent.length; ++j) {
            for (LandsatConstants.NomRadiance element : nominalRadVals) {
                if (element.getBandNumber() != bandsPresent[j]) continue;
                nomLmin[i] = element.getLmin();
                ++i;
            }
        }
        return nomLmin;
    }

    private static double[] getNomLmax(List nominalRadVals, int[] bandsPresent) {
        double[] nomLmax = new double[bandsPresent.length];
        int i = 0;
        for (int j = 0; j < bandsPresent.length; ++j) {
            for (LandsatConstants.NomRadiance element : nominalRadVals) {
                if (bandsPresent[j] != element.getBandNumber()) continue;
                nomLmax[i] = element.getLmax();
                ++i;
            }
        }
        return nomLmax;
    }

    private static double getDistance(double[] foundRadiometricValues, double[] nominalRadiometricValues) {
        Guardian.assertTrue((String)"foundRadiometricValues.length == nominalRadiometricValues.length", (foundRadiometricValues.length == nominalRadiometricValues.length ? 1 : 0) != 0);
        double distance = 0.0;
        for (int i = 0; i < nominalRadiometricValues.length; ++i) {
            distance += Math.pow(foundRadiometricValues[i] - nominalRadiometricValues[i], 2.0);
        }
        return Math.sqrt(distance);
    }

    private static double[] calculateLmax(double[] gain, double[] Lmin, int formularUsed) {
        Guardian.assertTrue((String)"Lmin.length == gain.length", (Lmin.length == gain.length ? 1 : 0) != 0);
        Guardian.assertTrue((String)"formularUsed == AFTER1990 || formularUsed == BEFORE1990", (formularUsed == 0 || formularUsed == 1 ? 1 : 0) != 0);
        double[] Lmax = new double[Lmin.length];
        for (int i = 0; i < Lmax.length; ++i) {
            if (formularUsed == 0) {
                Lmax[i] = gain[i] * 255.0 + Lmin[i];
                continue;
            }
            if (formularUsed != 1) continue;
            Lmax[i] = gain[i] * 254.0 + 254.0 * Lmin[i] / 255.0;
        }
        return Lmax;
    }

    private static boolean isThermalBandpresent(int[] bandspresent) {
        for (int i = 0; i < bandspresent.length; ++i) {
            if (bandspresent[i] != 6) continue;
            return true;
        }
        return false;
    }

    private int[] getBandsWithoutThermal() {
        int[] withoutThermal = new int[this.bandsPresent.length - 1];
        int j = 0;
        for (int i = 0; i < this.bandsPresent.length; ++i) {
            if (this.bandsPresent[i] == 6) continue;
            withoutThermal[j++] = this.bandsPresent[i];
        }
        return withoutThermal;
    }

    private double[] getRadianceWithoutThermal(double[] radiances) {
        double[] radianceWithoutThermal = new double[this.bandsPresent.length - 1];
        int j = 0;
        for (int i = 0; i < this.bandsPresent.length; ++i) {
            if (this.bandsPresent[i] == 6) continue;
            radianceWithoutThermal[j++] = radiances[i];
        }
        return radianceWithoutThermal;
    }
}

