/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.landsat.LandsatImageInputStream;
import org.esa.beam.dataio.landsat.ceos.Landsat5CEOSConstants;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.io.FileUtils;

public final class LandsatUtils {
    public static String getValueFromLandsatFile(InputStreamReader ipStreamReader, int offset, int size) throws IOException {
        LandsatUtils.assertParameters(ipStreamReader, offset, size);
        int offsetInArray = offset - 1;
        char[] charDataValue = new char[size + offsetInArray];
        ipStreamReader.read(charDataValue, 0, charDataValue.length);
        return new String(charDataValue).substring(offsetInArray, size + offsetInArray);
    }

    public static String getValueFromLandsatFile(LandsatImageInputStream landsatInputStream, int offset, int size) throws IOException {
        LandsatUtils.assertParameters(landsatInputStream, offset, size);
        String stringDataValue = null;
        byte[] byteDataValue = new byte[size];
        ImageInputStream inputStream = landsatInputStream.getImageInputStream();
        if (landsatInputStream.length() > (long)byteDataValue.length) {
            inputStream.seek(offset - 1);
            inputStream.read(byteDataValue, 0, size);
            inputStream.seek(0L);
            stringDataValue = new String(byteDataValue);
        }
        return stringDataValue;
    }

    private static void assertParameters(Object io, int offset, int size) {
        Guardian.assertNotNull((String)"io", (Object)io);
        Guardian.assertTrue((String)"size > 0", (size > 0 ? 1 : 0) != 0);
        Guardian.assertTrue((String)"offset > 0", (offset > 0 ? 1 : 0) != 0);
    }

    public static String getValueFromLandsatFile(LandsatImageInputStream inputStream, int offset, Landsat5CEOSConstants.DataType type) throws IOException {
        return LandsatUtils.getValueFromLandsatFile(inputStream, offset, type.toInt());
    }

    public static String getZipEntryFileName(ZipEntry entry) {
        Guardian.assertNotNull((String)"entry", (Object)entry);
        return LandsatUtils.getZipEntryFileName(entry.getName());
    }

    private static String getZipEntryFileName(String entryName) {
        Guardian.assertNotNullOrEmpty((String)"entryName", (String)entryName);
        if (entryName.contains("/")) {
            return FileUtils.getFilenameWithoutExtension((String)entryName.substring(entryName.lastIndexOf("/") + 1));
        }
        return FileUtils.getFilenameWithoutExtension((String)entryName);
    }
}

