/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import java.io.File;
import java.io.IOException;
import org.esa.beam.dataio.landsat.LandsatTMData;
import org.esa.beam.dataio.landsat.LandsatTMFile;
import org.esa.beam.dataio.landsat.ceos.Landsat5CEOS;
import org.esa.beam.dataio.landsat.fast.Landsat5FAST;
import org.esa.beam.framework.dataio.IllegalFileFormatException;

final class LandsatTMFactory {
    private final LandsatTMFile inputFile;

    LandsatTMFactory(File inputFile) throws IOException {
        this.inputFile = new LandsatTMFile(inputFile);
    }

    public final LandsatTMData createLandsatTMObject() throws IOException {
        if (this.inputFile.getFormat() == 0) {
            return new Landsat5FAST(this.inputFile);
        }
        if (this.inputFile.getFormat() == 3) {
            return new Landsat5CEOS(this.inputFile);
        }
        throw new IllegalFileFormatException("Unknown data format.");
    }
}

