/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.landsat.LandsatBandReader;
import org.esa.beam.framework.datamodel.ProductData;

public final class LandsatByteBandReader
extends LandsatBandReader {
    private static final int pixelSize = 1;

    public LandsatByteBandReader(int width, String bandName, ImageInputStream stream) {
        super(width, bandName, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void readBandData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        this.setStreamPos(sourceOffsetX, sourceOffsetY, 1);
        byte[] targetData = (byte[])destBuffer.getElems();
        byte[] line = new byte[sourceWidth];
        int targetIdx = 0;
        pm.beginTask("Reading band '" + this.getBandName() + "'...", sourceHeight - 1);
        try {
            for (int y = 0; y < sourceHeight; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                this.stream.readFully(line, 0, line.length);
                for (int x = 0; x < sourceWidth; x += sourceStepX) {
                    targetData[targetIdx] = line[x];
                    ++targetIdx;
                }
                this.updateStreamPos(this.width - sourceWidth, 1);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }
}

