/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import java.io.IOException;
import java.util.zip.ZipException;
import org.esa.beam.dataio.landsat.LandsatTMFile;

public abstract class AbstractLandsatImageSources {
    protected Object[] imageSources;
    protected final LandsatTMFile file;

    public AbstractLandsatImageSources(LandsatTMFile file) {
        this.file = file;
    }

    protected final void setImageLocations() throws ZipException, IOException {
        if (this.file.isZipped()) {
            this.setImageZipEntries();
        } else {
            this.setImageFiles();
        }
    }

    protected abstract void setImageFiles();

    protected abstract void setImageZipEntries() throws IOException;

    public final int getSize() {
        if (this.imageSources != null) {
            return this.imageSources.length;
        }
        return 0;
    }

    public final Object getLandsatImageSourceAt(int index) {
        return this.imageSources[index];
    }
}

