/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.atsr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class AtsrGSSTConstantsTest
extends TestCase {
    public AtsrGSSTConstantsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(AtsrGSSTConstantsTest.class);
    }

    public void testBandNames() {
        AtsrGSSTConstantsTest.assertEquals((String)"nadir_view_sst", (String)"nadir_view_sst");
        AtsrGSSTConstantsTest.assertEquals((String)"dual_view_sst", (String)"dual_view_sst");
        AtsrGSSTConstantsTest.assertEquals((String)"x_offs_nadir", (String)"x_offs_nadir");
        AtsrGSSTConstantsTest.assertEquals((String)"y_offs_nadir", (String)"y_offs_nadir");
        AtsrGSSTConstantsTest.assertEquals((String)"x_offs_fward", (String)"x_offs_fward");
        AtsrGSSTConstantsTest.assertEquals((String)"y_offs_fward", (String)"y_offs_fward");
    }

    public void testUnits() {
        AtsrGSSTConstantsTest.assertEquals((String)"K", (String)"K");
        AtsrGSSTConstantsTest.assertEquals((String)"km", (String)"km");
    }

    public void testDescriptions() {
        AtsrGSSTConstantsTest.assertEquals((String)"Nadir-only sea-surface temperature", (String)"Nadir-only sea-surface temperature");
        AtsrGSSTConstantsTest.assertEquals((String)"Dual-view sea-surface temperature", (String)"Dual-view sea-surface temperature");
        AtsrGSSTConstantsTest.assertEquals((String)"X coordinate offsets (across-track) of nadir view pixels", (String)"X coordinate offsets (across-track) of nadir view pixels");
        AtsrGSSTConstantsTest.assertEquals((String)"Y coordinate offsets (along-track) of nadir view pixels", (String)"Y coordinate offsets (along-track) of nadir view pixels");
        AtsrGSSTConstantsTest.assertEquals((String)"X coordinate offsets (across-track) of forward view pixels", (String)"X coordinate offsets (across-track) of forward view pixels");
        AtsrGSSTConstantsTest.assertEquals((String)"Y coordinate offsets (along-track) of forward view pixels", (String)"Y coordinate offsets (along-track) of forward view pixels");
    }

    public void testFlagsConstants() {
        AtsrGSSTConstantsTest.assertEquals((String)"confid_flags", (String)"confid_flags");
        AtsrGSSTConstantsTest.assertEquals((String)"NADIR_SST_VALID", (String)"NADIR_SST_VALID");
        AtsrGSSTConstantsTest.assertEquals((int)1, (int)1);
        AtsrGSSTConstantsTest.assertEquals((String)"Nadir-only sea-surface temperature is valid (if not set, pixel contains nadir-view 11 um brightness temperature", (String)"Nadir-only sea-surface temperature is valid (if not set, pixel contains nadir-view 11 um brightness temperature");
        AtsrGSSTConstantsTest.assertEquals((String)"NADIR_SST_37_INCLUDED", (String)"NADIR_SST_37_INCLUDED");
        AtsrGSSTConstantsTest.assertEquals((int)2, (int)2);
        AtsrGSSTConstantsTest.assertEquals((String)"Nadir-only sea-surface temperature retrieval includes 3.7 um channel (if not set, retrieval includes 12 um and 11 um only)", (String)"Nadir-only sea-surface temperature retrieval includes 3.7 um channel (if not set, retrieval includes 12 um and 11 um only)");
        AtsrGSSTConstantsTest.assertEquals((String)"DUAL_SST_VALID", (String)"DUAL_SST_VALID");
        AtsrGSSTConstantsTest.assertEquals((int)4, (int)4);
        AtsrGSSTConstantsTest.assertEquals((String)"Dual-view sea-surface temperature is valid (if not set, pixel contains nadir-view 11 um brightness temperature", (String)"Dual-view sea-surface temperature is valid (if not set, pixel contains nadir-view 11 um brightness temperature");
        AtsrGSSTConstantsTest.assertEquals((String)"DUAL_SST_37_INCLUDED", (String)"DUAL_SST_37_INCLUDED");
        AtsrGSSTConstantsTest.assertEquals((int)8, (int)8);
        AtsrGSSTConstantsTest.assertEquals((String)"Dual-view sea-surface temperature retrieval includes 3.7 um channel (if not set, retrieval includes 12 um and 11 um only)", (String)"Dual-view sea-surface temperature retrieval includes 3.7 um channel (if not set, retrieval includes 12 um and 11 um only)");
        AtsrGSSTConstantsTest.assertEquals((String)"LAND", (String)"LAND");
        AtsrGSSTConstantsTest.assertEquals((int)16, (int)16);
        AtsrGSSTConstantsTest.assertEquals((String)"Pixel is over land", (String)"Pixel is over land");
        AtsrGSSTConstantsTest.assertEquals((String)"NADIR_CLOUDY", (String)"NADIR_CLOUDY");
        AtsrGSSTConstantsTest.assertEquals((int)32, (int)32);
        AtsrGSSTConstantsTest.assertEquals((String)"Nadir-view pixel is cloudy", (String)"Nadir-view pixel is cloudy");
        AtsrGSSTConstantsTest.assertEquals((String)"NADIR_BLANKING", (String)"NADIR_BLANKING");
        AtsrGSSTConstantsTest.assertEquals((int)64, (int)64);
        AtsrGSSTConstantsTest.assertEquals((String)"Nadir-view pixel has blanking-pulse", (String)"Nadir-view pixel has blanking-pulse");
        AtsrGSSTConstantsTest.assertEquals((String)"NADIR_COSMETIC", (String)"NADIR_COSMETIC");
        AtsrGSSTConstantsTest.assertEquals((int)128, (int)128);
        AtsrGSSTConstantsTest.assertEquals((String)"Nadir-view pixel is cosmetic (nearest-neighbour fill)", (String)"Nadir-view pixel is cosmetic (nearest-neighbour fill)");
        AtsrGSSTConstantsTest.assertEquals((String)"FWARD_CLOUDY", (String)"FWARD_CLOUDY");
        AtsrGSSTConstantsTest.assertEquals((int)256, (int)256);
        AtsrGSSTConstantsTest.assertEquals((String)"Forward-view pixel is cloudy", (String)"Forward-view pixel is cloudy");
        AtsrGSSTConstantsTest.assertEquals((String)"FWARD_BLANKING", (String)"FWARD_BLANKING");
        AtsrGSSTConstantsTest.assertEquals((int)512, (int)512);
        AtsrGSSTConstantsTest.assertEquals((String)"Forward-view pixel has blanking-pulse", (String)"Forward-view pixel has blanking-pulse");
        AtsrGSSTConstantsTest.assertEquals((String)"FWARD_COSMETIC", (String)"FWARD_COSMETIC");
        AtsrGSSTConstantsTest.assertEquals((int)1024, (int)1024);
        AtsrGSSTConstantsTest.assertEquals((String)"Forward-view pixel is cosmetic (nearest-neighbour fill)", (String)"Forward-view pixel is cosmetic (nearest-neighbour fill)");
    }
}

