/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.classification.rcp.actions;

import Jama.Matrix;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import org.csa.rstb.classification.rcp.dialogs.ProductGeometrySelectorDialog;
import org.csa.rstb.polarimetric.gpf.DualPolOpUtils;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.engine_utilities.gpf.ProcessTimeMonitor;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class SupervisedTrainingAction
extends AbstractAction {
    private static final int windowSize = 5;
    private static final int halfWindowSize = 2;
    private static int sourceImageWidth;
    private static int sourceImageHeight;
    private static boolean isDualPol;

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            ProductGeometrySelectorDialog dlg = new ProductGeometrySelectorDialog("Select Training Geometries");
            dlg.show();
            if (dlg.IsOK()) {
                Product sourceProduct = dlg.getProduct();
                sourceImageWidth = sourceProduct.getSceneRasterWidth();
                sourceImageHeight = sourceProduct.getSceneRasterHeight();
                PolBandUtils.MATRIX sourceProductType = PolBandUtils.getSourceProductType((Product)sourceProduct);
                if (sourceProductType != PolBandUtils.MATRIX.T3 && sourceProductType != PolBandUtils.MATRIX.C3 && sourceProductType != PolBandUtils.MATRIX.FULL) {
                    if (sourceProductType != PolBandUtils.MATRIX.DUAL_HH_HV && sourceProductType != PolBandUtils.MATRIX.DUAL_VH_VV && sourceProductType != PolBandUtils.MATRIX.DUAL_HH_VV && sourceProductType != PolBandUtils.MATRIX.C2) {
                        Dialogs.showError((String)"Quad-pol or dual-pol product is expected");
                        return;
                    }
                    isDualPol = true;
                }
                PolBandUtils.PolSourceBand[] srcBandList = PolBandUtils.getSourceBands((Product)sourceProduct, (PolBandUtils.MATRIX)sourceProductType);
                TrainingSwingWorker worker = new TrainingSwingWorker(sourceProduct, dlg.getRoiProduct(), dlg.getSelectedGeometries(), dlg.getSaveFile(), srcBandList[0].srcBands, sourceProductType);
                worker.executeWithBlocking();
            }
        }
        catch (Exception e) {
            Dialogs.showError((String)e.getMessage());
        }
    }

    private static void getMeanCoherencyMatrix(int x, int y, int halfWindowSize, int sourceImageWidth, int sourceImageHeight, PolBandUtils.MATRIX sourceProductType, Band[] sourceBands, double[][] Tr, double[][] Ti) throws Exception {
        int xSt = Math.max(x - halfWindowSize, 0);
        int xEd = Math.min(x + halfWindowSize, sourceImageWidth - 1);
        int ySt = Math.max(y - halfWindowSize, 0);
        int yEd = Math.min(y + halfWindowSize, sourceImageHeight - 1);
        int w = xEd - xSt + 1;
        int h = yEd - ySt + 1;
        int num = w * h;
        Matrix TrMat = new Matrix(3, 3);
        Matrix TiMat = new Matrix(3, 3);
        double[][] Sr = new double[2][2];
        double[][] Si = new double[2][2];
        double[][] tempTr = new double[3][3];
        double[][] tempTi = new double[3][3];
        double[][] tempCr = new double[3][3];
        double[][] tempCi = new double[3][3];
        if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[] i_hh = new double[num];
            double[] q_hh = new double[num];
            double[] i_hv = new double[num];
            double[] q_hv = new double[num];
            double[] i_vh = new double[num];
            double[] q_vh = new double[num];
            double[] i_vv = new double[num];
            double[] q_vv = new double[num];
            sourceBands[0].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, i_hh);
            sourceBands[1].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, q_hh);
            sourceBands[2].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, i_hv);
            sourceBands[3].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, q_hv);
            sourceBands[4].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, i_vh);
            sourceBands[5].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, q_vh);
            sourceBands[6].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, i_vv);
            sourceBands[7].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, q_vv);
            for (int i = 0; i < num; ++i) {
                Sr[0][0] = i_hh[i];
                Si[0][0] = q_hh[i];
                Sr[0][1] = i_hv[i];
                Si[0][1] = q_hv[i];
                Sr[1][0] = i_vh[i];
                Si[1][0] = q_vh[i];
                Sr[1][1] = i_vv[i];
                Si[1][1] = q_vv[i];
                PolOpUtils.computeCoherencyMatrixT3((double[][])Sr, (double[][])Si, (double[][])tempTr, (double[][])tempTi);
                TrMat.plusEquals(new Matrix(tempTr));
                TiMat.plusEquals(new Matrix(tempTi));
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.C3) {
            double[] c11 = new double[num];
            double[] c12r = new double[num];
            double[] c12i = new double[num];
            double[] c13r = new double[num];
            double[] c13i = new double[num];
            double[] c22 = new double[num];
            double[] c23r = new double[num];
            double[] c23i = new double[num];
            double[] c33 = new double[num];
            sourceBands[0].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c11);
            sourceBands[1].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c12r);
            sourceBands[2].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c12i);
            sourceBands[3].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c13r);
            sourceBands[4].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c13i);
            sourceBands[5].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c22);
            sourceBands[6].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c23r);
            sourceBands[7].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c23i);
            sourceBands[8].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c33);
            for (int i = 0; i < num; ++i) {
                tempCr[0][0] = c11[i];
                tempCi[0][0] = 0.0;
                tempCr[0][1] = c12r[i];
                tempCi[0][1] = c12i[i];
                tempCr[0][2] = c13r[i];
                tempCi[0][2] = c13i[i];
                tempCr[1][1] = c22[i];
                tempCi[1][1] = 0.0;
                tempCr[1][2] = c23r[i];
                tempCi[1][2] = c23i[i];
                tempCr[2][2] = c33[i];
                tempCi[2][2] = 0.0;
                tempCr[1][0] = tempCr[0][1];
                tempCi[1][0] = -tempCi[0][1];
                tempCr[2][0] = tempCr[0][2];
                tempCi[2][0] = -tempCi[0][2];
                tempCr[2][1] = tempCr[1][2];
                tempCi[2][1] = -tempCi[1][2];
                PolOpUtils.c3ToT3((double[][])tempCr, (double[][])tempCi, (double[][])tempTr, (double[][])tempTi);
                TrMat.plusEquals(new Matrix(tempTr));
                TiMat.plusEquals(new Matrix(tempTi));
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.T3) {
            double[] t11 = new double[num];
            double[] t12r = new double[num];
            double[] t12i = new double[num];
            double[] t13r = new double[num];
            double[] t13i = new double[num];
            double[] t22 = new double[num];
            double[] t23r = new double[num];
            double[] t23i = new double[num];
            double[] t33 = new double[num];
            sourceBands[0].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, t11);
            sourceBands[1].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, t12r);
            sourceBands[2].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, t12i);
            sourceBands[3].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, t13r);
            sourceBands[4].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, t13i);
            sourceBands[5].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, t22);
            sourceBands[6].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, t23r);
            sourceBands[7].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, t23i);
            sourceBands[8].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, t33);
            for (int i = 0; i < num; ++i) {
                tempTr[0][0] = t11[i];
                tempTi[0][0] = 0.0;
                tempTr[0][1] = t12r[i];
                tempTi[0][1] = t12i[i];
                tempTr[0][2] = t13r[i];
                tempTi[0][2] = t13i[i];
                tempTr[1][1] = t22[i];
                tempTi[1][1] = 0.0;
                tempTr[1][2] = t23r[i];
                tempTi[1][2] = t23i[i];
                tempTr[2][2] = t33[i];
                tempTi[2][2] = 0.0;
                tempTr[1][0] = tempTr[0][1];
                tempTi[1][0] = -tempTi[0][1];
                tempTr[2][0] = tempTr[0][2];
                tempTi[2][0] = -tempTi[0][2];
                tempTr[2][1] = tempTr[1][2];
                tempTi[2][1] = -tempTi[1][2];
                TrMat.plusEquals(new Matrix(tempTr));
                TiMat.plusEquals(new Matrix(tempTi));
            }
        }
        TrMat.timesEquals(1.0 / (double)num);
        TiMat.timesEquals(1.0 / (double)num);
        SupervisedTrainingAction.copyMatrix(TrMat, Tr);
        SupervisedTrainingAction.copyMatrix(TiMat, Ti);
    }

    private static void getMeanCovarianceMatrixC2(int x, int y, int halfWindowSize, int sourceImageWidth, int sourceImageHeight, PolBandUtils.MATRIX sourceProductType, Band[] sourceBands, double[][] Cr, double[][] Ci) throws Exception {
        int xSt = Math.max(x - halfWindowSize, 0);
        int xEd = Math.min(x + halfWindowSize, sourceImageWidth - 1);
        int ySt = Math.max(y - halfWindowSize, 0);
        int yEd = Math.min(y + halfWindowSize, sourceImageHeight - 1);
        int w = xEd - xSt + 1;
        int h = yEd - ySt + 1;
        int num = w * h;
        Matrix CrMat = new Matrix(2, 2);
        Matrix CiMat = new Matrix(2, 2);
        double[] tempKr = new double[2];
        double[] tempKi = new double[2];
        double[][] tempCr = new double[2][2];
        double[][] tempCi = new double[2][2];
        if (sourceProductType == PolBandUtils.MATRIX.DUAL_HH_HV || sourceProductType == PolBandUtils.MATRIX.DUAL_VH_VV || sourceProductType == PolBandUtils.MATRIX.DUAL_HH_VV) {
            double[] K0_i = new double[num];
            double[] K0_q = new double[num];
            double[] K1_i = new double[num];
            double[] K1_q = new double[num];
            sourceBands[0].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, K0_i);
            sourceBands[1].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, K0_q);
            sourceBands[2].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, K1_i);
            sourceBands[3].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, K1_q);
            for (int i = 0; i < num; ++i) {
                tempKr[0] = K0_i[i];
                tempKi[0] = K0_q[i];
                tempKr[1] = K1_i[i];
                tempKi[1] = K1_q[i];
                DualPolOpUtils.computeCovarianceMatrixC2((double[])tempKr, (double[])tempKi, (double[][])tempCr, (double[][])tempCi);
                CrMat.plusEquals(new Matrix(tempCr));
                CiMat.plusEquals(new Matrix(tempCi));
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.C2) {
            double[] c11 = new double[num];
            double[] c12r = new double[num];
            double[] c12i = new double[num];
            double[] c22 = new double[num];
            sourceBands[0].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c11);
            sourceBands[1].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c12r);
            sourceBands[2].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c12i);
            sourceBands[3].getSourceImage().getData(new Rectangle(xSt, ySt, w, h)).getPixels(xSt, ySt, w, h, c22);
            for (int i = 0; i < num; ++i) {
                tempCr[0][0] = c11[i];
                tempCi[0][0] = 0.0;
                tempCr[0][1] = c12r[i];
                tempCi[0][1] = c12i[i];
                tempCr[1][1] = c22[i];
                tempCi[1][1] = 0.0;
                tempCr[1][0] = tempCr[0][1];
                tempCi[1][0] = -tempCi[0][1];
                CrMat.plusEquals(new Matrix(tempCr));
                CiMat.plusEquals(new Matrix(tempCi));
            }
        }
        CrMat.timesEquals(1.0 / (double)num);
        CiMat.timesEquals(1.0 / (double)num);
        SupervisedTrainingAction.copyMatrix(CrMat, Cr);
        SupervisedTrainingAction.copyMatrix(CiMat, Ci);
    }

    public static void copyMatrix(Matrix mat, double[][] T) {
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            for (int j = 0; j < mat.getColumnDimension(); ++j) {
                T[i][j] = mat.get(i, j);
            }
        }
    }

    static {
        isDualPol = false;
    }

    private static class TrainingSwingWorker
    extends ProgressMonitorSwingWorker {
        private final Product sourceProduct;
        private final Product roiProduct;
        private final String[] geometries;
        private final File file;
        private final Band[] sourceBands;
        private final PolBandUtils.MATRIX sourceProductType;
        private Throwable error;
        private final ProcessTimeMonitor timeMonitor = new ProcessTimeMonitor();

        private TrainingSwingWorker(Product sourceProduct, Product roiProduct, String[] geometries, File file, Band[] sourceBands, PolBandUtils.MATRIX sourceProductType) {
            super((Component)SnapApp.getDefault().getMainFrame(), "Training...");
            this.sourceProduct = sourceProduct;
            this.roiProduct = roiProduct;
            this.geometries = geometries;
            this.file = file;
            this.sourceBands = sourceBands;
            this.sourceProductType = sourceProductType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground(ProgressMonitor pm) throws Exception {
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            double[][] Cr = new double[2][2];
            double[][] Ci = new double[2][2];
            PrintStream out = null;
            this.timeMonitor.start();
            String[] subGeometries = TrainingSwingWorker.createSubGeometries(this.roiProduct, this.geometries);
            try {
                out = new PrintStream(new FileOutputStream(this.file.getAbsolutePath(), false));
                out.println("number_of_clusters = " + subGeometries.length);
                out.println();
                String title = "Generating Supervised Training Dataset... ";
                int totalRows = 0;
                for (String geom : subGeometries) {
                    VectorDataNode vec = (VectorDataNode)this.roiProduct.getVectorDataGroup().get(geom);
                    int minY = Math.max(0, (int)vec.getEnvelope().getMinY() - 1);
                    int maxY = Math.min(sourceImageHeight - 1, (int)vec.getEnvelope().getMaxY() + 1);
                    totalRows += maxY - minY;
                }
                pm.beginTask("Generating Supervised Training Dataset... ", totalRows);
                int k = 0;
                for (String geom : subGeometries) {
                    Mask band = (Mask)this.roiProduct.getMaskGroup().get(geom);
                    VectorDataNode vec = (VectorDataNode)this.roiProduct.getVectorDataGroup().get(geom);
                    int minX = Math.max(0, (int)vec.getEnvelope().getMinX() - 1);
                    int minY = Math.max(0, (int)vec.getEnvelope().getMinY() - 1);
                    int maxX = Math.min(sourceImageWidth - 1, (int)vec.getEnvelope().getMaxX() + 1);
                    int maxY = Math.min(sourceImageHeight - 1, (int)vec.getEnvelope().getMaxY() + 1);
                    int counter = 0;
                    int width = maxX - minX;
                    int height = maxY - minY;
                    if (width <= 0 || height <= 0) {
                        pm.worked(height);
                        continue;
                    }
                    int[] data = new int[width];
                    if (!isDualPol) {
                        double t11 = 0.0;
                        double t12Re = 0.0;
                        double t12Im = 0.0;
                        double t13Re = 0.0;
                        double t13Im = 0.0;
                        double t22 = 0.0;
                        double t23Re = 0.0;
                        double t23Im = 0.0;
                        double t33 = 0.0;
                        for (int y = minY; y < maxY; ++y) {
                            if (pm.isCanceled()) {
                                this.error = new Exception("Training cancelled by user");
                                Boolean bl = false;
                                return bl;
                            }
                            int pct = (int)((float)(y - minY) / (float)height * 100.0f);
                            pm.setTaskName("Generating Supervised Training Dataset... " + geom + ' ' + pct + '%');
                            band.readPixels(minX, y, width, 1, data);
                            for (int x = minX; x < maxX; ++x) {
                                if (data[x - minX] == 0) continue;
                                SupervisedTrainingAction.getMeanCoherencyMatrix(x, y, 2, sourceImageWidth, sourceImageHeight, this.sourceProductType, this.sourceBands, Tr, Ti);
                                t11 += Tr[0][0];
                                t12Re += Tr[0][1];
                                t12Im += Ti[0][1];
                                t13Re += Tr[0][2];
                                t13Im += Ti[0][2];
                                t22 += Tr[1][1];
                                t23Re += Tr[1][2];
                                t23Im += Ti[1][2];
                                t33 += Tr[2][2];
                                ++counter;
                            }
                            pm.worked(1);
                        }
                        t11 /= (double)counter;
                        t12Re /= (double)counter;
                        t12Im /= (double)counter;
                        t13Re /= (double)counter;
                        t13Im /= (double)counter;
                        t22 /= (double)counter;
                        t23Re /= (double)counter;
                        t23Im /= (double)counter;
                        t33 /= (double)counter;
                        out.println("cluster" + k + " = " + geom);
                        out.println();
                        out.println("cluster" + k + "_T11 = " + t11);
                        out.println("cluster" + k + "_T12_real = " + t12Re);
                        out.println("cluster" + k + "_T12_imag = " + t12Im);
                        out.println("cluster" + k + "_T13_real = " + t13Re);
                        out.println("cluster" + k + "_T13_imag = " + t13Im);
                        out.println("cluster" + k + "_T22 = " + t22);
                        out.println("cluster" + k + "_T23_real = " + t23Re);
                        out.println("cluster" + k + "_T23_imag = " + t23Im);
                        out.println("cluster" + k + "_T33 = " + t33);
                        out.println("pixels = " + counter);
                        out.println();
                        ++k;
                        continue;
                    }
                    double c11 = 0.0;
                    double c12Re = 0.0;
                    double c12Im = 0.0;
                    double c22 = 0.0;
                    for (int y = minY; y < maxY; ++y) {
                        if (pm.isCanceled()) {
                            this.error = new Exception("Training cancelled by user");
                            Boolean bl = false;
                            return bl;
                        }
                        int pct = (int)((float)(y - minY) / (float)height * 100.0f);
                        pm.setTaskName("Generating Supervised Training Dataset... " + geom + ' ' + pct + '%');
                        band.readPixels(minX, y, width, 1, data);
                        for (int x = minX; x < maxX; ++x) {
                            if (data[x - minX] == 0) continue;
                            SupervisedTrainingAction.getMeanCovarianceMatrixC2(x, y, 2, sourceImageWidth, sourceImageHeight, this.sourceProductType, this.sourceBands, Cr, Ci);
                            c11 += Cr[0][0];
                            c12Re += Cr[0][1];
                            c12Im += Ci[0][1];
                            c22 += Cr[1][1];
                            ++counter;
                        }
                        pm.worked(1);
                    }
                    c11 /= (double)counter;
                    c12Re /= (double)counter;
                    c12Im /= (double)counter;
                    c22 /= (double)counter;
                    out.println("cluster" + k + " = " + geom);
                    out.println();
                    out.println("cluster" + k + "_C11 = " + c11);
                    out.println("cluster" + k + "_C12_real = " + c12Re);
                    out.println("cluster" + k + "_C12_imag = " + c12Im);
                    out.println("cluster" + k + "_C22 = " + c22);
                    out.println("pixels = " + counter);
                    out.println();
                    ++k;
                }
                Boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.error = e;
                Boolean bl = false;
                return bl;
            }
            finally {
                if (out != null) {
                    out.close();
                }
                pm.done();
                TrainingSwingWorker.removeSubGeometries(this.roiProduct, subGeometries);
            }
        }

        private static String[] createSubGeometries(Product product, String[] geometries) {
            ArrayList<String> subGeometries = new ArrayList<String>(geometries.length);
            try {
                for (String geometry : geometries) {
                    VectorDataNode vec = (VectorDataNode)product.getVectorDataGroup().get(geometry);
                    DefaultFeatureCollection featCollection = vec.getFeatureCollection();
                    int i = 1;
                    FeatureIterator f = featCollection.features();
                    while (f.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)f.next();
                        String subGeomName = geometry + '_' + i;
                        VectorDataNode vectorDataNode = new VectorDataNode(subGeomName, vec.getFeatureType());
                        vectorDataNode.getFeatureCollection().add(feature);
                        product.getVectorDataGroup().add((ProductNode)vectorDataNode);
                        subGeometries.add(subGeomName);
                        ++i;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return subGeometries.toArray(new String[subGeometries.size()]);
        }

        private static void removeSubGeometries(Product product, String[] subGeometries) {
            try {
                for (String subGeom : subGeometries) {
                    VectorDataNode vectorDataNode = (VectorDataNode)product.getVectorDataGroup().get(subGeom);
                    product.getVectorDataGroup().remove((ProductNode)vectorDataNode);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        protected void done() {
            this.roiProduct.setModified(false);
            try {
                long duration = this.timeMonitor.stop();
                Boolean isOk = (Boolean)this.get();
                if (isOk.booleanValue()) {
                    String durationStr = "Processing completed in " + ProcessTimeMonitor.formatDuration((long)duration);
                    Dialogs.showInformation((String)"Done", (String)("Supervised Training Dataset Completed\n" + this.file.getAbsolutePath() + "\n\n" + durationStr), null);
                } else {
                    Dialogs.showError((String)("An error occurred\n" + this.error.getMessage()));
                }
            }
            catch (Exception e) {
                Dialogs.showError((String)("An error occurred\n" + e.getMessage()));
            }
        }
    }
}

