/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.classification.rcp.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileSystemView;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.ModalDialog;

public class ProductGeometrySelectorDialog
extends ModalDialog {
    private final JComboBox<String> productList;
    private final JComboBox<String> roiProductList;
    private final JList<String> geometries = new JList();
    private final JTextField savePath = new JTextField();
    private final JButton browseButton = new JButton("...");
    private boolean ok = false;

    public ProductGeometrySelectorDialog(String title) {
        super((Window)SnapApp.getDefault().getMainFrame(), title, 33, null);
        String[] productNames = SnapApp.getDefault().getProductManager().getProductDisplayNames();
        this.productList = new JComboBox<String>(productNames);
        this.roiProductList = new JComboBox<String>(productNames);
        this.roiProductList.addItemListener(event -> this.updateGeometryList());
        this.geometries.setFixedCellWidth(200);
        this.geometries.setMinimumSize(new Dimension(50, 4));
        this.geometries.setVisibleRowCount(6);
        Product selectedProduct = SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.AUTO);
        if (selectedProduct != null) {
            this.productList.setSelectedItem(selectedProduct.getDisplayName());
            this.roiProductList.setSelectedItem(selectedProduct.getDisplayName());
            this.updateGeometryList();
        }
        final String defaultSavePath = ProductGeometrySelectorDialog.getDefaultSaveLocation().getAbsolutePath();
        this.savePath.setText(defaultSavePath);
        this.savePath.setColumns(40);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForSave((String)"Classification Training Dataset", (boolean)false, null, (String)".txt", (String)defaultSavePath, null, (String)"rstb.trainingDir");
                ProductGeometrySelectorDialog.this.savePath.setText(file.getAbsolutePath());
            }
        });
        this.getJDialog().setMinimumSize(new Dimension(200, 100));
        this.setContent(this.createPanel());
    }

    private void updateGeometryList() {
        String name = (String)this.roiProductList.getSelectedItem();
        Product product = SnapApp.getDefault().getProductManager().getProductByDisplayName(name);
        String[] geometryNames = product.getMaskGroup().getNodeNames();
        this.geometries.removeAll();
        this.geometries.setListData((String[])geometryNames);
    }

    private JPanel createPanel() {
        JPanel content = new JPanel(new BorderLayout(2, 2));
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel srcPanel = new JPanel(gridBagLayout);
        srcPanel.setBorder(BorderFactory.createTitledBorder("Source Product"));
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)srcPanel, (GridBagConstraints)gbc, (String)"Quad Pol Product:", this.productList);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)srcPanel, (GridBagConstraints)gbc, (String)"Product with ROIs:", this.roiProductList);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)srcPanel, (GridBagConstraints)gbc, (String)"Training ROIs:", (JComponent)new JScrollPane(this.geometries));
        JPanel dstPanel = new JPanel(gridBagLayout);
        dstPanel.setBorder(BorderFactory.createTitledBorder("Saved Training Dataset"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        dstPanel.add((Component)new JLabel("File name:"), gbc);
        gbc.gridx = 1;
        dstPanel.add((Component)this.savePath, gbc);
        gbc.gridx = 2;
        dstPanel.add((Component)this.browseButton, gbc);
        content.add((Component)srcPanel, "Center");
        content.add((Component)dstPanel, "South");
        return content;
    }

    public Product getProduct() {
        return SnapApp.getDefault().getProductManager().getProductByDisplayName((String)this.productList.getSelectedItem());
    }

    public Product getRoiProduct() {
        return SnapApp.getDefault().getProductManager().getProductByDisplayName((String)this.roiProductList.getSelectedItem());
    }

    public String[] getSelectedGeometries() {
        List<String> list = this.geometries.getSelectedValuesList();
        return list.toArray(new String[list.size()]);
    }

    public File getSaveFile() {
        return new File(this.savePath.getText());
    }

    private static File getDefaultSaveLocation() {
        File folder;
        try {
            folder = new File(Settings.instance().getAuxDataFolder(), "classifiers" + File.separator + "Wishart");
        }
        catch (Exception e) {
            folder = FileSystemView.getFileSystemView().getRoots()[0];
        }
        return new File(folder, "training_cluster_centers.txt");
    }

    private boolean validate() {
        String[] geometryNames = this.getSelectedGeometries();
        if (geometryNames == null || geometryNames.length < 1) {
            Dialogs.showError((String)"Please select the product geometries to use");
            return false;
        }
        File file = this.getSaveFile();
        if (file.exists()) {
            return Dialogs.requestDecision((String)"File exists", (String)("File " + file.getAbsolutePath() + "\nalready exists. Would you like to overwrite it?"), (boolean)false, null) == Dialogs.Answer.YES;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            SystemUtils.LOG.severe("Unable to create folders in " + file.getParentFile());
        }
        return true;
    }

    protected void onOK() {
        if (this.validate()) {
            this.ok = true;
            this.hide();
        }
    }

    public boolean IsOK() {
        return this.ok;
    }
}

