/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.classification.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public class SupervisedWishartClassificationOpUI
extends BaseOperatorUI {
    private final JLabel trainingDataSetLabel = new JLabel("Training Data Set:");
    private final JTextField trainingDataSet = new JTextField("");
    private final JButton trainingDataSetBrowseButton = new JButton("...");
    private final JLabel windowSizeLabel = new JLabel("Window Size:   ");
    private final JTextField windowSize = new JTextField("");

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.trainingDataSet.setColumns(30);
        this.trainingDataSetBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForOpen((String)"Training Data Set", (boolean)false, null, (String)"rstb.trainingDir");
                SupervisedWishartClassificationOpUI.this.trainingDataSet.setText(file.getAbsolutePath());
            }
        });
        return panel;
    }

    public void initParameters() {
        File dataSetFile = (File)this.paramMap.get("trainingDataSet");
        if (dataSetFile != null) {
            this.trainingDataSet.setText(dataSetFile.getAbsolutePath());
        }
        this.windowSize.setText(String.valueOf(this.paramMap.get("windowSize")));
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        String dataSetStr = this.trainingDataSet.getText();
        if (!dataSetStr.isEmpty()) {
            this.paramMap.put("trainingDataSet", new File(dataSetStr));
        }
        this.paramMap.put("windowSize", Integer.parseInt(this.windowSize.getText()));
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.gridx = 0;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.trainingDataSetLabel, (JComponent)this.trainingDataSet);
        gbc.gridx = 2;
        contentPane.add((Component)this.trainingDataSetBrowseButton, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.windowSizeLabel, (JComponent)this.windowSize);
        DialogUtils.enableComponents((JComponent)this.windowSizeLabel, (JComponent)this.windowSize, (boolean)true);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

