/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.classification.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class PolarimetricClassificationOpUI
extends BaseOperatorUI {
    private final JComboBox classification = new JComboBox<String>(new String[]{"Cloude-Pottier", "Cloude-Pottier Dual Pol", "H Alpha Wishart", "H Alpha Wishart Dual Pol", "Freeman-Durden Wishart"});
    private final JLabel windowSizeLabel = new JLabel("Window Size:");
    private final JTextField windowSize = new JTextField("");
    private final JLabel maxIterationsLabel = new JLabel("Max Iterations:");
    private final JTextField maxIterations = new JTextField("");
    private final JLabel numInitialClassesLabel = new JLabel("Initial Number of Classes:");
    private final JTextField numInitialClasses = new JTextField("");
    private final JLabel numFinalClassesLabel = new JLabel("Final Number of Classes:");
    private final JTextField numFinalClasses = new JTextField("");
    private final JLabel mixedCategoryThresholdLabel = new JLabel("Threshold for Mixed Category:");
    private final JTextField mixedCategoryThreshold = new JTextField("");

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        return panel;
    }

    public void initParameters() {
        this.classification.setSelectedItem(this.paramMap.get("classification"));
        this.windowSize.setText(String.valueOf(this.paramMap.get("windowSize")));
        this.maxIterations.setText(String.valueOf(this.paramMap.get("maxIterations")));
        this.numInitialClasses.setText(String.valueOf(this.paramMap.get("numInitialClasses")));
        this.numFinalClasses.setText(String.valueOf(this.paramMap.get("numFinalClasses")));
        this.mixedCategoryThreshold.setText(String.valueOf(this.paramMap.get("mixedCategoryThreshold")));
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("classification", this.classification.getSelectedItem());
        this.paramMap.put("windowSize", Integer.parseInt(this.windowSize.getText()));
        this.paramMap.put("maxIterations", Integer.parseInt(this.maxIterations.getText()));
        this.paramMap.put("numInitialClasses", Integer.parseInt(this.numInitialClasses.getText()));
        this.paramMap.put("numFinalClasses", Integer.parseInt(this.numFinalClasses.getText()));
        this.paramMap.put("mixedCategoryThreshold", Double.parseDouble(this.mixedCategoryThreshold.getText()));
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.gridx = 0;
        contentPane.add((Component)new JLabel("Classification:"), gbc);
        gbc.gridx = 1;
        contentPane.add((Component)this.classification, gbc);
        this.classification.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                String item = (String)PolarimetricClassificationOpUI.this.classification.getSelectedItem();
                if (item.equals("H Alpha Wishart") || item.equals("H Alpha Wishart Dual Pol")) {
                    DialogUtils.enableComponents((JComponent)PolarimetricClassificationOpUI.this.maxIterationsLabel, (JComponent)PolarimetricClassificationOpUI.this.maxIterations, (boolean)true);
                } else {
                    DialogUtils.enableComponents((JComponent)PolarimetricClassificationOpUI.this.maxIterationsLabel, (JComponent)PolarimetricClassificationOpUI.this.maxIterations, (boolean)false);
                }
                if (item.equals("Freeman-Durden Wishart")) {
                    DialogUtils.enableComponents((JComponent)PolarimetricClassificationOpUI.this.numInitialClassesLabel, (JComponent)PolarimetricClassificationOpUI.this.numInitialClasses, (boolean)true);
                    DialogUtils.enableComponents((JComponent)PolarimetricClassificationOpUI.this.numFinalClassesLabel, (JComponent)PolarimetricClassificationOpUI.this.numFinalClasses, (boolean)true);
                    DialogUtils.enableComponents((JComponent)PolarimetricClassificationOpUI.this.mixedCategoryThresholdLabel, (JComponent)PolarimetricClassificationOpUI.this.mixedCategoryThreshold, (boolean)true);
                } else {
                    DialogUtils.enableComponents((JComponent)PolarimetricClassificationOpUI.this.numInitialClassesLabel, (JComponent)PolarimetricClassificationOpUI.this.numInitialClasses, (boolean)false);
                    DialogUtils.enableComponents((JComponent)PolarimetricClassificationOpUI.this.numFinalClassesLabel, (JComponent)PolarimetricClassificationOpUI.this.numFinalClasses, (boolean)false);
                    DialogUtils.enableComponents((JComponent)PolarimetricClassificationOpUI.this.mixedCategoryThresholdLabel, (JComponent)PolarimetricClassificationOpUI.this.mixedCategoryThreshold, (boolean)false);
                }
            }
        });
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.windowSizeLabel, (JComponent)this.windowSize);
        DialogUtils.enableComponents((JComponent)this.windowSizeLabel, (JComponent)this.windowSize, (boolean)true);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.maxIterationsLabel, (JComponent)this.maxIterations);
        DialogUtils.enableComponents((JComponent)this.maxIterationsLabel, (JComponent)this.maxIterations, (boolean)false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.numInitialClassesLabel, (JComponent)this.numInitialClasses);
        DialogUtils.enableComponents((JComponent)this.numInitialClassesLabel, (JComponent)this.numInitialClasses, (boolean)false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.numFinalClassesLabel, (JComponent)this.numFinalClasses);
        DialogUtils.enableComponents((JComponent)this.numFinalClassesLabel, (JComponent)this.numFinalClasses, (boolean)false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.mixedCategoryThresholdLabel, (JComponent)this.mixedCategoryThreshold);
        DialogUtils.enableComponents((JComponent)this.mixedCategoryThresholdLabel, (JComponent)this.mixedCategoryThreshold, (boolean)false);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

