/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowActivityEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineSchemaUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.TestFlowDataGenerator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHBaseStorageFlowActivity {
    private static HBaseTestingUtility util;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        util = new HBaseTestingUtility();
        Configuration conf = util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        util.startMiniCluster();
        DataGeneratorForTest.createSchema(util.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFlowRunMinMax() throws Exception {
        TimelineEntities te = new TimelineEntities();
        te.addEntity(TestFlowDataGenerator.getEntity1());
        HBaseTimelineWriterImpl hbi = null;
        Configuration c1 = util.getConfiguration();
        String cluster = "testWriteFlowRunMinMaxToHBase_cluster1";
        String user = "testWriteFlowRunMinMaxToHBase_user1";
        String flow = "testing_flowRun_flow_name";
        String flowVersion = "CF7022C10F1354";
        long runid = 1002345678919L;
        String appName = "application_100000000000_1111";
        long minStartTs = 1424995200300L;
        long greaterStartTs = 1424996064300L;
        long endTs = 1425081200300L;
        TimelineEntity entityMinStartTime = TestFlowDataGenerator.getEntityMinStartTime(minStartTs);
        try {
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)user);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            te = new TimelineEntities();
            te.addEntity(entityMinStartTime);
            appName = "application_100000000000_3333";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            TimelineEntity entityMaxEndTime = TestFlowDataGenerator.getEntityMaxEndTime(endTs);
            te = new TimelineEntities();
            te.addEntity(entityMaxEndTime);
            appName = "application_100000000000_4444";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            TimelineEntity entityGreaterStartTime = TestFlowDataGenerator.getEntityGreaterStartTime(greaterStartTs);
            te = new TimelineEntities();
            te.addEntity(entityGreaterStartTime);
            appName = "application_1000000000000000_2222";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            hbi.flush();
        }
        finally {
            if (hbi != null) {
                hbi.close();
            }
        }
        Connection conn = ConnectionFactory.createConnection((Configuration)c1);
        Table table1 = conn.getTable(BaseTableRW.getTableName((Configuration)c1, (String)"yarn.timeline-service..flowactivity.table.name", (String)"timelineservice.flowactivity"));
        byte[] startRow = new FlowActivityRowKey(cluster, Long.valueOf(minStartTs), user, flow).getRowKey();
        Get g = new Get(startRow);
        Result r1 = table1.get(g);
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((!r1.isEmpty() ? 1 : 0) != 0);
        NavigableMap values = r1.getFamilyMap(FlowActivityColumnFamily.INFO.getBytes());
        Assert.assertEquals((long)1L, (long)values.size());
        byte[] row = r1.getRow();
        FlowActivityRowKey flowActivityRowKey = FlowActivityRowKey.parseRowKey((byte[])row);
        Assert.assertNotNull((Object)flowActivityRowKey);
        Assert.assertEquals((Object)cluster, (Object)flowActivityRowKey.getClusterId());
        Assert.assertEquals((Object)user, (Object)flowActivityRowKey.getUserId());
        Assert.assertEquals((Object)flow, (Object)flowActivityRowKey.getFlowName());
        Long dayTs = HBaseTimelineSchemaUtils.getTopOfTheDayTimestamp((long)minStartTs);
        Assert.assertEquals((Object)dayTs, (Object)flowActivityRowKey.getDayTimestamp());
        Assert.assertEquals((long)1L, (long)values.size());
        this.checkFlowActivityRunId(runid, flowVersion, values);
        try (HBaseTimelineReaderImpl hbr = null;){
            hbr = new HBaseTimelineReaderImpl();
            hbr.init(c1);
            hbr.start();
            Set entities = hbr.getEntities(new TimelineReaderContext(cluster, null, null, null, null, TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), null), new TimelineEntityFilters.Builder().entityLimit(Long.valueOf(10L)).build(), new TimelineDataToRetrieve());
            Assert.assertEquals((long)1L, (long)entities.size());
            for (TimelineEntity e : entities) {
                FlowActivityEntity flowActivity = (FlowActivityEntity)e;
                Assert.assertEquals((Object)cluster, (Object)flowActivity.getCluster());
                Assert.assertEquals((Object)user, (Object)flowActivity.getUser());
                Assert.assertEquals((Object)flow, (Object)flowActivity.getFlowName());
                Assert.assertEquals((Object)dayTs, (Object)flowActivity.getDate().getTime());
                NavigableSet flowRuns = flowActivity.getFlowRuns();
                Assert.assertEquals((long)1L, (long)flowRuns.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFlowActivityOneFlow() throws Exception {
        String cluster = "testWriteFlowActivityOneFlow_cluster1";
        String user = "testWriteFlowActivityOneFlow_user1";
        String flow = "flow_activity_test_flow_name";
        String flowVersion = "A122110F135BC4";
        long runid = 1001111178919L;
        TimelineEntities te = new TimelineEntities();
        long appCreatedTime = 1425016501000L;
        TimelineEntity entityApp1 = TestFlowDataGenerator.getFlowApp1(appCreatedTime);
        te.addEntity(entityApp1);
        Configuration c1 = util.getConfiguration();
        try (HBaseTimelineWriterImpl hbi = null;){
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            String appName = "application_1111999999_1234";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, UserGroupInformation.createRemoteUser((String)user));
            hbi.flush();
        }
        this.checkFlowActivityTable(cluster, user, flow, flowVersion, runid, c1, appCreatedTime);
        try (HBaseTimelineReaderImpl hbr = null;){
            hbr = new HBaseTimelineReaderImpl();
            hbr.init(c1);
            hbr.start();
            Set entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, null, null, TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), null), new TimelineEntityFilters.Builder().entityLimit(Long.valueOf(10L)).build(), new TimelineDataToRetrieve());
            Assert.assertEquals((long)1L, (long)entities.size());
            for (TimelineEntity e : entities) {
                FlowActivityEntity entity = (FlowActivityEntity)e;
                NavigableSet flowRuns = entity.getFlowRuns();
                Assert.assertEquals((long)1L, (long)flowRuns.size());
                for (FlowRunEntity flowRun : flowRuns) {
                    Assert.assertEquals((long)runid, (long)flowRun.getRunId());
                    Assert.assertEquals((Object)flowVersion, (Object)flowRun.getVersion());
                }
            }
        }
    }

    private void checkFlowActivityTable(String cluster, String user, String flow, String flowVersion, long runid, Configuration c1, long appCreatedTime) throws IOException {
        Scan s = new Scan();
        s.addFamily(FlowActivityColumnFamily.INFO.getBytes());
        byte[] startRow = new FlowActivityRowKey(cluster, Long.valueOf(appCreatedTime), user, flow).getRowKey();
        s.setStartRow(startRow);
        String clusterStop = cluster + "1";
        byte[] stopRow = new FlowActivityRowKey(clusterStop, Long.valueOf(appCreatedTime), user, flow).getRowKey();
        s.setStopRow(stopRow);
        Connection conn = ConnectionFactory.createConnection((Configuration)c1);
        Table table1 = conn.getTable(BaseTableRW.getTableName((Configuration)c1, (String)"yarn.timeline-service..flowactivity.table.name", (String)"timelineservice.flowactivity"));
        ResultScanner scanner = table1.getScanner(s);
        int rowCount = 0;
        for (Result result : scanner) {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            NavigableMap values = result.getFamilyMap(FlowActivityColumnFamily.INFO.getBytes());
            ++rowCount;
            byte[] row = result.getRow();
            FlowActivityRowKey flowActivityRowKey = FlowActivityRowKey.parseRowKey((byte[])row);
            Assert.assertNotNull((Object)flowActivityRowKey);
            Assert.assertEquals((Object)cluster, (Object)flowActivityRowKey.getClusterId());
            Assert.assertEquals((Object)user, (Object)flowActivityRowKey.getUserId());
            Assert.assertEquals((Object)flow, (Object)flowActivityRowKey.getFlowName());
            Long dayTs = HBaseTimelineSchemaUtils.getTopOfTheDayTimestamp((long)appCreatedTime);
            Assert.assertEquals((Object)dayTs, (Object)flowActivityRowKey.getDayTimestamp());
            Assert.assertEquals((long)1L, (long)values.size());
            this.checkFlowActivityRunId(runid, flowVersion, values);
        }
        Assert.assertEquals((long)1L, (long)rowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlowActivityTableOneFlowMultipleRunIds() throws IOException {
        String cluster = "testManyRunsFlowActivity_cluster1";
        String user = "testManyRunsFlowActivity_c_user1";
        String flow = "flow_activity_test_flow_name";
        String flowVersion1 = "A122110F135BC4";
        long runid1 = 11111111111L;
        String flowVersion2 = "A12222222222C4";
        long runid2 = 2222222222222L;
        String flowVersion3 = "A1333333333C4";
        long runid3 = 3333333333333L;
        TimelineEntities te = new TimelineEntities();
        long appCreatedTime = 1425016501000L;
        TimelineEntity entityApp1 = TestFlowDataGenerator.getFlowApp1(appCreatedTime);
        te.addEntity(entityApp1);
        Configuration c1 = util.getConfiguration();
        try (HBaseTimelineWriterImpl hbi = null;){
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)user);
            String appName = "application_11888888888_1111";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion1, Long.valueOf(runid1), appName), te, remoteUser);
            te = new TimelineEntities();
            te.addEntity(entityApp1);
            appName = "application_11888888888_2222";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion2, Long.valueOf(runid2), appName), te, remoteUser);
            te = new TimelineEntities();
            te.addEntity(entityApp1);
            appName = "application_11888888888_3333";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion3, Long.valueOf(runid3), appName), te, remoteUser);
            hbi.flush();
        }
        this.checkFlowActivityTableSeveralRuns(cluster, user, flow, c1, flowVersion1, runid1, flowVersion2, runid2, flowVersion3, runid3, appCreatedTime);
        try (HBaseTimelineReaderImpl hbr = null;){
            hbr = new HBaseTimelineReaderImpl();
            hbr.init(c1);
            hbr.start();
            Set entities = hbr.getEntities(new TimelineReaderContext(cluster, null, null, null, null, TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), null), new TimelineEntityFilters.Builder().entityLimit(Long.valueOf(10L)).build(), new TimelineDataToRetrieve());
            Assert.assertEquals((long)1L, (long)entities.size());
            for (TimelineEntity e : entities) {
                FlowActivityEntity flowActivity = (FlowActivityEntity)e;
                Assert.assertEquals((Object)cluster, (Object)flowActivity.getCluster());
                Assert.assertEquals((Object)user, (Object)flowActivity.getUser());
                Assert.assertEquals((Object)flow, (Object)flowActivity.getFlowName());
                long dayTs = HBaseTimelineSchemaUtils.getTopOfTheDayTimestamp((long)appCreatedTime);
                Assert.assertEquals((long)dayTs, (long)flowActivity.getDate().getTime());
                NavigableSet flowRuns = flowActivity.getFlowRuns();
                Assert.assertEquals((long)3L, (long)flowRuns.size());
                for (FlowRunEntity flowRun : flowRuns) {
                    long runId = flowRun.getRunId();
                    String version = flowRun.getVersion();
                    if (runId == runid1) {
                        Assert.assertEquals((Object)flowVersion1, (Object)version);
                        continue;
                    }
                    if (runId == runid2) {
                        Assert.assertEquals((Object)flowVersion2, (Object)version);
                        continue;
                    }
                    if (runId == runid3) {
                        Assert.assertEquals((Object)flowVersion3, (Object)version);
                        continue;
                    }
                    Assert.fail((String)("unknown run id: " + runId));
                }
            }
        }
    }

    private void checkFlowActivityTableSeveralRuns(String cluster, String user, String flow, Configuration c1, String flowVersion1, long runid1, String flowVersion2, long runid2, String flowVersion3, long runid3, long appCreatedTime) throws IOException {
        Scan s = new Scan();
        s.addFamily(FlowActivityColumnFamily.INFO.getBytes());
        byte[] startRow = new FlowActivityRowKey(cluster, Long.valueOf(appCreatedTime), user, flow).getRowKey();
        s.setStartRow(startRow);
        String clusterStop = cluster + "1";
        byte[] stopRow = new FlowActivityRowKey(clusterStop, Long.valueOf(appCreatedTime), user, flow).getRowKey();
        s.setStopRow(stopRow);
        Connection conn = ConnectionFactory.createConnection((Configuration)c1);
        Table table1 = conn.getTable(BaseTableRW.getTableName((Configuration)c1, (String)"yarn.timeline-service..flowactivity.table.name", (String)"timelineservice.flowactivity"));
        ResultScanner scanner = table1.getScanner(s);
        int rowCount = 0;
        for (Result result : scanner) {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            byte[] row = result.getRow();
            FlowActivityRowKey flowActivityRowKey = FlowActivityRowKey.parseRowKey((byte[])row);
            Assert.assertNotNull((Object)flowActivityRowKey);
            Assert.assertEquals((Object)cluster, (Object)flowActivityRowKey.getClusterId());
            Assert.assertEquals((Object)user, (Object)flowActivityRowKey.getUserId());
            Assert.assertEquals((Object)flow, (Object)flowActivityRowKey.getFlowName());
            Long dayTs = HBaseTimelineSchemaUtils.getTopOfTheDayTimestamp((long)appCreatedTime);
            Assert.assertEquals((Object)dayTs, (Object)flowActivityRowKey.getDayTimestamp());
            NavigableMap values = result.getFamilyMap(FlowActivityColumnFamily.INFO.getBytes());
            ++rowCount;
            Assert.assertEquals((long)3L, (long)values.size());
            this.checkFlowActivityRunId(runid1, flowVersion1, values);
            this.checkFlowActivityRunId(runid2, flowVersion2, values);
            this.checkFlowActivityRunId(runid3, flowVersion3, values);
        }
        Assert.assertEquals((long)1L, (long)rowCount);
    }

    private void checkFlowActivityRunId(long runid, String flowVersion, Map<byte[], byte[]> values) throws IOException {
        byte[] rq = ColumnHelper.getColumnQualifier((byte[])FlowActivityColumnPrefix.RUN_ID.getColumnPrefixBytes(), (byte[])GenericObjectMapper.write((Object)runid));
        for (Map.Entry<byte[], byte[]> k : values.entrySet()) {
            String actualQ = Bytes.toString((byte[])k.getKey());
            if (!Bytes.toString((byte[])rq).equals(actualQ)) continue;
            String actualV = (String)GenericObjectMapper.read((byte[])k.getValue());
            Assert.assertEquals((Object)flowVersion, (Object)actualV);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (util != null) {
            util.shutdownMiniCluster();
        }
    }
}

