/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderServer;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineReaderHBaseDown {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTimelineReaderHBaseUp() throws Exception {
        HBaseTestingUtility util = new HBaseTestingUtility();
        TestTimelineReaderHBaseDown.configure(util);
        try {
            util.startMiniCluster();
            DataGeneratorForTest.createSchema(util.getConfiguration());
            DataGeneratorForTest.loadApps(util, System.currentTimeMillis());
            TimelineReaderServer server = TestTimelineReaderHBaseDown.getTimelineReaderServer();
            server.init(util.getConfiguration());
            HBaseTimelineReaderImpl htr = TestTimelineReaderHBaseDown.getHBaseTimelineReaderImpl(server);
            server.start();
            TestTimelineReaderHBaseDown.checkQuery(htr);
        }
        finally {
            util.shutdownMiniCluster();
        }
    }

    @Test(timeout=300000L)
    public void testTimelineReaderInitWhenHBaseIsDown() throws TimeoutException, InterruptedException {
        HBaseTestingUtility util = new HBaseTestingUtility();
        TestTimelineReaderHBaseDown.configure(util);
        TimelineReaderServer server = TestTimelineReaderHBaseDown.getTimelineReaderServer();
        server.init(util.getConfiguration());
        HBaseTimelineReaderImpl htr = TestTimelineReaderHBaseDown.getHBaseTimelineReaderImpl(server);
        server.start();
        TestTimelineReaderHBaseDown.waitForHBaseDown(htr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTimelineReaderDetectsHBaseDown() throws Exception {
        HBaseTestingUtility util = new HBaseTestingUtility();
        TestTimelineReaderHBaseDown.configure(util);
        try {
            util.startMiniCluster();
            DataGeneratorForTest.createSchema(util.getConfiguration());
            DataGeneratorForTest.loadApps(util, System.currentTimeMillis());
            TimelineReaderServer server = TestTimelineReaderHBaseDown.getTimelineReaderServer();
            server.init(util.getConfiguration());
            HBaseTimelineReaderImpl htr = TestTimelineReaderHBaseDown.getHBaseTimelineReaderImpl(server);
            util.shutdownMiniHBaseCluster();
            server.start();
            TestTimelineReaderHBaseDown.waitForHBaseDown(htr);
        }
        finally {
            util.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTimelineReaderDetectsZooKeeperDown() throws Exception {
        HBaseTestingUtility util = new HBaseTestingUtility();
        TestTimelineReaderHBaseDown.configure(util);
        try {
            util.startMiniCluster();
            DataGeneratorForTest.createSchema(util.getConfiguration());
            DataGeneratorForTest.loadApps(util, System.currentTimeMillis());
            TimelineReaderServer server = TestTimelineReaderHBaseDown.getTimelineReaderServer();
            server.init(util.getConfiguration());
            HBaseTimelineReaderImpl htr = TestTimelineReaderHBaseDown.getHBaseTimelineReaderImpl(server);
            util.shutdownMiniCluster();
            server.start();
            TestTimelineReaderHBaseDown.waitForHBaseDown(htr);
        }
        finally {
            util.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTimelineReaderRecoversAfterHBaseReturns() throws Exception {
        HBaseTestingUtility util = new HBaseTestingUtility();
        TestTimelineReaderHBaseDown.configure(util);
        try {
            util.startMiniCluster();
            DataGeneratorForTest.createSchema(util.getConfiguration());
            DataGeneratorForTest.loadApps(util, System.currentTimeMillis());
            TimelineReaderServer server = TestTimelineReaderHBaseDown.getTimelineReaderServer();
            server.init(util.getConfiguration());
            HBaseTimelineReaderImpl htr = TestTimelineReaderHBaseDown.getHBaseTimelineReaderImpl(server);
            util.shutdownMiniHBaseCluster();
            server.start();
            TestTimelineReaderHBaseDown.waitForHBaseDown(htr);
            util.startMiniHBaseCluster(1, 1);
            GenericTestUtils.waitFor(() -> !htr.isHBaseDown(), (int)1000, (int)150000);
        }
        finally {
            util.shutdownMiniCluster();
        }
    }

    private static void waitForHBaseDown(HBaseTimelineReaderImpl htr) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> htr.isHBaseDown(), (int)1000, (int)150000);
        try {
            TestTimelineReaderHBaseDown.checkQuery(htr);
            Assert.fail((String)"Query should fail when HBase is down");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"HBase is down", (Object)e.getMessage());
        }
    }

    private static void checkQuery(HBaseTimelineReaderImpl htr) throws IOException {
        TimelineReaderContext context = new TimelineReaderContext("yarn_cluster", null, null, null, null, TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), null, null);
        Set entities = htr.getEntities(context, HBaseTimelineReaderImpl.MONITOR_FILTERS, HBaseTimelineReaderImpl.DATA_TO_RETRIEVE);
    }

    private static void configure(HBaseTestingUtility util) {
        Configuration config = util.getConfiguration();
        config.setBoolean("yarn.timeline-service.enabled", true);
        config.setFloat("yarn.timeline-service.version", 2.0f);
        config.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
        config.set("yarn.resourcemanager.cluster-id", "cluster1");
        config.set("yarn.timeline-service.reader.class", "org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl");
        config.setInt("hfile.format.version", 3);
        config.setLong("yarn.timeline-service.reader.storage-monitor.interval-ms", 5000L);
    }

    private static TimelineReaderServer getTimelineReaderServer() {
        return new TimelineReaderServer(){

            protected void addFilters(Configuration conf) {
            }
        };
    }

    private static HBaseTimelineReaderImpl getHBaseTimelineReaderImpl(TimelineReaderServer server) {
        for (Service s : server.getServices()) {
            if (!(s instanceof HBaseTimelineReaderImpl)) continue;
            return (HBaseTimelineReaderImpl)s;
        }
        throw new IllegalStateException("Couldn't find HBaseTimelineReaderImpl");
    }
}

