/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.NumericValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimestampGenerator;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowScanner;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowScannerOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.TestFlowDataGenerator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHBaseStorageFlowRunCompaction {
    private static HBaseTestingUtility util;
    private static final String METRIC1 = "MAP_SLOT_MILLIS";
    private static final String METRIC2 = "HDFS_BYTES_READ";
    private final byte[] aRowKey = Bytes.toBytes((String)"a");
    private final byte[] aFamily = Bytes.toBytes((String)"family");
    private final byte[] aQualifier = Bytes.toBytes((String)"qualifier");

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        util = new HBaseTestingUtility();
        Configuration conf = util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        util.startMiniCluster();
        DataGeneratorForTest.createSchema(util.getConfiguration());
    }

    @Test
    public void testWriteNonNumericData() throws Exception {
        String rowKey = "nonNumericRowKey";
        String column = "nonNumericColumnName";
        String value = "nonNumericValue";
        byte[] rowKeyBytes = Bytes.toBytes((String)rowKey);
        byte[] columnNameBytes = Bytes.toBytes((String)column);
        byte[] valueBytes = Bytes.toBytes((String)value);
        Put p = new Put(rowKeyBytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnNameBytes, valueBytes);
        Configuration hbaseConf = util.getConfiguration();
        Connection conn = null;
        conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
        Table flowRunTable = conn.getTable(BaseTable.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service..flowrun.table.name", (String)"timelineservice.flowrun"));
        flowRunTable.put(p);
        Get g = new Get(rowKeyBytes);
        Result r = flowRunTable.get(g);
        Assert.assertNotNull((Object)r);
        Assert.assertTrue((r.size() >= 1 ? 1 : 0) != 0);
        Cell actualValue = r.getColumnLatestCell(FlowRunColumnFamily.INFO.getBytes(), columnNameBytes);
        Assert.assertNotNull((Object)CellUtil.cloneValue((Cell)actualValue));
        Assert.assertEquals((Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)actualValue)), (Object)value);
    }

    @Test
    public void testWriteScanBatchLimit() throws Exception {
        NavigableMap values;
        NavigableMap values2;
        String rowKey = "nonNumericRowKey";
        String column = "nonNumericColumnName";
        String value = "nonNumericValue";
        String column2 = "nonNumericColumnName2";
        String value2 = "nonNumericValue2";
        String column3 = "nonNumericColumnName3";
        String value3 = "nonNumericValue3";
        String column4 = "nonNumericColumnName4";
        String value4 = "nonNumericValue4";
        byte[] rowKeyBytes = Bytes.toBytes((String)rowKey);
        byte[] columnNameBytes = Bytes.toBytes((String)column);
        byte[] valueBytes = Bytes.toBytes((String)value);
        byte[] columnName2Bytes = Bytes.toBytes((String)column2);
        byte[] value2Bytes = Bytes.toBytes((String)value2);
        byte[] columnName3Bytes = Bytes.toBytes((String)column3);
        byte[] value3Bytes = Bytes.toBytes((String)value3);
        byte[] columnName4Bytes = Bytes.toBytes((String)column4);
        byte[] value4Bytes = Bytes.toBytes((String)value4);
        Put p = new Put(rowKeyBytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnNameBytes, valueBytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnName2Bytes, value2Bytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnName3Bytes, value3Bytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnName4Bytes, value4Bytes);
        Configuration hbaseConf = util.getConfiguration();
        Connection conn = null;
        conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
        Table flowRunTable = conn.getTable(BaseTable.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service..flowrun.table.name", (String)"timelineservice.flowrun"));
        flowRunTable.put(p);
        String rowKey2 = "nonNumericRowKey2";
        byte[] rowKey2Bytes = Bytes.toBytes((String)rowKey2);
        p = new Put(rowKey2Bytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnNameBytes, valueBytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnName2Bytes, value2Bytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnName3Bytes, value3Bytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnName4Bytes, value4Bytes);
        flowRunTable.put(p);
        String rowKey3 = "nonNumericRowKey3";
        byte[] rowKey3Bytes = Bytes.toBytes((String)rowKey3);
        p = new Put(rowKey3Bytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnNameBytes, valueBytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnName2Bytes, value2Bytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnName3Bytes, value3Bytes);
        p.addColumn(FlowRunColumnFamily.INFO.getBytes(), columnName4Bytes, value4Bytes);
        flowRunTable.put(p);
        Scan s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        s.setStartRow(rowKeyBytes);
        int batchLimit = 2;
        s.setBatch(batchLimit);
        ResultScanner scanner = flowRunTable.getScanner(s);
        for (Result result : scanner) {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((result.rawCells().length <= batchLimit ? 1 : 0) != 0);
            values2 = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            Assert.assertTrue((values2.size() <= batchLimit ? 1 : 0) != 0);
        }
        s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        s.setStartRow(rowKeyBytes);
        batchLimit = 3;
        s.setBatch(batchLimit);
        scanner = flowRunTable.getScanner(s);
        for (Result result : scanner) {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((result.rawCells().length <= batchLimit ? 1 : 0) != 0);
            values2 = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            Assert.assertTrue((values2.size() <= batchLimit ? 1 : 0) != 0);
        }
        s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        s.setStartRow(rowKeyBytes);
        batchLimit = 1000;
        s.setBatch(batchLimit);
        scanner = flowRunTable.getScanner(s);
        int rowCount = 0;
        for (Result result : scanner) {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((result.rawCells().length <= batchLimit ? 1 : 0) != 0);
            values = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            Assert.assertTrue((values.size() <= batchLimit ? 1 : 0) != 0);
            Assert.assertEquals((long)4L, (long)values.size());
            ++rowCount;
        }
        Assert.assertEquals((long)3L, (long)rowCount);
        s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        s.setStartRow(rowKeyBytes);
        batchLimit = -2992;
        s.setBatch(batchLimit);
        scanner = flowRunTable.getScanner(s);
        rowCount = 0;
        for (Result result : scanner) {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assert.assertEquals((long)4L, (long)result.rawCells().length);
            values = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            Assert.assertEquals((long)4L, (long)values.size());
            ++rowCount;
        }
        Assert.assertEquals((long)3L, (long)rowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFlowRunCompaction() throws Exception {
        String cluster = "kompaction_cluster1";
        String user = "kompaction_FlowRun__user1";
        String flow = "kompaction_flowRun_flow_name";
        String flowVersion = "AF1021C19F1351";
        long runid = 1449526652000L;
        int start = 10;
        int count = 2000;
        int appIdSuffix = 1;
        HBaseTimelineWriterImpl hbi = null;
        long insertTs = System.currentTimeMillis() - (long)count;
        Configuration c1 = util.getConfiguration();
        TimelineEntities te1 = null;
        TimelineEntity entityApp1 = null;
        UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)user);
        try {
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            for (int i = start; i < start + count; ++i) {
                String appName = "application_10240000000000_" + appIdSuffix;
                te1 = new TimelineEntities();
                entityApp1 = TestFlowDataGenerator.getEntityMetricsApp1(++insertTs, c1);
                te1.addEntity(entityApp1);
                hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te1, remoteUser);
                appName = "application_2048000000000_7" + appIdSuffix;
                te1 = new TimelineEntities();
                entityApp1 = TestFlowDataGenerator.getEntityMetricsApp2(++insertTs);
                te1.addEntity(entityApp1);
                hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te1, remoteUser);
            }
        }
        finally {
            String appName = "application_10240000000000_" + appIdSuffix;
            te1 = new TimelineEntities();
            entityApp1 = TestFlowDataGenerator.getEntityMetricsApp1Complete(insertTs + 1L, c1);
            te1.addEntity(entityApp1);
            if (hbi != null) {
                hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te1, remoteUser);
                hbi.flush();
                hbi.close();
            }
        }
        HRegionServer server = util.getRSForFirstRegionInTable(BaseTable.getTableName((Configuration)c1, (String)"yarn.timeline-service..flowrun.table.name", (String)"timelineservice.flowrun"));
        List regions = server.getOnlineRegions(BaseTable.getTableName((Configuration)c1, (String)"yarn.timeline-service..flowrun.table.name", (String)"timelineservice.flowrun"));
        Assert.assertTrue((String)"Didn't find any regions for primary table!", (regions.size() > 0 ? 1 : 0) != 0);
        for (Region region : regions) {
            region.flush(true);
            region.compact(true);
        }
        this.checkFlowRunTable(cluster, user, flow, runid, c1, 4);
    }

    private void checkFlowRunTable(String cluster, String user, String flow, long runid, Configuration c1, int valueCount) throws IOException {
        Scan s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        byte[] startRow = new FlowRunRowKey(cluster, user, flow, Long.valueOf(runid)).getRowKey();
        s.setStartRow(startRow);
        String clusterStop = cluster + "1";
        byte[] stopRow = new FlowRunRowKey(clusterStop, user, flow, Long.valueOf(runid)).getRowKey();
        s.setStopRow(stopRow);
        Connection conn = ConnectionFactory.createConnection((Configuration)c1);
        Table table1 = conn.getTable(BaseTable.getTableName((Configuration)c1, (String)"yarn.timeline-service..flowrun.table.name", (String)"timelineservice.flowrun"));
        ResultScanner scanner = table1.getScanner(s);
        int rowCount = 0;
        for (Result result : scanner) {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            NavigableMap values = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            Assert.assertEquals((long)valueCount, (long)values.size());
            ++rowCount;
            byte[] q = ColumnHelper.getColumnQualifier((byte[])FlowRunColumnPrefix.METRIC.getColumnPrefixBytes(), (String)METRIC1);
            Assert.assertTrue((boolean)values.containsKey(q));
            Assert.assertEquals((long)141L, (long)Bytes.toLong((byte[])((byte[])values.get(q))));
            q = ColumnHelper.getColumnQualifier((byte[])FlowRunColumnPrefix.METRIC.getColumnPrefixBytes(), (String)METRIC2);
            Assert.assertTrue((boolean)values.containsKey(q));
            Assert.assertEquals((long)57L, (long)Bytes.toLong((byte[])((byte[])values.get(q))));
        }
        Assert.assertEquals((long)1L, (long)rowCount);
    }

    private FlowScanner getFlowScannerForTestingCompaction() {
        CompactionRequest request = new CompactionRequest();
        request.setIsMajor(true, true);
        FlowScanner fs = new FlowScanner(null, null, request.isMajor() ? FlowScannerOperation.MAJOR_COMPACTION : FlowScannerOperation.MINOR_COMPACTION);
        Assert.assertNotNull((Object)fs);
        return fs;
    }

    @Test
    public void checkProcessSummationMoreCellsSumFinal2() throws IOException {
        long cellValue1 = 1236L;
        long cellValue2 = 28L;
        long cellValue3 = 1236L;
        long cellValue4 = 1236L;
        FlowScanner fs = this.getFlowScannerForTestingCompaction();
        long currentTimestamp = System.currentTimeMillis();
        long cell1Ts = 1200120L;
        long cell2Ts = TimestampGenerator.getSupplementedTimestamp((long)System.currentTimeMillis(), (String)"application_123746661110_11202");
        long cell3Ts = 1277719L;
        long cell4Ts = currentTimestamp - 10L;
        TreeSet<Cell> currentColumnCells = new TreeSet<Cell>((Comparator<Cell>)KeyValue.COMPARATOR);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Tag t = new Tag(AggregationOperation.SUM_FINAL.getTagType(), "application_1234588888_91188");
        tags.add(t);
        byte[] tagByteArray = Tag.fromList(tags);
        Cell c1 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)cell1Ts, (byte[])Bytes.toBytes((long)cellValue1), (byte[])tagByteArray);
        currentColumnCells.add(c1);
        tags = new ArrayList();
        t = new Tag(AggregationOperation.SUM_FINAL.getTagType(), "application_12700000001_29102");
        tags.add(t);
        tagByteArray = Tag.fromList(tags);
        Cell c2 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)cell2Ts, (byte[])Bytes.toBytes((long)cellValue2), (byte[])tagByteArray);
        currentColumnCells.add(c2);
        tags = new ArrayList();
        t = new Tag(AggregationOperation.SUM.getTagType(), "application_191780000000001_8195");
        tags.add(t);
        tagByteArray = Tag.fromList(tags);
        Cell c3 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)cell3Ts, (byte[])Bytes.toBytes((long)cellValue3), (byte[])tagByteArray);
        currentColumnCells.add(c3);
        tags = new ArrayList();
        t = new Tag(AggregationOperation.SUM.getTagType(), "application_191780000000001_98104");
        tags.add(t);
        tagByteArray = Tag.fromList(tags);
        Cell c4 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)cell4Ts, (byte[])Bytes.toBytes((long)cellValue4), (byte[])tagByteArray);
        currentColumnCells.add(c4);
        List cells = fs.processSummationMajorCompaction(currentColumnCells, (NumericValueConverter)new LongConverter(), currentTimestamp);
        Assert.assertNotNull((Object)cells);
        Assert.assertEquals((long)4L, (long)cells.size());
        for (int i = 0; i < cells.size(); ++i) {
            Cell returnedCell = (Cell)cells.get(0);
            Assert.assertNotNull((Object)returnedCell);
            long returnTs = returnedCell.getTimestamp();
            long returnValue = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)returnedCell));
            if (returnValue == cellValue2) {
                Assert.assertTrue((returnTs == cell2Ts ? 1 : 0) != 0);
                continue;
            }
            if (returnValue == cellValue3) {
                Assert.assertTrue((returnTs == cell3Ts ? 1 : 0) != 0);
                continue;
            }
            if (returnValue == cellValue4) {
                Assert.assertTrue((returnTs == cell4Ts ? 1 : 0) != 0);
                continue;
            }
            if (returnValue == cellValue1) {
                Assert.assertTrue((returnTs != cell1Ts ? 1 : 0) != 0);
                Assert.assertTrue((returnTs > cell1Ts ? 1 : 0) != 0);
                Assert.assertTrue((returnTs >= currentTimestamp ? 1 : 0) != 0);
                continue;
            }
            Assert.fail();
        }
    }

    @Test
    public void checkProcessSummationMoreCellsSumFinalMany() throws IOException {
        byte[] tagByteArray;
        int i;
        long cellTsNotFinalStart;
        long cellTsFinalStart;
        FlowScanner fs = this.getFlowScannerForTestingCompaction();
        int count = 200000;
        long cellValueFinal = 1000L;
        long cellValueNotFinal = 28L;
        long currentTimestamp = System.currentTimeMillis();
        long cellTsFinal = cellTsFinalStart = 10001120L;
        long cellTsNotFinal = cellTsNotFinalStart = currentTimestamp - 5L;
        TreeSet<Cell> currentColumnCells = new TreeSet<Cell>((Comparator<Cell>)KeyValue.COMPARATOR);
        ArrayList<Tag> tags = null;
        Tag t = null;
        Cell c1 = null;
        for (i = 0; i < count; ++i) {
            tags = new ArrayList<Tag>();
            t = new Tag(AggregationOperation.SUM_FINAL.getTagType(), "application_123450000" + i + "01_19" + i);
            tags.add(t);
            tagByteArray = Tag.fromList(tags);
            c1 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)cellTsFinal, (byte[])Bytes.toBytes((long)cellValueFinal), (byte[])tagByteArray);
            currentColumnCells.add(c1);
            ++cellTsFinal;
        }
        for (i = 0; i < count; ++i) {
            tags = new ArrayList();
            t = new Tag(AggregationOperation.SUM.getTagType(), "application_1987650000" + i + "83_911" + i);
            tags.add(t);
            tagByteArray = Tag.fromList(tags);
            c1 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)cellTsNotFinal, (byte[])Bytes.toBytes((long)cellValueNotFinal), (byte[])tagByteArray);
            currentColumnCells.add(c1);
            ++cellTsNotFinal;
        }
        List cells = fs.processSummationMajorCompaction(currentColumnCells, (NumericValueConverter)new LongConverter(), currentTimestamp);
        Assert.assertNotNull((Object)cells);
        Assert.assertEquals((long)(count + 1), (long)cells.size());
        for (int i2 = 0; i2 < cells.size(); ++i2) {
            Cell returnedCell = (Cell)cells.get(0);
            Assert.assertNotNull((Object)returnedCell);
            long returnTs = returnedCell.getTimestamp();
            long returnValue = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)returnedCell));
            if (returnValue == (long)count * cellValueFinal) {
                Assert.assertTrue((returnTs > cellTsFinalStart + (long)count ? 1 : 0) != 0);
                Assert.assertTrue((returnTs >= currentTimestamp ? 1 : 0) != 0);
                continue;
            }
            if (returnValue >= cellValueNotFinal && returnValue <= cellValueNotFinal * (long)count) {
                Assert.assertTrue((returnTs >= cellTsNotFinalStart ? 1 : 0) != 0);
                Assert.assertTrue((returnTs <= cellTsNotFinalStart * (long)count ? 1 : 0) != 0);
                continue;
            }
            Assert.fail();
        }
    }

    @Test
    public void checkProcessSummationMoreCellsSumFinalVariedTags() throws IOException {
        byte[] tagByteArray;
        int i;
        long cellTsNotFinalStart;
        long cellTsFinalStartNotExpire;
        long cellTsFinalStart;
        FlowScanner fs = this.getFlowScannerForTestingCompaction();
        int countFinal = 20100;
        int countNotFinal = 1000;
        int countFinalNotExpire = 7009;
        long cellValueFinal = 1000L;
        long cellValueNotFinal = 28L;
        long currentTimestamp = System.currentTimeMillis();
        long cellTsFinal = cellTsFinalStart = 10001120L;
        long cellTsFinalNotExpire = cellTsFinalStartNotExpire = TimestampGenerator.getSupplementedTimestamp((long)System.currentTimeMillis(), (String)"application_10266666661166_118821");
        long cellTsNotFinal = cellTsNotFinalStart = currentTimestamp - 5L;
        TreeSet<Cell> currentColumnCells = new TreeSet<Cell>((Comparator<Cell>)KeyValue.COMPARATOR);
        ArrayList<Tag> tags = null;
        Tag t = null;
        Cell c1 = null;
        for (i = 0; i < countFinal; ++i) {
            tags = new ArrayList<Tag>();
            t = new Tag(AggregationOperation.SUM_FINAL.getTagType(), "application_123450000" + i + "01_19" + i);
            tags.add(t);
            tagByteArray = Tag.fromList(tags);
            c1 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)cellTsFinal, (byte[])Bytes.toBytes((long)cellValueFinal), (byte[])tagByteArray);
            currentColumnCells.add(c1);
            ++cellTsFinal;
        }
        for (i = 0; i < countFinalNotExpire; ++i) {
            tags = new ArrayList();
            t = new Tag(AggregationOperation.SUM_FINAL.getTagType(), "application_123450000" + i + "01_19" + i);
            tags.add(t);
            tagByteArray = Tag.fromList(tags);
            c1 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)cellTsFinalNotExpire, (byte[])Bytes.toBytes((long)cellValueFinal), (byte[])tagByteArray);
            currentColumnCells.add(c1);
            ++cellTsFinalNotExpire;
        }
        for (i = 0; i < countNotFinal; ++i) {
            tags = new ArrayList();
            t = new Tag(AggregationOperation.SUM.getTagType(), "application_1987650000" + i + "83_911" + i);
            tags.add(t);
            tagByteArray = Tag.fromList(tags);
            c1 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)cellTsNotFinal, (byte[])Bytes.toBytes((long)cellValueNotFinal), (byte[])tagByteArray);
            currentColumnCells.add(c1);
            ++cellTsNotFinal;
        }
        List cells = fs.processSummationMajorCompaction(currentColumnCells, (NumericValueConverter)new LongConverter(), currentTimestamp);
        Assert.assertNotNull((Object)cells);
        Assert.assertEquals((long)(countFinalNotExpire + countNotFinal + 1), (long)cells.size());
        for (int i2 = 0; i2 < cells.size(); ++i2) {
            Cell returnedCell = (Cell)cells.get(0);
            Assert.assertNotNull((Object)returnedCell);
            long returnTs = returnedCell.getTimestamp();
            long returnValue = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)returnedCell));
            if (returnValue == (long)countFinal * cellValueFinal) {
                Assert.assertTrue((returnTs > cellTsFinalStart + (long)countFinal ? 1 : 0) != 0);
                Assert.assertTrue((returnTs >= currentTimestamp ? 1 : 0) != 0);
                continue;
            }
            if (returnValue == cellValueNotFinal) {
                Assert.assertTrue((returnTs >= cellTsNotFinalStart ? 1 : 0) != 0);
                Assert.assertTrue((returnTs <= cellTsNotFinalStart + (long)countNotFinal ? 1 : 0) != 0);
                continue;
            }
            if (returnValue == cellValueFinal) {
                Assert.assertTrue((returnTs >= cellTsFinalStartNotExpire ? 1 : 0) != 0);
                Assert.assertTrue((returnTs <= cellTsFinalStartNotExpire + (long)countFinalNotExpire ? 1 : 0) != 0);
                continue;
            }
            Assert.fail();
        }
    }

    @Test
    public void testProcessSummationMoreCellsSumFinal() throws IOException {
        FlowScanner fs = this.getFlowScannerForTestingCompaction();
        long currentTimestamp = System.currentTimeMillis();
        long cellValue1 = 1236L;
        long cellValue2 = 28L;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Tag t = new Tag(AggregationOperation.SUM_FINAL.getTagType(), "application_1234588888_999888");
        tags.add(t);
        byte[] tagByteArray = Tag.fromList(tags);
        TreeSet<Cell> currentColumnCells = new TreeSet<Cell>((Comparator<Cell>)KeyValue.COMPARATOR);
        Cell c1 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)120L, (byte[])Bytes.toBytes((long)cellValue1), (byte[])tagByteArray);
        currentColumnCells.add(c1);
        tags = new ArrayList();
        t = new Tag(AggregationOperation.SUM.getTagType(), "application_100000000001_119101");
        tags.add(t);
        tagByteArray = Tag.fromList(tags);
        Cell c2 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)130L, (byte[])Bytes.toBytes((long)cellValue2), (byte[])tagByteArray);
        currentColumnCells.add(c2);
        List cells = fs.processSummationMajorCompaction(currentColumnCells, (NumericValueConverter)new LongConverter(), currentTimestamp);
        Assert.assertNotNull((Object)cells);
        Assert.assertEquals((long)2L, (long)cells.size());
        Cell returnedCell = (Cell)cells.get(0);
        Assert.assertNotNull((Object)returnedCell);
        long inputTs1 = c1.getTimestamp();
        long inputTs2 = c2.getTimestamp();
        long returnTs = returnedCell.getTimestamp();
        long returnValue = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)returnedCell));
        if (returnValue == cellValue2) {
            Assert.assertTrue((returnTs == inputTs2 ? 1 : 0) != 0);
        } else if (returnValue == cellValue1) {
            Assert.assertTrue((returnTs >= currentTimestamp ? 1 : 0) != 0);
            Assert.assertTrue((returnTs != inputTs1 ? 1 : 0) != 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testProcessSummationOneCellSumFinal() throws IOException {
        FlowScanner fs = this.getFlowScannerForTestingCompaction();
        long currentTimestamp = System.currentTimeMillis();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Tag t = new Tag(AggregationOperation.SUM_FINAL.getTagType(), "application_123458888888_999888");
        tags.add(t);
        byte[] tagByteArray = Tag.fromList(tags);
        TreeSet<Cell> currentColumnCells = new TreeSet<Cell>((Comparator<Cell>)KeyValue.COMPARATOR);
        Cell c1 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)120L, (byte[])Bytes.toBytes((long)1110L), (byte[])tagByteArray);
        currentColumnCells.add(c1);
        List cells = fs.processSummationMajorCompaction(currentColumnCells, (NumericValueConverter)new LongConverter(), currentTimestamp);
        Assert.assertNotNull((Object)cells);
        Assert.assertEquals((long)1L, (long)cells.size());
        Cell returnedCell = (Cell)cells.get(0);
        Assert.assertNotEquals((Object)c1, (Object)returnedCell);
        long inputTs = c1.getTimestamp();
        long returnTs = returnedCell.getTimestamp();
        Assert.assertTrue((returnTs > inputTs ? 1 : 0) != 0);
        Assert.assertTrue((returnTs >= currentTimestamp ? 1 : 0) != 0);
    }

    @Test
    public void testProcessSummationOneCell() throws IOException {
        FlowScanner fs = this.getFlowScannerForTestingCompaction();
        long currentTimestamp = System.currentTimeMillis();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Tag t = new Tag(AggregationOperation.SUM.getTagType(), "application_123458888888_999888");
        tags.add(t);
        byte[] tagByteArray = Tag.fromList(tags);
        TreeSet<Cell> currentColumnCells = new TreeSet<Cell>((Comparator<Cell>)KeyValue.COMPARATOR);
        Cell c1 = HBaseTimelineStorageUtils.createNewCell((byte[])this.aRowKey, (byte[])this.aFamily, (byte[])this.aQualifier, (long)currentTimestamp, (byte[])Bytes.toBytes((long)1110L), (byte[])tagByteArray);
        currentColumnCells.add(c1);
        List cells = fs.processSummationMajorCompaction(currentColumnCells, (NumericValueConverter)new LongConverter(), currentTimestamp);
        Assert.assertNotNull((Object)cells);
        Assert.assertEquals((long)1L, (long)cells.size());
        Cell c2 = (Cell)cells.get(0);
        Assert.assertEquals((Object)c1, (Object)c2);
        Assert.assertEquals((long)currentTimestamp, (long)c2.getTimestamp());
    }

    @Test
    public void testProcessSummationEmpty() throws IOException {
        FlowScanner fs = this.getFlowScannerForTestingCompaction();
        long currentTimestamp = System.currentTimeMillis();
        LongConverter longConverter = new LongConverter();
        TreeSet currentColumnCells = null;
        List cells = fs.processSummationMajorCompaction(currentColumnCells, (NumericValueConverter)longConverter, currentTimestamp);
        Assert.assertNotNull((Object)cells);
        Assert.assertEquals((long)0L, (long)cells.size());
        currentColumnCells = new TreeSet(KeyValue.COMPARATOR);
        cells = fs.processSummationMajorCompaction(currentColumnCells, (NumericValueConverter)longConverter, currentTimestamp);
        Assert.assertNotNull((Object)cells);
        Assert.assertEquals((long)0L, (long)cells.size());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }
}

