/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.FsActionParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.StartAfterParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestWebHdfsUrl {
    final URI uri = URI.create("webhdfs://127.0.0.1:0");

    @Before
    public void resetUGI() {
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
    }

    @Test(timeout=60000L)
    public void testEncodedPathUrl() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)this.uri, (Configuration)conf);
        String pathName = "/hdtest010%2C60020%2C1371000602151.1371058984668";
        Path fsPath = new Path(pathName);
        URL encodedPathUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CREATE, fsPath, new Param[0]);
        Assert.assertEquals((Object)("/webhdfs/v1" + pathName), (Object)encodedPathUrl.toURI().getPath());
    }

    @Test(timeout=60000L)
    public void testSimpleAuthParamsInUrl() throws IOException {
        Configuration conf = new Configuration();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/");
        URL fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new UserParam(ugi.getShortUserName()).toString()}, fileStatusUrl);
    }

    @Test(timeout=60000L)
    public void testSimpleProxyAuthParamsInUrl() throws IOException {
        Configuration conf = new Configuration();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        ugi = UserGroupInformation.createProxyUser((String)"test-proxy-user", (UserGroupInformation)ugi);
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/");
        URL fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new UserParam(ugi.getRealUser().getShortUserName()).toString(), new DoAsParam(ugi.getShortUserName()).toString()}, fileStatusUrl);
    }

    @Test(timeout=60000L)
    public void testSecureAuthParamsInUrl() throws IOException {
        Configuration conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/");
        String tokenString = webhdfs.getDelegationToken().encodeToUrlString();
        URL getTokenUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETDELEGATIONTOKEN, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETDELEGATIONTOKEN.toQueryString(), new UserParam(ugi.getShortUserName()).toString()}, getTokenUrl);
        URL renewTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        this.checkQueryParams(new String[]{PutOpParam.Op.RENEWDELEGATIONTOKEN.toQueryString(), new UserParam(ugi.getShortUserName()).toString(), new TokenArgumentParam(tokenString).toString()}, renewTokenUrl);
        URL cancelTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        this.checkQueryParams(new String[]{PutOpParam.Op.CANCELDELEGATIONTOKEN.toQueryString(), new UserParam(ugi.getShortUserName()).toString(), new TokenArgumentParam(tokenString).toString()}, cancelTokenUrl);
        URL fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new DelegationParam(tokenString).toString()}, fileStatusUrl);
        webhdfs.setDelegationToken(null);
        cancelTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        this.checkQueryParams(new String[]{PutOpParam.Op.CANCELDELEGATIONTOKEN.toQueryString(), new UserParam(ugi.getShortUserName()).toString(), new TokenArgumentParam(tokenString).toString()}, cancelTokenUrl);
        fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new DelegationParam(tokenString).toString()}, fileStatusUrl);
    }

    @Test(timeout=60000L)
    public void testSecureProxyAuthParamsInUrl() throws IOException {
        Configuration conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        ugi = UserGroupInformation.createProxyUser((String)"test-proxy-user", (UserGroupInformation)ugi);
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/");
        String tokenString = webhdfs.getDelegationToken().encodeToUrlString();
        URL getTokenUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETDELEGATIONTOKEN, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETDELEGATIONTOKEN.toQueryString(), new UserParam(ugi.getRealUser().getShortUserName()).toString(), new DoAsParam(ugi.getShortUserName()).toString()}, getTokenUrl);
        URL renewTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        this.checkQueryParams(new String[]{PutOpParam.Op.RENEWDELEGATIONTOKEN.toQueryString(), new UserParam(ugi.getRealUser().getShortUserName()).toString(), new DoAsParam(ugi.getShortUserName()).toString(), new TokenArgumentParam(tokenString).toString()}, renewTokenUrl);
        URL cancelTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        this.checkQueryParams(new String[]{PutOpParam.Op.CANCELDELEGATIONTOKEN.toQueryString(), new UserParam(ugi.getRealUser().getShortUserName()).toString(), new DoAsParam(ugi.getShortUserName()).toString(), new TokenArgumentParam(tokenString).toString()}, cancelTokenUrl);
        URL fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new DelegationParam(tokenString).toString()}, fileStatusUrl);
        webhdfs.setDelegationToken(null);
        cancelTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        this.checkQueryParams(new String[]{PutOpParam.Op.CANCELDELEGATIONTOKEN.toQueryString(), new UserParam(ugi.getRealUser().getShortUserName()).toString(), new DoAsParam(ugi.getShortUserName()).toString(), new TokenArgumentParam(tokenString).toString()}, cancelTokenUrl);
        fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new DelegationParam(tokenString).toString()}, fileStatusUrl);
    }

    @Test(timeout=60000L)
    public void testCheckAccessUrl() throws IOException {
        Configuration conf = new Configuration();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/p1");
        URL checkAccessUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.CHECKACCESS, fsPath, new Param[]{new FsActionParam(FsAction.READ_WRITE)});
        this.checkQueryParams(new String[]{GetOpParam.Op.CHECKACCESS.toQueryString(), new UserParam(ugi.getShortUserName()).toString(), "fsaction=" + FsAction.READ_WRITE.SYMBOL}, checkAccessUrl);
    }

    @Test(timeout=60000L)
    public void testBatchedListingUrl() throws Exception {
        Configuration conf = new Configuration();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/p1");
        StartAfterParam startAfter = new StartAfterParam("last");
        URL url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.LISTSTATUS_BATCH, fsPath, new Param[]{startAfter});
        this.checkQueryParams(new String[]{GetOpParam.Op.LISTSTATUS_BATCH.toQueryString(), new UserParam(ugi.getShortUserName()).toString(), "startafter=last"}, url);
    }

    private void checkQueryParams(String[] expected, URL url) {
        Arrays.sort(expected);
        Object[] query = url.getQuery().split("&");
        Arrays.sort(query);
        Assert.assertEquals((Object)Arrays.toString(expected), (Object)Arrays.toString(query));
    }

    private WebHdfsFileSystem getWebHdfsFileSystem(UserGroupInformation ugi, Configuration conf) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(new Text(ugi.getUserName()), null, null);
            FSNamesystem namesystem = (FSNamesystem)Mockito.mock(FSNamesystem.class);
            DelegationTokenSecretManager dtSecretManager = new DelegationTokenSecretManager(86400000L, 86400000L, 86400000L, 86400000L, namesystem);
            dtSecretManager.startThreads();
            Token token = new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)NetUtils.createSocketAddr((String)this.uri.getAuthority()));
            token.setKind(WebHdfsConstants.WEBHDFS_TOKEN_KIND);
            ugi.addToken(token);
        }
        return (WebHdfsFileSystem)FileSystem.get((URI)this.uri, (Configuration)conf);
    }
}

