/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=Parameterized.class)
public class TestFailureToReadEdits {
    private static final Log LOG = LogFactory.getLog(TestFailureToReadEdits.class);
    private static final String TEST_DIR1 = "/test1";
    private static final String TEST_DIR2 = "/test2";
    private static final String TEST_DIR3 = "/test3";
    private static final Random RANDOM = new Random();
    private final TestType clusterType;
    private final boolean useAsyncEditLogging;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private MiniQJMHACluster miniQjmHaCluster;
    private NameNode nn0;
    private NameNode nn1;
    private FileSystem fs;

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({TestType.SHARED_DIR_HA, Boolean.FALSE}, {TestType.QJM_HA, Boolean.FALSE});
    }

    public TestFailureToReadEdits(TestType clusterType, Boolean useAsyncEditLogging) {
        this.clusterType = clusterType;
        this.useAsyncEditLogging = useAsyncEditLogging;
    }

    @Before
    public void setUpCluster() throws Exception {
        block5: {
            this.conf = new Configuration();
            this.conf.setInt("dfs.namenode.checkpoint.check.period", 1);
            this.conf.setInt("dfs.namenode.checkpoint.txns", 1);
            this.conf.setInt("dfs.namenode.num.checkpoints.retained", 10);
            this.conf.setInt("dfs.ha.tail-edits.period", 1);
            this.conf.setBoolean("dfs.namenode.edits.asynclogging", this.useAsyncEditLogging);
            HAUtil.setAllowStandbyReads((Configuration)this.conf, (boolean)true);
            if (this.clusterType == TestType.SHARED_DIR_HA) {
                int basePort = 10000;
                int retryCount = 0;
                while (true) {
                    try {
                        basePort = 10000 + RANDOM.nextInt(1000) * 4;
                        LOG.info((Object)("Set SHARED_DIR_HA cluster's basePort to " + basePort));
                        MiniDFSNNTopology topology = MiniQJMHACluster.createDefaultTopology(basePort);
                        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(topology).numDataNodes(0).checkExitOnShutdown(false).build();
                        break block5;
                    }
                    catch (BindException e) {
                        if (this.cluster != null) {
                            this.cluster.shutdown(true);
                            this.cluster = null;
                        }
                        LOG.info((Object)("SHARED_DIR_HA: MiniQJMHACluster port conflicts, retried " + ++retryCount + " times " + e));
                        continue;
                    }
                    break;
                }
            }
            MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder(this.conf);
            builder.getDfsBuilder().numDataNodes(0).checkExitOnShutdown(false);
            this.miniQjmHaCluster = builder.build();
            this.cluster = this.miniQjmHaCluster.getDfsCluster();
        }
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
        this.cluster.transitionToActive(0);
        this.fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
    }

    @After
    public void tearDownCluster() throws Exception {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.clusterType == TestType.SHARED_DIR_HA) {
            if (this.cluster != null) {
                this.cluster.shutdown();
                this.cluster = null;
            }
        } else if (this.miniQjmHaCluster != null) {
            this.miniQjmHaCluster.shutdown();
            this.miniQjmHaCluster = null;
        }
    }

    @Test
    public void testFailuretoReadEdits() throws Exception {
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR1)));
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.fs.setOwner(new Path(TEST_DIR1), "foo", "bar");
        Assert.assertTrue((boolean)this.fs.delete(new Path(TEST_DIR1), true));
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR2)));
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR3)));
        LimitedEditLogAnswer answer = this.causeFailureOnEditLogRead();
        try {
            HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
            Assert.fail((String)"Standby fully caught up, but should not have been able to");
        }
        catch (HATestUtil.CouldNotCatchUpException couldNotCatchUpException) {
            // empty catch block
        }
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR1, false));
        Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR2, false).isDir());
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR3, false));
        answer.setThrowExceptionOnRead(false);
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR1, false));
        Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR2, false).isDir());
        Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR3, false).isDir());
    }

    @Test
    public void testCheckpointStartingMidEditsFile() throws Exception {
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR1)));
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        HATestUtil.waitForCheckpoint(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)0, (Object)3));
        HATestUtil.waitForCheckpoint(this.cluster, 0, (List<Integer>)ImmutableList.of((Object)0, (Object)3));
        this.causeFailureOnEditLogRead();
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR2)));
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR3)));
        try {
            HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
            Assert.fail((String)"Standby fully caught up, but should not have been able to");
        }
        catch (HATestUtil.CouldNotCatchUpException couldNotCatchUpException) {
            // empty catch block
        }
        HATestUtil.waitForCheckpoint(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)0, (Object)3, (Object)5));
        HATestUtil.waitForCheckpoint(this.cluster, 0, (List<Integer>)ImmutableList.of((Object)0, (Object)3, (Object)5));
        this.cluster.restartNameNode(0);
        HATestUtil.waitForCheckpoint(this.cluster, 0, (List<Integer>)ImmutableList.of((Object)0, (Object)3, (Object)5));
        try (FileSystem fs0 = null;){
            fs0 = FileSystem.get((URI)DFSUtilClient.getNNUri((InetSocketAddress)this.nn0.getNameNodeAddress()), (Configuration)this.conf);
            Assert.assertTrue((boolean)fs0.exists(new Path(TEST_DIR1)));
            Assert.assertTrue((boolean)fs0.exists(new Path(TEST_DIR2)));
            Assert.assertTrue((boolean)fs0.exists(new Path(TEST_DIR3)));
        }
    }

    @Test
    public void testFailureToReadEditsOnTransitionToActive() throws Exception {
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR1)));
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        HATestUtil.waitForCheckpoint(this.cluster, 0, (List<Integer>)ImmutableList.of((Object)0, (Object)3));
        this.causeFailureOnEditLogRead();
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR2)));
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR3)));
        try {
            HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
            Assert.fail((String)"Standby fully caught up, but should not have been able to");
        }
        catch (HATestUtil.CouldNotCatchUpException couldNotCatchUpException) {
            // empty catch block
        }
        this.cluster.shutdownNameNode(0);
        try {
            this.cluster.transitionToActive(1);
            Assert.fail((String)"Standby transitioned to active, but should not have been able to");
        }
        catch (ExitUtil.ExitException ee) {
            GenericTestUtils.assertExceptionContains((String)"Error replaying edit log", (Throwable)ee);
        }
    }

    private LimitedEditLogAnswer causeFailureOnEditLogRead() throws IOException {
        FSEditLog spyEditLog = NameNodeAdapter.spyOnEditLog(this.nn1);
        LimitedEditLogAnswer answer = new LimitedEditLogAnswer();
        ((FSEditLog)Mockito.doAnswer((Answer)answer).when((Object)spyEditLog)).selectInputStreams(Matchers.anyLong(), Matchers.anyLong(), (MetaRecoveryContext)Matchers.anyObject(), Matchers.anyBoolean());
        return answer;
    }

    private static class LimitedEditLogAnswer
    implements Answer<Collection<EditLogInputStream>> {
        private boolean throwExceptionOnRead = true;

        private LimitedEditLogAnswer() {
        }

        public Collection<EditLogInputStream> answer(InvocationOnMock invocation) throws Throwable {
            Collection streams = (Collection)invocation.callRealMethod();
            if (!this.throwExceptionOnRead) {
                return streams;
            }
            LinkedList<EditLogInputStream> ret = new LinkedList<EditLogInputStream>();
            for (EditLogInputStream stream : streams) {
                EditLogInputStream spyStream = (EditLogInputStream)Mockito.spy((Object)stream);
                ((EditLogInputStream)Mockito.doAnswer((Answer)new Answer<FSEditLogOp>(){

                    public FSEditLogOp answer(InvocationOnMock invocation) throws Throwable {
                        FSEditLogOp op = (FSEditLogOp)invocation.callRealMethod();
                        if (LimitedEditLogAnswer.this.throwExceptionOnRead && TestFailureToReadEdits.TEST_DIR3.equals(NameNodeAdapter.getMkdirOpPath(op))) {
                            throw new IOException("failed to read op creating /test3");
                        }
                        return op;
                    }
                }).when((Object)spyStream)).readOp();
                ret.add(spyStream);
            }
            return ret;
        }

        public void setThrowExceptionOnRead(boolean throwExceptionOnRead) {
            this.throwExceptionOnRead = throwExceptionOnRead;
        }
    }

    private static enum TestType {
        SHARED_DIR_HA,
        QJM_HA;

    }
}

