/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceContext;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestSaveNamespace {
    private static final Log LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNamespaceWithInjectedFault(Fault fault) throws Exception {
        NNStorage spyStorage;
        Configuration conf = this.getConf();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf);
        FSImage originalImage = fsn.getFSImage();
        NNStorage storage = originalImage.getStorage();
        originalImage.storage = spyStorage = (NNStorage)Mockito.spy((Object)storage);
        FSImage spyImage = (FSImage)Mockito.spy((Object)originalImage);
        Whitebox.setInternalState((Object)fsn, (String)"fsImage", (Object)spyImage);
        boolean shouldFail = false;
        switch (fault) {
            case SAVE_SECOND_FSIMAGE_RTE: {
                ((FSImage)Mockito.doAnswer((Answer)new FaultySaveImage(true)).when((Object)spyImage)).saveFSImage((SaveNamespaceContext)Matchers.anyObject(), (Storage.StorageDirectory)Matchers.anyObject(), (NNStorage.NameNodeFile)Matchers.anyObject());
                shouldFail = false;
                break;
            }
            case SAVE_SECOND_FSIMAGE_IOE: {
                ((FSImage)Mockito.doAnswer((Answer)new FaultySaveImage(false)).when((Object)spyImage)).saveFSImage((SaveNamespaceContext)Matchers.anyObject(), (Storage.StorageDirectory)Matchers.anyObject(), (NNStorage.NameNodeFile)Matchers.anyObject());
                shouldFail = false;
                break;
            }
            case SAVE_ALL_FSIMAGES: {
                ((FSImage)Mockito.doThrow((Throwable)new RuntimeException("Injected")).when((Object)spyImage)).saveFSImage((SaveNamespaceContext)Matchers.anyObject(), (Storage.StorageDirectory)Matchers.anyObject(), (NNStorage.NameNodeFile)Matchers.anyObject());
                shouldFail = true;
                break;
            }
            case WRITE_STORAGE_ALL: {
                ((NNStorage)Mockito.doAnswer((Answer)new FaultyWriteProperties(Fault.WRITE_STORAGE_ALL)).when((Object)spyStorage)).writeProperties((Storage.StorageDirectory)Matchers.anyObject());
                shouldFail = true;
                break;
            }
            case WRITE_STORAGE_ONE: {
                ((NNStorage)Mockito.doAnswer((Answer)new FaultyWriteProperties(Fault.WRITE_STORAGE_ONE)).when((Object)spyStorage)).writeProperties((Storage.StorageDirectory)Matchers.anyObject());
                shouldFail = false;
            }
        }
        try {
            this.doAnEdit(fsn, 1);
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            try {
                fsn.saveNamespace();
                if (shouldFail) {
                    Assert.fail((String)"Did not fail!");
                }
            }
            catch (Exception e) {
                if (!shouldFail) {
                    throw e;
                }
                LOG.info((Object)"Test caught expected exception", (Throwable)e);
            }
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            this.doAnEdit(fsn, 2);
            originalImage.close();
            fsn.close();
            fsn = null;
            fsn = FSNamesystem.loadFromDisk((Configuration)conf);
            this.checkEditExists(fsn, 1);
            this.checkEditExists(fsn, 2);
        }
        finally {
            if (fsn != null) {
                fsn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReinsertnamedirsInSavenamespace() throws Exception {
        Configuration conf = this.getConf();
        conf.setBoolean("dfs.namenode.name.dir.restore", true);
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf);
        FSImage originalImage = fsn.getFSImage();
        NNStorage storage = originalImage.getStorage();
        FSImage spyImage = (FSImage)Mockito.spy((Object)originalImage);
        Whitebox.setInternalState((Object)fsn, (String)"fsImage", (Object)spyImage);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        File rootDir = storage.getStorageDir(0).getRoot();
        Path rootPath = new Path(rootDir.getPath(), "current");
        FsPermission permissionNone = new FsPermission(0);
        FsPermission permissionAll = new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.READ_EXECUTE);
        fs.setPermission(rootPath, permissionNone);
        try {
            this.doAnEdit(fsn, 1);
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            LOG.info((Object)"Doing the first savenamespace.");
            fsn.saveNamespace();
            LOG.info((Object)"First savenamespace sucessful.");
            Assert.assertTrue((String)("Savenamespace should have marked one directory as bad. But found " + storage.getRemovedStorageDirs().size() + " bad directories."), (storage.getRemovedStorageDirs().size() == 1 ? 1 : 0) != 0);
            fs.setPermission(rootPath, permissionAll);
            LOG.info((Object)"Doing the second savenamespace.");
            fsn.saveNamespace();
            LOG.warn((Object)"Second savenamespace sucessful.");
            Assert.assertTrue((String)("Savenamespace should have been successful in removing  bad directories from Image. But found " + storage.getRemovedStorageDirs().size() + " bad directories."), (storage.getRemovedStorageDirs().size() == 0 ? 1 : 0) != 0);
            LOG.info((Object)"Shutting down fsimage.");
            originalImage.close();
            fsn.close();
            fsn = null;
            LOG.info((Object)"Loading new FSmage from disk.");
            fsn = FSNamesystem.loadFromDisk((Configuration)conf);
            LOG.info((Object)"Checking reloaded image.");
            this.checkEditExists(fsn, 1);
            LOG.info((Object)"Reloaded image is good.");
        }
        finally {
            if (rootDir.exists()) {
                fs.setPermission(rootPath, permissionAll);
            }
            if (fsn != null) {
                try {
                    fsn.close();
                }
                catch (Throwable t) {
                    LOG.fatal((Object)"Failed to shut down", t);
                }
            }
        }
    }

    @Test(timeout=30000L)
    public void testRTEWhileSavingSecondImage() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.SAVE_SECOND_FSIMAGE_RTE);
    }

    @Test(timeout=30000L)
    public void testIOEWhileSavingSecondImage() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.SAVE_SECOND_FSIMAGE_IOE);
    }

    @Test(timeout=30000L)
    public void testCrashInAllImageDirs() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.SAVE_ALL_FSIMAGES);
    }

    @Test(timeout=30000L)
    public void testCrashWhenWritingVersionFiles() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.WRITE_STORAGE_ALL);
    }

    @Test(timeout=30000L)
    public void testCrashWhenWritingVersionFileInOneDir() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.WRITE_STORAGE_ONE);
    }

    @Test(timeout=30000L)
    public void testFailedSaveNamespace() throws Exception {
        this.doTestFailedSaveNamespace(false);
    }

    @Test(timeout=30000L)
    public void testFailedSaveNamespaceWithRecovery() throws Exception {
        this.doTestFailedSaveNamespace(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestFailedSaveNamespace(boolean restoreStorageAfterFailure) throws Exception {
        NNStorage spyStorage;
        Configuration conf = this.getConf();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf);
        FSImage originalImage = fsn.getFSImage();
        NNStorage storage = originalImage.getStorage();
        storage.close();
        originalImage.storage = spyStorage = (NNStorage)Mockito.spy((Object)storage);
        FSImage spyImage = (FSImage)Mockito.spy((Object)originalImage);
        Whitebox.setInternalState((Object)fsn, (String)"fsImage", (Object)spyImage);
        spyImage.storage.setStorageDirectories(FSNamesystem.getNamespaceDirs((Configuration)conf), (Collection)FSNamesystem.getNamespaceEditsDirs((Configuration)conf));
        ((FSImage)Mockito.doThrow((Throwable)new IOException("Injected fault: saveFSImage")).when((Object)spyImage)).saveFSImage((SaveNamespaceContext)Matchers.anyObject(), (Storage.StorageDirectory)Matchers.anyObject(), (NNStorage.NameNodeFile)Matchers.anyObject());
        try {
            this.doAnEdit(fsn, 1);
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            try {
                fsn.saveNamespace();
                Assert.fail((String)"saveNamespace did not fail even when all directories failed!");
            }
            catch (IOException ioe) {
                LOG.info((Object)"Got expected exception", (Throwable)ioe);
            }
            if (restoreStorageAfterFailure) {
                Mockito.reset((Object[])new FSImage[]{spyImage});
                spyStorage.setRestoreFailedStorage(true);
                fsn.saveNamespace();
                this.checkEditExists(fsn, 1);
            }
            originalImage.close();
            fsn.close();
            fsn = null;
            fsn = FSNamesystem.loadFromDisk((Configuration)conf);
            this.checkEditExists(fsn, 1);
        }
        finally {
            if (fsn != null) {
                fsn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSaveWhileEditsRolled() throws Exception {
        Configuration conf = this.getConf();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        try (FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf);){
            this.doAnEdit(fsn, 1);
            CheckpointSignature sig = fsn.rollEditLog();
            LOG.warn((Object)("Checkpoint signature: " + sig));
            this.doAnEdit(fsn, 2);
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fsn.saveNamespace();
            fsn.close();
            fsn = null;
            fsn = FSNamesystem.loadFromDisk((Configuration)conf);
            this.checkEditExists(fsn, 1);
            this.checkEditExists(fsn, 2);
        }
    }

    @Test(timeout=30000L)
    public void testTxIdPersistence() throws Exception {
        Configuration conf = this.getConf();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        try (FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf);){
            Assert.assertEquals((long)1L, (long)fsn.getEditLog().getLastWrittenTxId());
            this.doAnEdit(fsn, 1);
            Assert.assertEquals((long)2L, (long)fsn.getEditLog().getLastWrittenTxId());
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fsn.saveNamespace();
            Assert.assertEquals((long)4L, (long)fsn.getEditLog().getLastWrittenTxId());
            fsn.getFSImage().close();
            fsn.close();
            Assert.assertEquals((long)5L, (long)fsn.getEditLog().getLastWrittenTxId());
            fsn = null;
            fsn = FSNamesystem.loadFromDisk((Configuration)conf);
            Assert.assertEquals((long)6L, (long)fsn.getEditLog().getLastWrittenTxId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveNamespaceWithRenamedLease() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(new Configuration()).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream out = null;
        try {
            fs.mkdirs(new Path("/test-target"));
            out = fs.create(new Path("/test-source/foo"));
            fs.rename(new Path("/test-source/"), new Path("/test-target/"));
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNodeRpc().saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out, fs});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out, fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testCancelSaveNamespace() throws Exception {
        FSNamesystem spyFsn;
        Configuration conf = this.getConf();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf);
        final FSImage image = fsn.getFSImage();
        NNStorage storage = image.getStorage();
        storage.close();
        storage.setStorageDirectories(FSNamesystem.getNamespaceDirs((Configuration)conf), (Collection)FSNamesystem.getNamespaceEditsDirs((Configuration)conf));
        final FSNamesystem finalFsn = spyFsn = (FSNamesystem)Mockito.spy((Object)fsn);
        GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG);
        BlockIdManager bid = (BlockIdManager)Mockito.spy((Object)spyFsn.getBlockManager().getBlockIdManager());
        Whitebox.setInternalState((Object)finalFsn.getBlockManager(), (String)"blockIdManager", (Object)bid);
        ((BlockIdManager)Mockito.doAnswer((Answer)delayer).when((Object)bid)).getGenerationStamp();
        ExecutorService pool = Executors.newFixedThreadPool(2);
        try {
            this.doAnEdit(fsn, 1);
            final Canceler canceler = new Canceler();
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            try {
                Future<Void> saverFuture = pool.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        image.saveNamespace(finalFsn, NNStorage.NameNodeFile.IMAGE, canceler);
                        return null;
                    }
                });
                delayer.waitForCall();
                Future<Void> cancelFuture = pool.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        canceler.cancel("cancelled");
                        return null;
                    }
                });
                Thread.sleep(500L);
                delayer.proceed();
                cancelFuture.get();
                saverFuture.get();
                Assert.fail((String)"saveNamespace did not fail even though cancelled!");
            }
            catch (Throwable t) {
                GenericTestUtils.assertExceptionContains((String)"SaveNamespaceCancelledException", (Throwable)t);
            }
            LOG.info((Object)"Successfully cancelled a saveNamespace");
            FSImageTestUtil.logStorageContents(LOG, storage);
            for (Storage.StorageDirectory sd : storage.dirIterable(null)) {
                File curDir = sd.getCurrentDir();
                GenericTestUtils.assertGlobEquals((File)curDir, (String)"fsimage_.*", (String[])new String[]{NNStorage.getImageFileName((long)0L), NNStorage.getImageFileName((long)0L) + ".md5"});
            }
        }
        finally {
            fsn.close();
        }
    }

    @Test(timeout=30000L)
    public void testSaveNamespaceWithDanglingLease() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(new Configuration()).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            cluster.getNamesystem().leaseManager.addLease("me", 16386L);
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNodeRpc().saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipSnapshotSection() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(new Configuration()).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream out = null;
        try {
            String path = "/skipSnapshot";
            out = fs.create(new Path(path));
            out.close();
            FSDirectory dir = cluster.getNamesystem().getFSDirectory();
            INodeFile file = dir.getINode(path).asFile();
            file.addSnapshotFeature(null).getDiffs().saveSelf2Snapshot(-1, file, null, false);
            Assert.assertTrue((String)"Snapshot fileDiff is missing.", (file.getFileWithSnapshotFeature().getDiffs() != null ? 1 : 0) != 0);
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNodeRpc().saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            cluster.restartNameNode(true);
            dir = cluster.getNamesystem().getFSDirectory();
            file = dir.getINode(path).asFile();
            Assert.assertTrue((String)"There should be no snapshot feature for this INode.", (file.getFileWithSnapshotFeature() == null ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    private void doAnEdit(FSNamesystem fsn, int id) throws IOException {
        fsn.mkdirs("/test" + id, new PermissionStatus("test", "Test", new FsPermission(511)), true);
    }

    private void checkEditExists(FSNamesystem fsn, int id) throws IOException {
        Assert.assertNotNull((Object)fsn.getFileInfo("/test" + id, false));
    }

    private Configuration getConf() throws IOException {
        String baseDir = MiniDFSCluster.getBaseDirectory();
        String nameDirs = Util.fileAsURI((File)new File(baseDir, "name1")) + "," + Util.fileAsURI((File)new File(baseDir, "name2"));
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        conf.set("dfs.namenode.name.dir", nameDirs);
        conf.set("dfs.namenode.edits.dir", nameDirs);
        conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        conf.setBoolean("dfs.permissions.enabled", false);
        return conf;
    }

    static {
        GenericTestUtils.setLogLevel((Log)FSImage.LOG, (Level)Level.ALL);
        LOG = LogFactory.getLog(TestSaveNamespace.class);
    }

    private static enum Fault {
        SAVE_SECOND_FSIMAGE_RTE,
        SAVE_SECOND_FSIMAGE_IOE,
        SAVE_ALL_FSIMAGES,
        WRITE_STORAGE_ALL,
        WRITE_STORAGE_ONE;

    }

    private static class FaultyWriteProperties
    implements Answer<Void> {
        private int count = 0;
        private Fault faultType;

        FaultyWriteProperties(Fault faultType) {
            this.faultType = faultType;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            Object[] args = invocation.getArguments();
            Storage.StorageDirectory sd = (Storage.StorageDirectory)args[0];
            if (this.faultType == Fault.WRITE_STORAGE_ALL || this.faultType == Fault.WRITE_STORAGE_ONE && this.count++ == 1) {
                LOG.info((Object)("Injecting fault for sd: " + sd));
                throw new IOException("Injected fault: writeProperties second time");
            }
            LOG.info((Object)("Not injecting fault for sd: " + sd));
            return (Void)invocation.callRealMethod();
        }
    }

    private static class FaultySaveImage
    implements Answer<Void> {
        int count = 0;
        boolean throwRTE = true;

        public FaultySaveImage(boolean throwRTE) {
            this.throwRTE = throwRTE;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            Object[] args = invocation.getArguments();
            Storage.StorageDirectory sd = (Storage.StorageDirectory)args[1];
            if (this.count++ == 1) {
                LOG.info((Object)("Injecting fault for sd: " + sd));
                if (this.throwRTE) {
                    throw new RuntimeException("Injected fault: saveFSImage second time");
                }
                throw new IOException("Injected fault: saveFSImage second time");
            }
            LOG.info((Object)("Not injecting fault for sd: " + sd));
            return (Void)invocation.callRealMethod();
        }
    }
}

