/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestLeaseManager {
    @Rule
    public Timeout timeout = new Timeout(300000);
    public static long maxLockHoldToReleaseLeaseMs = 100L;

    @Test
    public void testRemoveLeases() throws Exception {
        long id;
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        LeaseManager lm = new LeaseManager(fsn);
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{16386L, 16387L, 16388L, 16389L});
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            lm.addLease("foo", id);
        }
        Assert.assertEquals((long)4L, (long)lm.getINodeIdWithLeases().size());
        iterator = ids.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            lm.removeLease(id);
        }
        Assert.assertEquals((long)0L, (long)lm.getINodeIdWithLeases().size());
    }

    @Test
    public void testCheckLease() throws InterruptedException {
        LeaseManager lm = new LeaseManager(TestLeaseManager.makeMockFsNameSystem());
        long numLease = 100L;
        long expiryTime = 0L;
        long waitTime = 1L;
        lm.setLeasePeriod(0L, 0L);
        for (long i = 0L; i <= 99L; ++i) {
            lm.addLease("holder" + i, 16385L + i);
        }
        Assert.assertEquals((long)100L, (long)lm.countLease());
        Thread.sleep(1L);
        lm.checkLeases();
        Assert.assertTrue(((long)lm.countLease() < 100L ? 1 : 0) != 0);
    }

    @Test
    public void testInternalLeaseHolder() throws Exception {
        LeaseManager lm = new LeaseManager(TestLeaseManager.makeMockFsNameSystem());
        lm.setLeasePeriod(100L, 500L);
        String holder = lm.getInternalLeaseHolder();
        Thread.sleep(1000L);
        Assert.assertNotEquals((Object)holder, (Object)lm.getInternalLeaseHolder());
    }

    @Test
    public void testCountPath() {
        LeaseManager lm = new LeaseManager(TestLeaseManager.makeMockFsNameSystem());
        lm.addLease("holder1", 1L);
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)1L));
        lm.addLease("holder2", 2L);
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)2L));
        lm.addLease("holder2", 2L);
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)2L));
        lm.removeLease("holder2", TestLeaseManager.stubInodeFile(3L));
        lm.removeLease("InvalidLeaseHolder", TestLeaseManager.stubInodeFile(1L));
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)2L));
        INodeFile file = TestLeaseManager.stubInodeFile(1L);
        lm.reassignLease(lm.getLease(file), file, "holder2");
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)2L));
        lm.removeLease("holder2", TestLeaseManager.stubInodeFile(2L));
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseRestorationOnRestart() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).numDataNodes(1).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String path = "/testLeaseRestorationOnRestart";
            FSDataOutputStream out = dfs.create(new Path(path));
            FSDirectory dir = cluster.getNamesystem().getFSDirectory();
            INodeFile file = dir.getINode(path).asFile();
            cluster.getNamesystem().leaseManager.removeLease(file.getFileUnderConstructionFeature().getClientName(), file);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNodeRpc().saveNamespace();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            cluster.restartNameNode(true);
            dir = cluster.getNamesystem().getFSDirectory();
            file = dir.getINode(path).asFile();
            Assert.assertTrue((String)"Lease should exist.", (cluster.getNamesystem().leaseManager.getLease(file) != null ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=60000L)
    public void testInodeWithLeases() throws Exception {
        FSNamesystem fsNamesystem = TestLeaseManager.makeMockFsNameSystem();
        FSDirectory fsDirectory = fsNamesystem.getFSDirectory();
        LeaseManager lm = new LeaseManager(fsNamesystem);
        HashSet<Long> iNodeIds = new HashSet<Long>(Arrays.asList(16386L, 16387L, 16388L, 16389L));
        PermissionStatus perm = PermissionStatus.createImmutable((String)"user", (String)"group", (FsPermission)FsPermission.createImmutable((short)493));
        INodeDirectory rootInodeDirectory = new INodeDirectory(0L, DFSUtil.string2Bytes((String)""), perm, 0L);
        Mockito.when((Object)fsDirectory.getRoot()).thenReturn((Object)rootInodeDirectory);
        this.verifyINodeLeaseCounts(lm, rootInodeDirectory, 0, 0, 0);
        for (Long iNodeId : iNodeIds) {
            INodeFile iNodeFile = TestLeaseManager.stubInodeFile(iNodeId);
            iNodeFile.setParent(rootInodeDirectory);
            Mockito.when((Object)fsDirectory.getInode(iNodeId.longValue())).thenReturn((Object)iNodeFile);
            lm.addLease("holder_" + iNodeId, iNodeId.longValue());
        }
        this.verifyINodeLeaseCounts(lm, rootInodeDirectory, iNodeIds.size(), iNodeIds.size(), iNodeIds.size());
        for (Long iNodeId : iNodeIds) {
            lm.removeLease(iNodeId.longValue());
        }
        this.verifyINodeLeaseCounts(lm, rootInodeDirectory, 0, 0, 0);
    }

    @Test(timeout=240000L)
    public void testInodeWithLeasesAtScale() throws Exception {
        FSNamesystem fsNamesystem = TestLeaseManager.makeMockFsNameSystem();
        FSDirectory fsDirectory = fsNamesystem.getFSDirectory();
        LeaseManager lm = new LeaseManager(fsNamesystem);
        PermissionStatus perm = PermissionStatus.createImmutable((String)"user", (String)"group", (FsPermission)FsPermission.createImmutable((short)493));
        INodeDirectory rootInodeDirectory = new INodeDirectory(0L, DFSUtil.string2Bytes((String)""), perm, 0L);
        Mockito.when((Object)fsDirectory.getRoot()).thenReturn((Object)rootInodeDirectory);
        int scale = 0;
        this.testInodeWithLeasesAtScaleImpl(lm, fsDirectory, rootInodeDirectory, scale);
        for (int workerCount = 1; workerCount <= 2; ++workerCount) {
            scale = workerCount * 512 / 2;
            this.testInodeWithLeasesAtScaleImpl(lm, fsDirectory, rootInodeDirectory, scale);
            scale = workerCount * 512 - 1;
            this.testInodeWithLeasesAtScaleImpl(lm, fsDirectory, rootInodeDirectory, scale);
            scale = workerCount * 512;
            this.testInodeWithLeasesAtScaleImpl(lm, fsDirectory, rootInodeDirectory, scale);
            scale = workerCount * 512 + 1;
            this.testInodeWithLeasesAtScaleImpl(lm, fsDirectory, rootInodeDirectory, scale);
        }
        scale = 1279;
        this.testInodeWithLeasesAtScaleImpl(lm, fsDirectory, rootInodeDirectory, scale);
    }

    private void testInodeWithLeasesAtScaleImpl(LeaseManager leaseManager, FSDirectory fsDirectory, INodeDirectory ancestorDirectory, int scale) throws IOException {
        this.verifyINodeLeaseCounts(leaseManager, ancestorDirectory, 0, 0, 0);
        HashSet<Long> iNodeIds = new HashSet<Long>();
        for (int i = 0; i < scale; ++i) {
            iNodeIds.add(16385L + (long)i);
        }
        for (Long iNodeId : iNodeIds) {
            INodeFile iNodeFile = TestLeaseManager.stubInodeFile(iNodeId);
            iNodeFile.setParent(ancestorDirectory);
            Mockito.when((Object)fsDirectory.getInode(iNodeId.longValue())).thenReturn((Object)iNodeFile);
            leaseManager.addLease("holder_" + iNodeId, iNodeId.longValue());
        }
        this.verifyINodeLeaseCounts(leaseManager, ancestorDirectory, iNodeIds.size(), iNodeIds.size(), iNodeIds.size());
        leaseManager.removeAllLeases();
        this.verifyINodeLeaseCounts(leaseManager, ancestorDirectory, 0, 0, 0);
    }

    @Test(timeout=60000L)
    public void testInodeWithLeasesForAncestorDir() throws Exception {
        FSNamesystem fsNamesystem = TestLeaseManager.makeMockFsNameSystem();
        FSDirectory fsDirectory = fsNamesystem.getFSDirectory();
        LeaseManager lm = new LeaseManager(fsNamesystem);
        PermissionStatus perm = PermissionStatus.createImmutable((String)"user", (String)"group", (FsPermission)FsPermission.createImmutable((short)493));
        INodeDirectory rootInodeDirectory = new INodeDirectory(0L, DFSUtil.string2Bytes((String)""), perm, 0L);
        Mockito.when((Object)fsDirectory.getRoot()).thenReturn((Object)rootInodeDirectory);
        AtomicInteger inodeIds = new AtomicInteger(1234);
        String[] pathTree = new String[]{"/root.log", "/ENG/a/a1.log", "/ENG/a/b/b1.log", "/ENG/a/b/c/c1.log", "/ENG/a/b/c/c2.log", "/OPS/m/m1.log", "/OPS/m/n/n1.log", "/OPS/m/n/n2.log"};
        Map<String, INode> pathINodeMap = this.createINodeTree(rootInodeDirectory, pathTree, inodeIds);
        Assert.assertEquals((long)0L, (long)lm.getINodeIdWithLeases().size());
        for (Map.Entry<String, INode> entry : pathINodeMap.entrySet()) {
            long iNodeId = entry.getValue().getId();
            Mockito.when((Object)fsDirectory.getInode(iNodeId)).thenReturn((Object)entry.getValue());
            if (!entry.getKey().contains("log")) continue;
            lm.addLease("holder_" + iNodeId, iNodeId);
        }
        Assert.assertEquals((long)pathTree.length, (long)lm.getINodeIdWithLeases().size());
        Assert.assertEquals((long)pathTree.length, (long)lm.getINodeWithLeases().size());
        Assert.assertEquals((long)pathTree.length, (long)lm.getINodeWithLeases(rootInodeDirectory).size());
        lm.removeAllLeases();
        HashSet<String> filesLeased = new HashSet<String>(Arrays.asList("root.log", "a1.log", "c1.log", "n2.log"));
        for (String fileName : filesLeased) {
            lm.addLease("holder", pathINodeMap.get(fileName).getId());
        }
        Assert.assertEquals((long)filesLeased.size(), (long)lm.getINodeIdWithLeases().size());
        Assert.assertEquals((long)filesLeased.size(), (long)lm.getINodeWithLeases().size());
        Set set = lm.getINodeWithLeases();
        for (INodesInPath iNodesInPath : set) {
            String leasedFileName = DFSUtil.bytes2String((byte[])iNodesInPath.getLastLocalName());
            Assert.assertTrue((boolean)filesLeased.contains(leasedFileName));
        }
        Assert.assertEquals((long)filesLeased.size(), (long)lm.getINodeWithLeases(rootInodeDirectory).size());
        Assert.assertEquals((long)(filesLeased.size() - 2), (long)lm.getINodeWithLeases(pathINodeMap.get("ENG").asDirectory()).size());
        Assert.assertEquals((long)(filesLeased.size() - 2), (long)lm.getINodeWithLeases(pathINodeMap.get("a").asDirectory()).size());
        Assert.assertEquals((long)(filesLeased.size() - 3), (long)lm.getINodeWithLeases(pathINodeMap.get("c").asDirectory()).size());
        Assert.assertEquals((long)(filesLeased.size() - 3), (long)lm.getINodeWithLeases(pathINodeMap.get("OPS").asDirectory()).size());
        Assert.assertEquals((long)(filesLeased.size() - 3), (long)lm.getINodeWithLeases(pathINodeMap.get("n").asDirectory()).size());
        lm.removeLease(pathINodeMap.get("n2.log").getId());
        Assert.assertEquals((long)(filesLeased.size() - 1), (long)lm.getINodeWithLeases(rootInodeDirectory).size());
        Assert.assertEquals((long)(filesLeased.size() - 4), (long)lm.getINodeWithLeases(pathINodeMap.get("n").asDirectory()).size());
        lm.removeAllLeases();
        filesLeased.clear();
        Assert.assertEquals((long)filesLeased.size(), (long)lm.getINodeWithLeases(rootInodeDirectory).size());
    }

    private void verifyINodeLeaseCounts(LeaseManager leaseManager, INodeDirectory ancestorDirectory, int iNodeIdWithLeaseCount, int iNodeWithLeaseCount, int iNodeUnderAncestorLeaseCount) throws IOException {
        Assert.assertEquals((long)iNodeIdWithLeaseCount, (long)leaseManager.getINodeIdWithLeases().size());
        Assert.assertEquals((long)iNodeWithLeaseCount, (long)leaseManager.getINodeWithLeases().size());
        Assert.assertEquals((long)iNodeUnderAncestorLeaseCount, (long)leaseManager.getINodeWithLeases(ancestorDirectory).size());
    }

    private Map<String, INode> createINodeTree(INodeDirectory parentDir, String[] pathTree, AtomicInteger inodeId) throws QuotaExceededException {
        HashMap<String, INode> pathINodeMap = new HashMap<String, INode>();
        for (String path : pathTree) {
            byte[][] components = INode.getPathComponents((String)path);
            FsPermission perm = FsPermission.createImmutable((short)493);
            PermissionStatus permStatus = PermissionStatus.createImmutable((String)"", (String)"", (FsPermission)perm);
            INodeDirectory prev = parentDir;
            INodeDirectory dir = null;
            for (int i = 0; i < components.length - 1; ++i) {
                byte[] component = components[i];
                if (component.length == 0) continue;
                INode existingChild = prev.getChild(component, 0x7FFFFFFE);
                if (existingChild == null) {
                    String dirName = DFSUtil.bytes2String((byte[])component);
                    dir = new INodeDirectory((long)inodeId.incrementAndGet(), component, permStatus, 0L);
                    prev.addChild((INode)dir, false, 0x7FFFFFFE);
                    pathINodeMap.put(dirName, (INode)dir);
                    prev = dir;
                    continue;
                }
                Assert.assertTrue((boolean)existingChild.isDirectory());
                prev = existingChild.asDirectory();
            }
            PermissionStatus p = new PermissionStatus("user", "group", new FsPermission(511));
            byte[] fileNameBytes = components[components.length - 1];
            String fileName = DFSUtil.bytes2String((byte[])fileNameBytes);
            INodeFile iNodeFile = new INodeFile((long)inodeId.incrementAndGet(), fileNameBytes, p, 0L, 0L, BlockInfo.EMPTY_ARRAY, 1, 1L);
            iNodeFile.setParent(prev);
            pathINodeMap.put(fileName, (INode)iNodeFile);
        }
        return pathINodeMap;
    }

    private static FSNamesystem makeMockFsNameSystem() {
        FSDirectory dir = (FSDirectory)Mockito.mock(FSDirectory.class);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.isRunning()).thenReturn((Object)true);
        Mockito.when((Object)fsn.hasReadLock()).thenReturn((Object)true);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        Mockito.when((Object)fsn.getFSDirectory()).thenReturn((Object)dir);
        Mockito.when((Object)fsn.getMaxLockHoldToReleaseLeaseMs()).thenReturn((Object)maxLockHoldToReleaseLeaseMs);
        return fsn;
    }

    private static INodeFile stubInodeFile(long inodeId) {
        PermissionStatus p = new PermissionStatus("dummy", "dummy", new FsPermission(511));
        return new INodeFile(inodeId, new String("foo-" + inodeId).getBytes(), p, 0L, 0L, BlockInfo.EMPTY_ARRAY, 1, 1L);
    }
}

