/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestFSEditLogLoader {
    private static boolean useAsyncEditLog;
    private static final File TEST_DIR;
    private static final int NUM_DATA_NODES = 0;
    private static final Map<Byte, FSEditLogOpCodes> byteToEnum;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{Boolean.FALSE});
        params.add(new Object[]{Boolean.TRUE});
        return params;
    }

    public TestFSEditLogLoader(Boolean async) {
        useAsyncEditLog = async;
    }

    private static Configuration getConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.edits.asynclogging", useAsyncEditLog);
        return conf;
    }

    @Test
    public void testDisplayRecentEditLogOpCodes() throws IOException {
        Configuration conf = TestFSEditLogLoader.getConf();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).enableManagedDfsDirsRedundancy(false).build();
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        FSImage fsimage = namesystem.getFSImage();
        for (int i = 0; i < 20; ++i) {
            fileSys.mkdirs(new Path("/tmp/tmp" + i));
        }
        Storage.StorageDirectory sd = (Storage.StorageDirectory)fsimage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        cluster.shutdown();
        File editFile = FSImageTestUtil.findLatestEditsLog(sd).getFile();
        Assert.assertTrue((String)("Should exist: " + editFile), (boolean)editFile.exists());
        long fileLen = editFile.length();
        RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
        rwf.seek(fileLen - 40L);
        for (int i = 0; i < 20; ++i) {
            rwf.write(FSEditLogOpCodes.OP_DELETE.getOpCode());
        }
        rwf.close();
        StringBuilder bld = new StringBuilder();
        bld.append("^Error replaying edit log at offset \\d+.  ");
        bld.append("Expected transaction ID was \\d+\n");
        bld.append("Recent opcode offsets: (\\d+\\s*){4}$");
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).enableManagedDfsDirsRedundancy(false).format(false).build();
            Assert.fail((String)"should not be able to start");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"error message contains opcodes message", (boolean)e.getMessage().matches(bld.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicationAdjusted() throws Exception {
        Configuration conf = TestFSEditLogLoader.getConf();
        conf.setInt("dfs.namenode.replication.interval", 1);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path p = new Path("/testfile");
            DFSTestUtil.createFile((FileSystem)fs, p, 10L, (short)1, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, p, (short)1);
            cluster.shutdown();
            cluster = null;
            conf.setInt("dfs.namenode.replication.min", 2);
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.waitReplication((FileSystem)fs, p, (short)2);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void corruptByteInFile(File file, long offset) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            raf.seek(offset);
            int origByte = raf.read();
            raf.seek(offset);
            raf.writeByte(origByte - 1);
        }
        finally {
            IOUtils.closeStream((Closeable)raf);
        }
    }

    private void truncateFile(File logFile, long newLength) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(logFile, "rw");
        raf.setLength(newLength);
        raf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNonTrailerLength(File f) throws IOException {
        int chunkSizeToRead = 262144;
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] buf = new byte[262144];
            FileChannel fc = fis.getChannel();
            long size = fc.size();
            for (long pos = size - size % 262144L; pos >= 0L; pos -= 262144L) {
                fc.position(pos);
                int readLen = (int)Math.min(size - pos, 262144L);
                IOUtils.readFully((InputStream)fis, (byte[])buf, (int)0, (int)readLen);
                for (int i = readLen - 1; i >= 0; --i) {
                    if (buf[i] == FSEditLogOpCodes.OP_INVALID.getOpCode()) continue;
                    long l = pos + (long)i + 1L;
                    return l;
                }
            }
            long l = 0L;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamLimiter() throws IOException {
        File LIMITER_TEST_FILE = new File(TEST_DIR, "limiter.test");
        try (FileOutputStream fos = new FileOutputStream(LIMITER_TEST_FILE);){
            fos.write(18);
            fos.write(18);
            fos.write(18);
        }
        FileInputStream fin = new FileInputStream(LIMITER_TEST_FILE);
        BufferedInputStream bin = new BufferedInputStream(fin);
        try (FSEditLogLoader.PositionTrackingInputStream tracker = new FSEditLogLoader.PositionTrackingInputStream((InputStream)bin);){
            tracker.setLimit(2L);
            tracker.mark(100);
            tracker.read();
            tracker.read();
            try {
                tracker.read();
                Assert.fail((String)"expected to get IOException after reading past the limit");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            tracker.reset();
            tracker.mark(100);
            byte[] arr = new byte[3];
            try {
                tracker.read(arr);
                Assert.fail((String)"expected to get IOException after reading past the limit");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            tracker.reset();
            arr = new byte[2];
            tracker.read(arr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File prepareUnfinalizedTestEditLog(File testDir, int numTx, SortedMap<Long, Long> offsetToTxId) throws IOException {
        File inProgressFile = new File(testDir, NNStorage.getInProgressEditsFileName((long)1L));
        FSEditLog fsel = null;
        FSEditLog spyLog = null;
        try {
            fsel = FSImageTestUtil.createStandaloneEditLog(testDir);
            spyLog = (FSEditLog)Mockito.spy((Object)fsel);
            ((FSEditLog)Mockito.doNothing().when((Object)spyLog)).endCurrentLogSegment(true);
            spyLog.openForWrite(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            Assert.assertTrue((String)("should exist: " + inProgressFile), (boolean)inProgressFile.exists());
            for (int i = 0; i < numTx; ++i) {
                long trueOffset = TestFSEditLogLoader.getNonTrailerLength(inProgressFile);
                long thisTxId = spyLog.getLastWrittenTxId() + 1L;
                offsetToTxId.put(trueOffset, thisTxId);
                System.err.println("txid " + thisTxId + " at offset " + trueOffset);
                spyLog.logDelete("path" + i, (long)i, false);
                spyLog.logSync();
            }
        }
        finally {
            if (spyLog != null) {
                spyLog.close();
            } else if (fsel != null) {
                fsel.close();
            }
        }
        return inProgressFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateEditLogWithCorruptHeader() throws IOException {
        File testDir = new File(TEST_DIR, "testValidateEditLogWithCorruptHeader");
        TreeMap offsetToTxId = Maps.newTreeMap();
        File logFile = TestFSEditLogLoader.prepareUnfinalizedTestEditLog(testDir, 2, offsetToTxId);
        try (RandomAccessFile rwf = new RandomAccessFile(logFile, "rw");){
            rwf.seek(0L);
            rwf.writeLong(42L);
        }
        FSEditLogLoader.EditLogValidation validation = EditLogFileInputStream.scanEditLog((File)logFile, (long)Long.MAX_VALUE, (boolean)true);
        Assert.assertTrue((boolean)validation.hasCorruptHeader());
    }

    @Test
    public void testValidateEditLogWithCorruptBody() throws IOException {
        long expectedEndTxId;
        long txId;
        long txOffset;
        File testDir = new File(TEST_DIR, "testValidateEditLogWithCorruptBody");
        TreeMap offsetToTxId = Maps.newTreeMap();
        int NUM_TXNS = 20;
        File logFile = TestFSEditLogLoader.prepareUnfinalizedTestEditLog(testDir, 20, offsetToTxId);
        File logFileBak = new File(testDir, logFile.getName() + ".bak");
        Files.copy((File)logFile, (File)logFileBak);
        FSEditLogLoader.EditLogValidation validation = EditLogFileInputStream.scanEditLog((File)logFile, (long)Long.MAX_VALUE, (boolean)true);
        Assert.assertTrue((!validation.hasCorruptHeader() ? 1 : 0) != 0);
        Assert.assertEquals((long)21L, (long)validation.getEndTxId());
        for (Map.Entry entry : offsetToTxId.entrySet()) {
            txOffset = (Long)entry.getKey();
            txId = (Long)entry.getValue();
            Files.copy((File)logFileBak, (File)logFile);
            this.corruptByteInFile(logFile, txOffset);
            validation = EditLogFileInputStream.scanEditLog((File)logFile, (long)Long.MAX_VALUE, (boolean)true);
            expectedEndTxId = txId == 21L ? 20L : 21L;
            Assert.assertEquals((String)("Failed when corrupting txn opcode at " + txOffset), (long)expectedEndTxId, (long)validation.getEndTxId());
            Assert.assertTrue((!validation.hasCorruptHeader() ? 1 : 0) != 0);
        }
        for (Map.Entry entry : offsetToTxId.entrySet()) {
            txOffset = (Long)entry.getKey();
            txId = (Long)entry.getValue();
            Files.copy((File)logFileBak, (File)logFile);
            this.truncateFile(logFile, txOffset);
            validation = EditLogFileInputStream.scanEditLog((File)logFile, (long)Long.MAX_VALUE, (boolean)true);
            expectedEndTxId = txId == 0L ? -12345L : txId - 1L;
            Assert.assertEquals((String)("Failed when corrupting txid " + txId + " txn opcode at " + txOffset), (long)expectedEndTxId, (long)validation.getEndTxId());
            Assert.assertTrue((!validation.hasCorruptHeader() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testValidateEmptyEditLog() throws IOException {
        File testDir = new File(TEST_DIR, "testValidateEmptyEditLog");
        TreeMap offsetToTxId = Maps.newTreeMap();
        File logFile = TestFSEditLogLoader.prepareUnfinalizedTestEditLog(testDir, 0, offsetToTxId);
        this.truncateFile(logFile, 8L);
        FSEditLogLoader.EditLogValidation validation = EditLogFileInputStream.scanEditLog((File)logFile, (long)Long.MAX_VALUE, (boolean)true);
        Assert.assertTrue((!validation.hasCorruptHeader() ? 1 : 0) != 0);
        Assert.assertEquals((long)-12345L, (long)validation.getEndTxId());
    }

    private static FSEditLogOpCodes fromByte(byte opCode) {
        return byteToEnum.get(opCode);
    }

    @Test
    public void testFSEditLogOpCodes() throws IOException {
        for (FSEditLogOpCodes c : FSEditLogOpCodes.values()) {
            byte code = c.getOpCode();
            Assert.assertEquals((String)("c=" + c + ", code=" + code), (Object)c, (Object)FSEditLogOpCodes.fromByte((byte)code));
        }
        for (int b = 0; b < 256; ++b) {
            byte code = (byte)b;
            Assert.assertEquals((String)("b=" + b + ", code=" + code), (Object)TestFSEditLogLoader.fromByte(code), (Object)FSEditLogOpCodes.fromByte((byte)code));
        }
    }

    static {
        GenericTestUtils.setLogLevel((Log)FSImage.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Log)FSEditLogLoader.LOG, (Level)Level.ALL);
        TEST_DIR = PathUtils.getTestDir(TestFSEditLogLoader.class);
        byteToEnum = new HashMap<Byte, FSEditLogOpCodes>();
        for (FSEditLogOpCodes opCode : FSEditLogOpCodes.values()) {
            byteToEnum.put(opCode.getOpCode(), opCode);
        }
    }
}

