/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AdminStatesBaseTest;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMaintenanceState
extends AdminStatesBaseTest {
    public static final Logger LOG = LoggerFactory.getLogger(TestMaintenanceState.class);
    private static final long EXPIRATION_IN_MS = 50L;
    private int minMaintenanceR = 1;

    public TestMaintenanceState() {
        this.setUseCombinedHostFileManager();
    }

    void setMinMaintenanceR(int minMaintenanceR) {
        this.minMaintenanceR = minMaintenanceR;
        this.getConf().setInt("dfs.namenode.maintenance.replication.min", minMaintenanceR);
    }

    @Test(timeout=60000L)
    public void testMaintenanceMinReplConfigRange() {
        LOG.info("Setting testMaintenanceMinReplConfigRange");
        this.setMinMaintenanceR(-1);
        try {
            this.startCluster(1, 1);
            Assert.fail((String)"Cluster start should fail when 'dfs.namenode.maintenance.replication.min=-1'");
        }
        catch (IOException e) {
            LOG.info("Expected exception: " + e);
        }
        int defaultRepl = this.getConf().getInt("dfs.replication", 3);
        this.setMinMaintenanceR(defaultRepl + 1);
        try {
            this.startCluster(1, 1);
            Assert.fail((String)("Cluster start should fail when 'dfs.namenode.maintenance.replication.min > " + defaultRepl + "'"));
        }
        catch (IOException e) {
            LOG.info("Expected exception: " + e);
        }
    }

    @Test(timeout=360000L)
    public void testTakeNodeOutOfEnteringMaintenance() throws Exception {
        LOG.info("Starting testTakeNodeOutOfEnteringMaintenance");
        boolean replicas = true;
        Path file = new Path("/testTakeNodeOutOfEnteringMaintenance.dat");
        this.startCluster(1, 1);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 1, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, null, Long.MAX_VALUE, null, DatanodeInfo.AdminStates.ENTERING_MAINTENANCE);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 1, null, nodeOutofService);
        this.putNodeInService(0, nodeOutofService.getDatanodeUuid());
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testEnteringMaintenanceExpiration() throws Exception {
        LOG.info("Starting testEnteringMaintenanceExpiration");
        boolean replicas = true;
        Path file = new Path("/testEnteringMaintenanceExpiration.dat");
        this.startCluster(1, 1);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 1, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, null, Long.MAX_VALUE, null, DatanodeInfo.AdminStates.ENTERING_MAINTENANCE);
        this.takeNodeOutofService(0, nodeOutofService.getDatanodeUuid(), Time.now() + 50L, null, DatanodeInfo.AdminStates.NORMAL);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testInvalidExpiration() throws Exception {
        LOG.info("Starting testInvalidExpiration");
        boolean replicas = true;
        Path file = new Path("/testInvalidExpiration.dat");
        this.startCluster(1, 1);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 1, 1);
        this.takeNodeOutofService(0, null, Time.now(), null, DatanodeInfo.AdminStates.NORMAL);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testPutDeadNodeToMaintenance() throws Exception {
        LOG.info("Starting testPutDeadNodeToMaintenance");
        boolean replicas = true;
        Path file = new Path("/testPutDeadNodeToMaintenance.dat");
        this.startCluster(1, 1);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 1, 1);
        MiniDFSCluster.DataNodeProperties dnProp = this.getCluster().stopDataNode(0);
        DFSTestUtil.waitForDatanodeState(this.getCluster(), dnProp.datanode.getDatanodeUuid(), false, 20000);
        int deadInMaintenance = ns.getNumInMaintenanceDeadDataNodes();
        int liveInMaintenance = ns.getNumInMaintenanceLiveDataNodes();
        this.takeNodeOutofService(0, dnProp.datanode.getDatanodeUuid(), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        Assert.assertEquals((long)(deadInMaintenance + 1), (long)ns.getNumInMaintenanceDeadDataNodes());
        Assert.assertEquals((long)liveInMaintenance, (long)ns.getNumInMaintenanceLiveDataNodes());
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testPutDeadNodeToMaintenanceWithExpiration() throws Exception {
        LOG.info("Starting testPutDeadNodeToMaintenanceWithExpiration");
        Path file = new Path("/testPutDeadNodeToMaintenanceWithExpiration.dat");
        this.startCluster(1, 1);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 1, 1);
        MiniDFSCluster.DataNodeProperties dnProp = this.getCluster().stopDataNode(0);
        DFSTestUtil.waitForDatanodeState(this.getCluster(), dnProp.datanode.getDatanodeUuid(), false, 20000);
        int deadInMaintenance = ns.getNumInMaintenanceDeadDataNodes();
        int liveInMaintenance = ns.getNumInMaintenanceLiveDataNodes();
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, dnProp.datanode.getDatanodeUuid(), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        this.takeNodeOutofService(0, nodeOutofService.getDatanodeUuid(), Time.now() + 50L, null, DatanodeInfo.AdminStates.NORMAL);
        Assert.assertEquals((long)deadInMaintenance, (long)ns.getNumInMaintenanceDeadDataNodes());
        Assert.assertEquals((long)liveInMaintenance, (long)ns.getNumInMaintenanceLiveDataNodes());
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testTransitionFromDecommissioned() throws IOException {
        LOG.info("Starting testTransitionFromDecommissioned");
        Path file = new Path("/testTransitionFromDecommissioned.dat");
        this.startCluster(1, 4);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 3, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, null, 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        this.takeNodeOutofService(0, nodeOutofService.getDatanodeUuid(), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testTransitionFromDecommissionedAndExpired() throws IOException {
        LOG.info("Starting testTransitionFromDecommissionedAndExpired");
        Path file = new Path("/testTransitionFromDecommissionedAndExpired.dat");
        this.startCluster(1, 4);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 3, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, null, 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        this.takeNodeOutofService(0, nodeOutofService.getDatanodeUuid(), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        this.takeNodeOutofService(0, nodeOutofService.getDatanodeUuid(), Time.now() + 50L, null, DatanodeInfo.AdminStates.NORMAL);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testNodeDeadWhenInEnteringMaintenance() throws Exception {
        LOG.info("Starting testNodeDeadWhenInEnteringMaintenance");
        boolean numNamenodes = true;
        boolean numDatanodes = true;
        boolean replicas = true;
        Path file = new Path("/testNodeDeadWhenInEnteringMaintenance.dat");
        this.startCluster(1, 1);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 1, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, TestMaintenanceState.getFirstBlockFirstReplicaUuid((FileSystem)fileSys, file), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.ENTERING_MAINTENANCE);
        Assert.assertEquals((long)1L, (long)ns.getNumEnteringMaintenanceDataNodes());
        MiniDFSCluster.DataNodeProperties dnProp = this.getCluster().stopDataNode(nodeOutofService.getXferAddr());
        DFSTestUtil.waitForDatanodeState(this.getCluster(), nodeOutofService.getDatanodeUuid(), false, 20000);
        DFSClient client = this.getDfsClient(0);
        Assert.assertEquals((String)"maintenance node shouldn't be live", (long)0L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertEquals((long)1L, (long)ns.getNumEnteringMaintenanceDataNodes());
        this.getCluster().restartDataNode(dnProp, true);
        this.getCluster().waitActive();
        this.waitNodeState(nodeOutofService, DatanodeInfo.AdminStates.ENTERING_MAINTENANCE);
        Assert.assertEquals((long)1L, (long)ns.getNumEnteringMaintenanceDataNodes());
        Assert.assertEquals((String)"maintenance node should be live", (long)1L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testExpectedReplications() throws IOException {
        LOG.info("Starting testExpectedReplications");
        this.testExpectedReplication(1);
        this.testExpectedReplication(2);
        this.testExpectedReplication(3);
        this.testExpectedReplication(4);
    }

    private void testExpectedReplication(int replicationFactor) throws IOException {
        this.testExpectedReplication(replicationFactor, Math.max(replicationFactor - 1, this.minMaintenanceR));
    }

    private void testExpectedReplication(int replicationFactor, int expectedReplicasInRead) throws IOException {
        this.setup();
        this.startCluster(1, 5);
        Path file = new Path("/testExpectedReplication.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, replicationFactor, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, TestMaintenanceState.getFirstBlockFirstReplicaUuid((FileSystem)fileSys, file), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, expectedReplicasInRead, nodeOutofService);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
        this.teardown();
    }

    @Test(timeout=360000L)
    public void testZeroMinMaintenanceReplication() throws Exception {
        LOG.info("Starting testZeroMinMaintenanceReplication");
        this.setMinMaintenanceR(0);
        this.startCluster(1, 1);
        Path file = new Path("/testZeroMinMaintenanceReplication.dat");
        boolean replicas = true;
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 1, 1);
        this.takeNodeOutofService(0, null, Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testZeroMinMaintenanceReplicationWithExpiration() throws Exception {
        LOG.info("Starting testZeroMinMaintenanceReplicationWithExpiration");
        this.setMinMaintenanceR(0);
        this.startCluster(1, 1);
        Path file = new Path("/testZeroMinMaintenanceReplicationWithExpiration.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 1, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, null, Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        this.takeNodeOutofService(0, nodeOutofService.getDatanodeUuid(), Time.now() + 50L, null, DatanodeInfo.AdminStates.NORMAL);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testFileBlockReplicationAffectingMaintenance() throws Exception {
        int defaultReplication = this.getConf().getInt("dfs.replication", 3);
        int defaultMaintenanceMinRepl = this.getConf().getInt("dfs.namenode.maintenance.replication.min", 1);
        int maintenanceMinRepl = defaultMaintenanceMinRepl + 1;
        int fileBlockReplication = maintenanceMinRepl + 1;
        int numAddedDataNodes = 1;
        int numInitialDataNodes = maintenanceMinRepl * 2 - numAddedDataNodes;
        Assert.assertTrue((maintenanceMinRepl <= defaultReplication ? 1 : 0) != 0);
        this.testFileBlockReplicationImpl(maintenanceMinRepl, numInitialDataNodes, numAddedDataNodes, fileBlockReplication);
        maintenanceMinRepl = defaultMaintenanceMinRepl + 1;
        fileBlockReplication = maintenanceMinRepl - 1;
        numAddedDataNodes = 0;
        numInitialDataNodes = maintenanceMinRepl * 2 - numAddedDataNodes;
        this.testFileBlockReplicationImpl(maintenanceMinRepl, numInitialDataNodes, numAddedDataNodes, fileBlockReplication);
    }

    private void testFileBlockReplicationImpl(int maintenanceMinRepl, int numDataNodes, int numNewDataNodes, int fileBlockRepl) throws Exception {
        this.setup();
        LOG.info("Starting testLargerMinMaintenanceReplication - maintMinRepl: " + maintenanceMinRepl + ", numDNs: " + numDataNodes + ", numNewDNs: " + numNewDataNodes + ", fileRepl: " + fileBlockRepl);
        LOG.info("Setting maintenance minimum replication: " + maintenanceMinRepl);
        this.setMinMaintenanceR(maintenanceMinRepl);
        this.startCluster(1, numDataNodes);
        Path file = new Path("/testLargerMinMaintenanceReplication.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, fileBlockRepl, 1);
        DatanodeInfo[] nodes = TestMaintenanceState.getFirstBlockReplicasDatanodeInfos((FileSystem)fileSys, file);
        ArrayList<String> nodeUuids = new ArrayList<String>();
        for (int i = 0; i < maintenanceMinRepl && i < nodes.length; ++i) {
            nodeUuids.add(nodes[i].getDatanodeUuid());
        }
        List<DatanodeInfo> maintenanceDNs = this.takeNodeOutofService(0, nodeUuids, Long.MAX_VALUE, null, null, DatanodeInfo.AdminStates.ENTERING_MAINTENANCE);
        for (int i = 0; i < numNewDataNodes; ++i) {
            this.getCluster().startDataNodes(this.getConf(), 1, true, null, null);
        }
        this.getCluster().waitActive();
        this.refreshNodes(0);
        this.waitNodeState(maintenanceDNs, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
        this.teardown();
    }

    @Test(timeout=360000L)
    public void testTransitionToDecommission() throws IOException {
        LOG.info("Starting testTransitionToDecommission");
        boolean numNamenodes = true;
        int numDatanodes = 4;
        this.startCluster(1, 4);
        Path file = new Path("testTransitionToDecommission.dat");
        int replicas = 3;
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 3, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, TestMaintenanceState.getFirstBlockFirstReplicaUuid((FileSystem)fileSys, file), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        DFSClient client = this.getDfsClient(0);
        Assert.assertEquals((String)"All datanodes must be alive", (long)4L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 2, nodeOutofService);
        this.takeNodeOutofService(0, nodeOutofService.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 4, null);
        this.putNodeInService(0, nodeOutofService.getDatanodeUuid());
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 3, null);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testTransitionFromDecommissioning() throws IOException {
        LOG.info("Starting testTransitionFromDecommissioning");
        this.startCluster(1, 3);
        Path file = new Path("/testTransitionFromDecommissioning.dat");
        int replicas = 3;
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 3);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, null, 0L, null, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
        this.takeNodeOutofService(0, nodeOutofService.getDatanodeUuid(), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 2, nodeOutofService);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testDecommissionDifferentNodeAfterMaintenances() throws Exception {
        this.testDecommissionDifferentNodeAfterMaintenance(2);
        this.testDecommissionDifferentNodeAfterMaintenance(3);
        this.testDecommissionDifferentNodeAfterMaintenance(4);
    }

    private void testDecommissionDifferentNodeAfterMaintenance(int repl) throws Exception {
        this.setup();
        this.startCluster(1, 5);
        Path file = new Path("/testDecommissionDifferentNodeAfterMaintenance.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, repl, 1);
        DatanodeInfo[] nodes = TestMaintenanceState.getFirstBlockReplicasDatanodeInfos((FileSystem)fileSys, file);
        String maintenanceDNUuid = nodes[0].getDatanodeUuid();
        String decommissionDNUuid = nodes[1].getDatanodeUuid();
        DatanodeInfo maintenanceDN = this.takeNodeOutofService(0, maintenanceDNUuid, Long.MAX_VALUE, null, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        HashMap<DatanodeInfo, Long> maintenanceNodes = new HashMap<DatanodeInfo, Long>();
        maintenanceNodes.put(nodes[0], Long.MAX_VALUE);
        this.takeNodeOutofService(0, decommissionDNUuid, 0L, null, maintenanceNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, repl, maintenanceDN);
        this.putNodeInService(0, maintenanceDN);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, repl + 1, null);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
        this.teardown();
    }

    @Test(timeout=360000L)
    public void testMultipleNodesMaintenance() throws Exception {
        this.startCluster(1, 5);
        Path file = new Path("/testMultipleNodesMaintenance.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        int repl = 3;
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, repl, 1);
        DatanodeInfo[] nodes = TestMaintenanceState.getFirstBlockReplicasDatanodeInfos((FileSystem)fileSys, file);
        List<DatanodeInfo> maintenanceDN = this.takeNodeOutofService(0, Lists.newArrayList((Object[])new String[]{nodes[0].getDatanodeUuid(), nodes[1].getDatanodeUuid()}), Long.MAX_VALUE, null, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 1, null, nodes[0]);
        for (DatanodeInfo datanodeInfo : maintenanceDN) {
            this.putNodeInService(0, datanodeInfo);
        }
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, repl, null);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testChangeReplicationFactors() throws IOException {
        this.testChangeReplicationFactor(3, 4, 3);
        this.testChangeReplicationFactor(3, 2, 2);
        this.testChangeReplicationFactor(3, 1, 1);
    }

    private void testChangeReplicationFactor(int oldFactor, int newFactor, int expectedLiveReplicas) throws IOException {
        this.setup();
        LOG.info("Starting testChangeReplicationFactor {} {} {}", new Object[]{oldFactor, newFactor, expectedLiveReplicas});
        this.startCluster(1, 5);
        Path file = new Path("/testChangeReplicationFactor.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, oldFactor, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, TestMaintenanceState.getFirstBlockFirstReplicaUuid((FileSystem)fileSys, file), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, oldFactor - 1, nodeOutofService);
        DFSClient client = this.getDfsClient(0);
        client.setReplication(file.toString(), (short)newFactor);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, expectedLiveReplicas, nodeOutofService);
        this.putNodeInService(0, nodeOutofService.getDatanodeUuid());
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, newFactor, null);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
        this.teardown();
    }

    @Test(timeout=360000L)
    public void testTakeDeadNodeOutOfMaintenance() throws Exception {
        LOG.info("Starting testTakeDeadNodeOutOfMaintenance");
        boolean numNamenodes = true;
        int numDatanodes = 4;
        this.startCluster(1, 4);
        Path file = new Path("/testTakeDeadNodeOutOfMaintenance.dat");
        int replicas = 3;
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 3, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, TestMaintenanceState.getFirstBlockFirstReplicaUuid((FileSystem)fileSys, file), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 2, nodeOutofService);
        DFSClient client = this.getDfsClient(0);
        Assert.assertEquals((String)"All datanodes must be alive", (long)4L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        this.getCluster().stopDataNode(nodeOutofService.getXferAddr());
        DFSTestUtil.waitForDatanodeState(this.getCluster(), nodeOutofService.getDatanodeUuid(), false, 20000);
        Assert.assertEquals((String)"maintenance node shouldn't be alive", (long)3L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 2, nodeOutofService);
        this.putNodeInService(0, nodeOutofService.getDatanodeUuid());
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 3, nodeOutofService, null);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testWithNNAndDNRestart() throws Exception {
        LOG.info("Starting testWithNNAndDNRestart");
        boolean numNamenodes = true;
        int numDatanodes = 4;
        this.startCluster(1, 4);
        Path file = new Path("/testWithNNAndDNRestart.dat");
        int replicas = 3;
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, 3, 1);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, TestMaintenanceState.getFirstBlockFirstReplicaUuid((FileSystem)fileSys, file), Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 2, nodeOutofService);
        DFSClient client = this.getDfsClient(0);
        Assert.assertEquals((String)"All datanodes must be alive", (long)4L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        MiniDFSCluster.DataNodeProperties dnProp = this.getCluster().stopDataNode(nodeOutofService.getXferAddr());
        DFSTestUtil.waitForDatanodeState(this.getCluster(), nodeOutofService.getDatanodeUuid(), false, 20000);
        Assert.assertEquals((String)"maintenance node shouldn't be alive", (long)3L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 2, nodeOutofService);
        this.getCluster().restartNameNode(0);
        ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 3, null);
        this.getCluster().restartDataNode(dnProp, true);
        this.getCluster().waitActive();
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 3, nodeOutofService);
        this.putNodeInService(0, nodeOutofService.getDatanodeUuid());
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 3, null);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=3600000L)
    public void testWriteAfterMaintenance() throws IOException {
        LOG.info("Starting testWriteAfterMaintenance");
        this.startCluster(1, 3);
        Path file = new Path("/testWriteAfterMaintenance.dat");
        int replicas = 3;
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, null, Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, replicas, 2);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, replicas - 1, nodeOutofService, null);
        this.putNodeInService(0, nodeOutofService.getDatanodeUuid());
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, replicas, null);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testEnterMaintenanceWhenFileOpen() throws Exception {
        LOG.info("Starting testEnterMaintenanceWhenFileOpen");
        this.startCluster(1, 3);
        Path file = new Path("/testEnterMaintenanceWhenFileOpen.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        TestMaintenanceState.writeIncompleteFile((FileSystem)fileSys, file, (short)3, (short)2);
        this.takeNodeOutofService(0, null, Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=360000L)
    public void testInvalidation() throws IOException {
        LOG.info("Starting testInvalidation");
        int numNamenodes = 1;
        int numDatanodes = 3;
        this.startCluster(numNamenodes, numDatanodes);
        Path file = new Path("/testInvalidation.dat");
        int replicas = 3;
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, replicas);
        DatanodeInfo nodeOutofService = this.takeNodeOutofService(0, null, Long.MAX_VALUE, null, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        DFSClient client = this.getDfsClient(0);
        client.setReplication(file.toString(), (short)1);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 1, nodeOutofService);
        this.getCluster().restartNameNode(0);
        ns = this.getCluster().getNamesystem(0);
        TestMaintenanceState.checkWithRetry(ns, (FileSystem)fileSys, file, 1, nodeOutofService);
        TestMaintenanceState.cleanupFile((FileSystem)fileSys, file);
    }

    @Test(timeout=120000L)
    public void testFileCloseAfterEnteringMaintenance() throws Exception {
        LOG.info("Starting testFileCloseAfterEnteringMaintenance");
        int expirationInMs = 30000;
        int numDataNodes = 3;
        int numNameNodes = 1;
        this.getConf().setInt("dfs.namenode.replication.min", 2);
        this.startCluster(numNameNodes, numDataNodes);
        this.getCluster().waitActive();
        FSNamesystem fsn = this.getCluster().getNameNode().getNamesystem();
        ArrayList<String> hosts = new ArrayList<String>();
        for (DataNode dn : this.getCluster().getDataNodes()) {
            hosts.add(dn.getDisplayName());
            this.putNodeInService(0, dn.getDatanodeUuid());
        }
        Assert.assertEquals((long)numDataNodes, (long)fsn.getNumLiveDataNodes());
        Path openFile = new Path("/testClosingFileInMaintenance.dat");
        TestMaintenanceState.writeFile((FileSystem)this.getCluster().getFileSystem(), openFile, 3);
        FSDataOutputStream fsDataOutputStream = this.getCluster().getFileSystem().append(openFile);
        byte[] bytes = new byte[1024];
        fsDataOutputStream.write(bytes);
        fsDataOutputStream.hsync();
        LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(0), openFile.toString(), 0L, 24576L);
        DatanodeInfo[] dnInfos4LastBlock = lbs.getLastLocatedBlock().getLocations();
        this.takeNodeOutofService(0, Lists.newArrayList((Object[])new String[]{dnInfos4LastBlock[0].getDatanodeUuid(), dnInfos4LastBlock[1].getDatanodeUuid()}), Time.now() + (long)expirationInMs, null, null, DatanodeInfo.AdminStates.ENTERING_MAINTENANCE);
        fsDataOutputStream.close();
        TestMaintenanceState.cleanupFile((FileSystem)this.getCluster().getFileSystem(), openFile);
    }

    static String getFirstBlockFirstReplicaUuid(FileSystem fileSys, Path name) throws IOException {
        DatanodeInfo[] nodes = TestMaintenanceState.getFirstBlockReplicasDatanodeInfos(fileSys, name);
        if (nodes != null && nodes.length != 0) {
            return nodes[0].getDatanodeUuid();
        }
        return null;
    }

    static String checkFile(FSNamesystem ns, FileSystem fileSys, Path name, int repl, DatanodeInfo expectedExcludedNode, DatanodeInfo expectedMaintenanceNode) throws IOException {
        Assert.assertTrue((String)("Not HDFS:" + fileSys.getUri()), (boolean)(fileSys instanceof DistributedFileSystem));
        HdfsDataInputStream dis = (HdfsDataInputStream)fileSys.open(name);
        BlockManager bm = ns.getBlockManager();
        List dinfo = dis.getAllBlocks();
        for (LocatedBlock blk : dinfo) {
            int j;
            DatanodeInfo[] nodes = blk.getLocations();
            for (j = 0; j < nodes.length; ++j) {
                if (expectedExcludedNode != null && nodes[j].equals((Object)expectedExcludedNode)) {
                    String output = "For block " + blk.getBlock() + " replica on " + nodes[j] + " found in LocatedBlock.";
                    LOG.info(output);
                    return output;
                }
                if (!nodes[j].isInMaintenance()) continue;
                String output = "For block " + blk.getBlock() + " replica on " + nodes[j] + " which is in maintenance state.";
                LOG.info(output);
                return output;
            }
            if (repl != nodes.length) {
                String output = "Wrong number of replicas for block " + blk.getBlock() + ": expected " + repl + ", got " + nodes.length + " ,";
                for (j = 0; j < nodes.length; ++j) {
                    output = output + nodes[j] + ",";
                }
                output = output + "pending block # " + ns.getPendingReplicationBlocks() + " ,";
                output = output + "under replicated # " + ns.getUnderReplicatedBlocks() + " ,";
                if (expectedExcludedNode != null) {
                    output = output + "excluded node " + expectedExcludedNode;
                }
                LOG.info(output);
                return output;
            }
            Iterator storageInfoIter = bm.getStorages(blk.getBlock().getLocalBlock()).iterator();
            ArrayList<DatanodeDescriptor> maintenanceNodes = new ArrayList<DatanodeDescriptor>();
            while (storageInfoIter.hasNext()) {
                DatanodeDescriptor node = ((DatanodeStorageInfo)storageInfoIter.next()).getDatanodeDescriptor();
                if (!node.isMaintenance()) continue;
                maintenanceNodes.add(node);
            }
            if (expectedMaintenanceNode != null) {
                if (maintenanceNodes.contains(expectedMaintenanceNode)) continue;
                String output = "No maintenance replica on " + expectedMaintenanceNode;
                LOG.info(output);
                return output;
            }
            if (maintenanceNodes.size() == 0) continue;
            String output = "Has maintenance replica(s)";
            LOG.info(output);
            return output;
        }
        return null;
    }

    static void checkWithRetry(FSNamesystem ns, FileSystem fileSys, Path name, int repl, DatanodeInfo inMaintenanceNode) {
        TestMaintenanceState.checkWithRetry(ns, fileSys, name, repl, inMaintenanceNode, inMaintenanceNode);
    }

    static void checkWithRetry(final FSNamesystem ns, final FileSystem fileSys, final Path name, final int repl, final DatanodeInfo excludedNode, final DatanodeInfo underMaintenanceNode) {
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    String output = null;
                    try {
                        output = TestMaintenanceState.checkFile(ns, fileSys, name, repl, excludedNode, underMaintenanceNode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return output == null;
                }
            }, (int)100, (int)60000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static DatanodeInfo[] getFirstBlockReplicasDatanodeInfos(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((String)("Not HDFS:" + fileSys.getUri()), (boolean)(fileSys instanceof DistributedFileSystem));
        HdfsDataInputStream dis = (HdfsDataInputStream)fileSys.open(name);
        List dinfo = dis.getAllBlocks();
        if (dinfo.iterator().hasNext()) {
            return ((LocatedBlock)dinfo.iterator().next()).getLocations();
        }
        return null;
    }

    @Test(timeout=120000L)
    public void testReportMaintenanceNodes() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        System.setErr(new PrintStream(err));
        LOG.info("Starting testReportMaintenanceNodes");
        int expirationInMs = 30000;
        int numNodes = 2;
        this.setMinMaintenanceR(numNodes);
        this.startCluster(1, numNodes);
        this.getCluster().waitActive();
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        this.getConf().set("fs.defaultFS", fileSys.getUri().toString());
        DFSAdmin dfsAdmin = new DFSAdmin(this.getConf());
        FSNamesystem fsn = this.getCluster().getNameNode().getNamesystem();
        Assert.assertEquals((long)numNodes, (long)fsn.getNumLiveDataNodes());
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report", "-enteringmaintenance", "-inmaintenance"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertThat((Object)out.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Entering maintenance datanodes (0):"), (Matcher)CoreMatchers.containsString((String)"In maintenance datanodes (0):"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)this.getCluster().getDataNodes().get(0).getDisplayName())), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)this.getCluster().getDataNodes().get(1).getDisplayName())))));
        Path file = new Path("/testReportMaintenanceNodes.dat");
        TestMaintenanceState.writeFile((FileSystem)fileSys, file, numNodes, 1);
        DatanodeInfo[] nodes = TestMaintenanceState.getFirstBlockReplicasDatanodeInfos((FileSystem)fileSys, file);
        DatanodeInfo maintenanceDN = this.takeNodeOutofService(0, nodes[0].getDatanodeUuid(), Time.now() + (long)expirationInMs, null, null, DatanodeInfo.AdminStates.ENTERING_MAINTENANCE);
        Assert.assertEquals((long)1L, (long)fsn.getNumEnteringMaintenanceDataNodes());
        out.reset();
        err.reset();
        ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report", "-enteringmaintenance"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertThat((Object)out.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Entering maintenance datanodes (1):"), (Matcher)CoreMatchers.containsString((String)nodes[0].getXferAddr()), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)nodes[1].getXferAddr())))));
        out.reset();
        err.reset();
        this.getCluster().startDataNodes(this.getConf(), 1, true, null, null);
        this.getCluster().waitActive();
        this.waitNodeState(maintenanceDN, DatanodeInfo.AdminStates.IN_MAINTENANCE);
        Assert.assertEquals((long)1L, (long)fsn.getNumInMaintenanceLiveDataNodes());
        ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report", "-inmaintenance"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertThat((Object)out.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"In maintenance datanodes (1):"), (Matcher)CoreMatchers.containsString((String)nodes[0].getXferAddr()), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)nodes[1].getXferAddr())), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)this.getCluster().getDataNodes().get(2).getDisplayName())))));
        TestMaintenanceState.cleanupFile((FileSystem)this.getCluster().getFileSystem(), file);
    }
}

