/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStorageLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.VolumeId;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.BlockStorageLocationUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOpsCountStatistics;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.impl.LeaseRenewer;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.web.HftpFileSystem;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistributedFileSystem {
    private static final Random RAN = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(TestDistributedFileSystem.class);
    private boolean dualPortTesting = false;
    private boolean noXmlDefaults = false;

    private HdfsConfiguration getTestConfiguration() {
        HdfsConfiguration conf;
        if (this.noXmlDefaults) {
            conf = new HdfsConfiguration(false);
            String namenodeDir = new File(MiniDFSCluster.getBaseDirectory(), "name").getAbsolutePath();
            conf.set("dfs.namenode.name.dir", namenodeDir);
            conf.set("dfs.namenode.edits.dir", namenodeDir);
        } else {
            conf = new HdfsConfiguration();
        }
        if (this.dualPortTesting) {
            conf.set("dfs.namenode.servicerpc-address", "localhost:0");
        }
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 0L);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyDelegationToken() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            fileSys.getDelegationToken("");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileSystemCloseAll() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        URI address = FileSystem.getDefaultUri((Configuration)conf);
        try {
            FileSystem.closeAll();
            conf = this.getTestConfiguration();
            FileSystem.setDefaultUri((Configuration)conf, (URI)address);
            FileSystem.get((Configuration)conf);
            FileSystem.get((Configuration)conf);
            FileSystem.closeAll();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSClose() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            fileSys.create(new Path("/test/dfsclose/file-0"));
            fileSys.create(new Path("/test/dfsclose/file-1"));
            Path p = new Path("/non-empty-file");
            DFSTestUtil.createFile((FileSystem)fileSys, p, 1L, (short)1, 0L);
            DFSTestUtil.readFile((FileSystem)fileSys, p);
            fileSys.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testDFSCloseOrdering() throws Exception {
        MyDistributedFileSystem fs = new MyDistributedFileSystem();
        Path path = new Path("/a");
        fs.deleteOnExit(path);
        fs.close();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{fs.dfs});
        ((DFSClient)inOrder.verify((Object)fs.dfs)).closeOutputStreams(Matchers.eq((boolean)false));
        ((DFSClient)inOrder.verify((Object)fs.dfs)).delete((String)Matchers.eq((Object)path.toString()), Matchers.eq((boolean)true));
        ((DFSClient)inOrder.verify((Object)fs.dfs)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSSeekExceptions() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            String file = "/test/fileclosethenseek/file-0";
            Path path = new Path(file);
            FSDataOutputStream output = fileSys.create(path);
            output.writeBytes("Some test data to write longer than 10 bytes");
            output.close();
            FSDataInputStream input = fileSys.open(path);
            input.seek(10L);
            boolean threw = false;
            try {
                input.seek(100L);
            }
            catch (IOException e) {
                threw = true;
            }
            Assert.assertTrue((String)"Failed to throw IOE when seeking past end", (boolean)threw);
            input.close();
            threw = false;
            try {
                input.seek(1L);
            }
            catch (IOException e) {
                threw = true;
            }
            Assert.assertTrue((String)"Failed to throw IOE when seeking after close", (boolean)threw);
            fileSys.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSClient() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        long grace = 1000L;
        MiniDFSCluster cluster = null;
        LeaseRenewer.setLeaseRenewerGraceDefault((long)1000L);
        try {
            FSDataInputStream in2;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            String filepathstring = "/test/LeaseChecker/foo";
            Path[] filepaths = new Path[4];
            for (int i = 0; i < filepaths.length; ++i) {
                filepaths[i] = new Path("/test/LeaseChecker/foo" + i);
            }
            long millis = Time.now();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Method checkMethod = dfs.dfs.getLeaseRenewer().getClass().getDeclaredMethod("isRunning", new Class[0]);
            checkMethod.setAccessible(true);
            Assert.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            FSDataOutputStream out = dfs.create(filepaths[0]);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out.writeLong(millis);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out.close();
            Thread.sleep(750L);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            for (int i = 0; i < 3; ++i) {
                if (!((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])).booleanValue()) continue;
                Thread.sleep(500L);
            }
            Assert.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            FSDataOutputStream out1 = dfs.create(filepaths[1]);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            FSDataOutputStream out2 = dfs.create(filepaths[2]);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out1.writeLong(millis);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out1.close();
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out2.writeLong(millis);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out2.close();
            Thread.sleep(750L);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            FSDataOutputStream out3 = dfs.create(filepaths[3]);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            Thread.sleep(750L);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out3.writeLong(millis);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out3.close();
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            Thread.sleep(750L);
            Assert.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            for (int i = 0; i < 3; ++i) {
                if (!((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])).booleanValue()) continue;
                Thread.sleep(500L);
            }
            Assert.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            dfs.close();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/wrwelkj");
            Assert.assertFalse((String)"File should not exist for test.", (boolean)fs.exists(dir));
            try {
                in2 = fs.open(dir);
                try {
                    in2.close();
                    fs.close();
                }
                finally {
                    Assert.assertTrue((String)"Did not get a FileNotFoundException for non-existing file.", (boolean)false);
                }
            }
            catch (FileNotFoundException in2) {
                // empty catch block
            }
            dfs = cluster.getFileSystem();
            checkMethod = dfs.dfs.getLeaseRenewer().getClass().getDeclaredMethod("isRunning", new Class[0]);
            checkMethod.setAccessible(true);
            Assert.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            in2 = dfs.open(filepaths[0]);
            Assert.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            Assert.assertEquals((long)millis, (long)in2.readLong());
            Assert.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            in2.close();
            Assert.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            dfs.close();
            String uri = "hdfs://127.0.0.1:" + cluster.getNameNodePort() + "/test/ipAddress/file";
            Path path = new Path(uri);
            FileSystem fs2 = FileSystem.get((URI)path.toUri(), (Configuration)conf);
            FSDataOutputStream out4 = fs2.create(path);
            byte[] buf = new byte[1024];
            out4.write(buf);
            out4.close();
            FSDataInputStream in3 = fs2.open(path);
            in3.readFully(buf);
            in3.close();
            fs2.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearStatistics() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/testClearStatistics");
            long mkdirCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS);
            long writeCount = DFSTestUtil.getStatistics((FileSystem)dfs).getWriteOps();
            dfs.mkdirs(dir);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS, mkdirCount + 1L);
            Assert.assertEquals((long)(++writeCount), (long)DFSTestUtil.getStatistics((FileSystem)dfs).getWriteOps());
            long createCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.CREATE);
            FSDataOutputStream out = dfs.create(new Path(dir, "tmpFile"), (short)1);
            out.write(40);
            out.close();
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.CREATE, createCount + 1L);
            Assert.assertEquals((long)(++writeCount), (long)DFSTestUtil.getStatistics((FileSystem)dfs).getWriteOps());
            FileSystem.clearStatistics();
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS, 0L);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.CREATE, 0L);
            this.checkStatistics((FileSystem)dfs, 0, 0, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatistics() throws IOException {
        FileSystem.getStatistics((String)"hdfs", DistributedFileSystem.class).reset();
        ThreadLocal data = (ThreadLocal)Whitebox.getInternalState((Object)FileSystem.getStatistics((String)"hdfs", DistributedFileSystem.class), (String)"threadData");
        data.set(null);
        int lsLimit = 2;
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setInt("dfs.ls.limit", lsLimit);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/test");
            Path file = new Path(dir, "file");
            int readOps = 0;
            int writeOps = 0;
            int largeReadOps = 0;
            long opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS);
            fs.mkdirs(dir);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.CREATE);
            FSDataOutputStream out = fs.create(file, (short)1);
            out.close();
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.CREATE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_STATUS);
            FileStatus status = fs.getFileStatus(file);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_STATUS, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_BLOCK_LOCATIONS);
            fs.getFileBlockLocations(file, 0L, 0L);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_BLOCK_LOCATIONS, opCount + 1L);
            fs.getFileBlockLocations(status, 0L, 0L);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_BLOCK_LOCATIONS, opCount + 2L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.OPEN);
            FSDataInputStream in = fs.open(file);
            in.close();
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.OPEN, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_REPLICATION);
            fs.setReplication(file, (short)2);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_REPLICATION, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.RENAME);
            Path file1 = new Path(dir, "file1");
            fs.rename(file, file1);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.RENAME, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_CONTENT_SUMMARY);
            fs.getContentSummary(file1);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_CONTENT_SUMMARY, opCount + 1L);
            long mkdirOp = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS);
            long listStatusOp = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.LIST_STATUS);
            for (int i = 0; i < 10; ++i) {
                Path p = new Path(dir, Integer.toString(i));
                fs.mkdirs(p);
                ++mkdirOp;
                FileStatus[] list = fs.listStatus(dir);
                if (list.length > lsLimit) {
                    int iterations = (int)Math.ceil((double)list.length / (double)lsLimit);
                    largeReadOps += iterations;
                    readOps += iterations;
                    listStatusOp += (long)iterations;
                } else {
                    ++readOps;
                    ++listStatusOp;
                }
                this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
                TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS, mkdirOp);
                TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.LIST_STATUS, listStatusOp);
            }
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_STATUS);
            fs.getStatus(file1);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_STATUS, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_CHECKSUM);
            fs.getFileChecksum(file1);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_CHECKSUM, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_PERMISSION);
            fs.setPermission(file1, new FsPermission(511));
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_PERMISSION, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_TIMES);
            fs.setTimes(file1, 0L, 0L);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_TIMES, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_OWNER);
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            fs.setOwner(file1, ugi.getUserName(), ugi.getGroupNames()[0]);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_OWNER, opCount + 1L);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.DELETE);
            fs.delete(dir, true);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.DELETE, opCount + 1L);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testConcurrentStatistics() throws IOException, InterruptedException {
        FileSystem.getStatistics((String)"hdfs", DistributedFileSystem.class).reset();
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder(new Configuration()).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        int numThreads = 5;
        ExecutorService threadPool = HadoopExecutors.newFixedThreadPool((int)5);
        try {
            final CountDownLatch allExecutorThreadsReady = new CountDownLatch(5);
            final CountDownLatch startBlocker = new CountDownLatch(1);
            final CountDownLatch allDone = new CountDownLatch(5);
            final AtomicReference childError = new AtomicReference();
            for (int i = 0; i < 5; ++i) {
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        allExecutorThreadsReady.countDown();
                        try {
                            startBlocker.await();
                            DistributedFileSystem fs = cluster.getFileSystem();
                            fs.mkdirs(new Path("/testStatisticsParallelChild"));
                        }
                        catch (Throwable t) {
                            LOG.error("Child failed when calling mkdir", t);
                            childError.compareAndSet(null, t);
                        }
                        finally {
                            allDone.countDown();
                        }
                    }
                });
            }
            long oldMkdirOpCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS);
            allExecutorThreadsReady.await();
            startBlocker.countDown();
            allDone.await();
            Assert.assertNull((String)("Child failed with exception " + childError.get()), childError.get());
            this.checkStatistics((FileSystem)fs, 0, 5, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS, 5L + oldMkdirOpCount);
            Iterator opCountIter = FileSystem.getGlobalStorageStatistics().get("DFSOpsCountStatistics").getLongStatistics();
            while (opCountIter.hasNext()) {
                StorageStatistics.LongStatistic opCount = (StorageStatistics.LongStatistic)opCountIter.next();
                if (DFSOpsCountStatistics.OpType.MKDIRS.getSymbol().equals(opCount.getName())) {
                    Assert.assertEquals((String)"Unexpected op count from iterator!", (long)(5L + oldMkdirOpCount), (long)opCount.getValue());
                }
                LOG.info(opCount.getName() + "\t" + opCount.getValue());
            }
        }
        finally {
            threadPool.shutdownNow();
            cluster.shutdown();
        }
    }

    private void checkStatistics(FileSystem fs, int readOps, int writeOps, int largeReadOps) {
        Assert.assertEquals((long)readOps, (long)DFSTestUtil.getStatistics(fs).getReadOps());
        Assert.assertEquals((long)writeOps, (long)DFSTestUtil.getStatistics(fs).getWriteOps());
        Assert.assertEquals((long)largeReadOps, (long)DFSTestUtil.getStatistics(fs).getLargeReadOps());
    }

    private void checkReadStatistics(FileSystem fs, int distance, long expectedReadBytes) {
        long bytesRead = DFSTestUtil.getStatistics(fs).getBytesReadByDistance(distance);
        Assert.assertEquals((long)expectedReadBytes, (long)bytesRead);
    }

    @Test
    public void testLocalHostReadStatistics() throws Exception {
        this.testReadFileSystemStatistics(0, false, false);
    }

    @Test
    public void testLocalRackReadStatistics() throws Exception {
        this.testReadFileSystemStatistics(2, false, false);
    }

    @Test
    public void testRemoteRackOfFirstDegreeReadStatistics() throws Exception {
        this.testReadFileSystemStatistics(4, false, false);
    }

    @Test
    public void testInvalidScriptMappingFileReadStatistics() throws Exception {
        this.testReadFileSystemStatistics(0, true, true);
    }

    @Test
    public void testEmptyScriptMappingFileReadStatistics() throws Exception {
        this.testReadFileSystemStatistics(0, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadFileSystemStatistics(int expectedDistance, boolean useScriptMapping, boolean invalidScriptMappingFile) throws IOException {
        MiniDFSCluster cluster = null;
        StaticMapping.addNodeToRack((String)NetUtils.getLocalHostname(), (String)"/rackClient");
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("fs.client.resolve.topology.enabled", true);
        conf.set("dfs.client.context", "testContext_" + expectedDistance);
        if (useScriptMapping) {
            conf.setClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class);
            if (invalidScriptMappingFile) {
                conf.set("net.topology.script.file.name", "invalidScriptFile.txt");
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).useConfiguredTopologyMappingClass(true).build();
        } else if (expectedDistance == 0) {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).hosts(new String[]{NetUtils.getLocalHostname()}).build();
        } else if (expectedDistance == 2) {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).racks(new String[]{"/rackClient"}).build();
        } else if (expectedDistance == 4) {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).racks(new String[]{"/rackFoo"}).build();
        }
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.getStatistics((FileSystem)fs).reset();
            Path dir = new Path("/test");
            Path file = new Path(dir, "file");
            String input = "hello world";
            DFSTestUtil.writeFile((FileSystem)fs, file, input);
            FSDataInputStream stm = fs.open(file);
            byte[] actual = new byte[4096];
            stm.read(actual);
            this.checkReadStatistics((FileSystem)fs, expectedDistance, input.length());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void checkOpStatistics(DFSOpsCountStatistics.OpType op, long count) {
        Assert.assertEquals((String)("Op " + op.getSymbol() + " has unexpected count!"), (long)count, (long)TestDistributedFileSystem.getOpStatistics(op));
    }

    private static long getOpStatistics(DFSOpsCountStatistics.OpType op) {
        return GlobalStorageStatistics.INSTANCE.get("DFSOpsCountStatistics").getLong(op.getSymbol());
    }

    @Test
    public void testFileChecksum() throws Exception {
        GenericTestUtils.setLogLevel((Logger)HftpFileSystem.LOG, (Level)Level.ALL);
        long seed = RAN.nextLong();
        System.out.println("seed=" + seed);
        RAN.setSeed(seed);
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.webhdfs.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem hdfs = cluster.getFileSystem();
        String nnAddr = conf.get("dfs.namenode.http-address");
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"user"});
        try {
            hdfs.getFileChecksum(new Path("/test/TestNonExistingFile"));
            Assert.fail((String)"Expecting FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((String)"Not throwing the intended exception message", (boolean)e.getMessage().contains("File does not exist: /test/TestNonExistingFile"));
        }
        try {
            Path path = new Path("/test/TestExistingDir/");
            hdfs.mkdirs(path);
            hdfs.getFileChecksum(path);
            Assert.fail((String)"Expecting FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((String)"Not throwing the intended exception message", (boolean)e.getMessage().contains("Path is not a file: /test/TestExistingDir"));
        }
        final String hftpuri = "hftp://" + nnAddr;
        System.out.println("hftpuri=" + hftpuri);
        FileSystem hftp = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>((Configuration)conf){
            final /* synthetic */ Configuration val$conf;
            {
                this.val$conf = configuration;
            }

            @Override
            public FileSystem run() throws Exception {
                return new Path(hftpuri).getFileSystem(this.val$conf);
            }
        });
        final String webhdfsuri = "webhdfs://" + nnAddr;
        System.out.println("webhdfsuri=" + webhdfsuri);
        FileSystem webhdfs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>((Configuration)conf){
            final /* synthetic */ Configuration val$conf;
            {
                this.val$conf = configuration;
            }

            @Override
            public FileSystem run() throws Exception {
                return new Path(webhdfsuri).getFileSystem(this.val$conf);
            }
        });
        Path dir = new Path("/filechecksum");
        int block_size = 1024;
        int buffer_size = conf.getInt("io.file.buffer.size", 4096);
        conf.setInt("dfs.bytes-per-checksum", 512);
        for (int n = 0; n < 5; ++n) {
            byte[] data = new byte[RAN.nextInt(511) + n * 1024 + 1];
            RAN.nextBytes(data);
            System.out.println("data.length=" + data.length);
            Path foo = new Path(dir, "foo" + n);
            FSDataOutputStream out = hdfs.create(foo, false, buffer_size, (short)2, 1024L);
            out.write(data);
            out.close();
            FileChecksum hdfsfoocs = hdfs.getFileChecksum(foo);
            System.out.println("hdfsfoocs=" + hdfsfoocs);
            FileChecksum hftpfoocs = hftp.getFileChecksum(foo);
            System.out.println("hftpfoocs=" + hftpfoocs);
            Path qualified = new Path(hftpuri + dir, "foo" + n);
            FileChecksum qfoocs = hftp.getFileChecksum(qualified);
            System.out.println("qfoocs=" + qfoocs);
            FileChecksum webhdfsfoocs = webhdfs.getFileChecksum(foo);
            System.out.println("webhdfsfoocs=" + webhdfsfoocs);
            Path webhdfsqualified = new Path(webhdfsuri + dir, "foo" + n);
            FileChecksum webhdfs_qfoocs = webhdfs.getFileChecksum(webhdfsqualified);
            System.out.println("webhdfs_qfoocs=" + webhdfs_qfoocs);
            Path zeroByteFile = new Path(dir, "zeroByteFile" + n);
            FSDataOutputStream out2 = hdfs.create(zeroByteFile, false, buffer_size, (short)2, 1024L);
            out2.close();
            Path bar = new Path(dir, "bar" + n);
            FSDataOutputStream out3 = hdfs.create(bar, false, buffer_size, (short)2, 1024L);
            out3.write(data);
            out3.close();
            FileChecksum zeroChecksum = hdfs.getFileChecksum(zeroByteFile);
            String magicValue = "MD5-of-0MD5-of-0CRC32:70bc8f4b72a86921468bf8e8441dce51";
            Assert.assertEquals((Object)"MD5-of-0MD5-of-0CRC32:70bc8f4b72a86921468bf8e8441dce51", (Object)zeroChecksum.toString());
            FileChecksum checksumWith0 = hdfs.getFileChecksum(bar, 0L);
            Assert.assertEquals((Object)zeroChecksum, (Object)checksumWith0);
            try {
                hdfs.getFileChecksum(new Path(dir, "none-existent"), 8L);
                Assert.fail();
            }
            catch (Exception ioe) {
                FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
            }
            try {
                FileChecksum noneExistentChecksumWith0 = hdfs.getFileChecksum(new Path(dir, "none-existent"), 0L);
                Assert.fail();
            }
            catch (Exception ioe) {
                FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
            }
            FileChecksum barcs = hdfs.getFileChecksum(bar);
            int barhashcode = barcs.hashCode();
            Assert.assertEquals((long)hdfsfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)hdfsfoocs, (Object)barcs);
            Assert.assertEquals((long)hftpfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)hftpfoocs, (Object)barcs);
            Assert.assertEquals((long)qfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)qfoocs, (Object)barcs);
            Assert.assertEquals((long)webhdfsfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)webhdfsfoocs, (Object)barcs);
            Assert.assertEquals((long)webhdfs_qfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)webhdfs_qfoocs, (Object)barcs);
            hdfs.setPermission(dir, new FsPermission(0));
            try {
                hftp.getFileChecksum(qualified);
                Assert.fail();
            }
            catch (IOException ioe) {
                FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
            }
            try {
                webhdfs.getFileChecksum(webhdfsqualified);
                Assert.fail();
            }
            catch (IOException ioe) {
                FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
            }
            hdfs.setPermission(dir, new FsPermission(511));
        }
        cluster.shutdown();
    }

    @Test
    public void testAllWithDualPort() throws Exception {
        this.dualPortTesting = true;
        try {
            this.testFileSystemCloseAll();
            this.testDFSClose();
            this.testDFSClient();
            this.testFileChecksum();
        }
        finally {
            this.dualPortTesting = false;
        }
    }

    @Test
    public void testAllWithNoXmlDefaults() throws Exception {
        this.noXmlDefaults = true;
        try {
            this.testFileSystemCloseAll();
            this.testDFSClose();
            this.testDFSClient();
            this.testFileChecksum();
        }
        finally {
            this.noXmlDefaults = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testLocatedFileStatusStorageIdsTypes() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/testListLocatedStatus");
            int blockSize = 4096;
            int numBlocks = 10;
            int repl = 2;
            DFSTestUtil.createFile((FileSystem)fs, testFile, 4096, 40960L, 4096L, (short)2, 712173L);
            DFSTestUtil.waitForReplication(fs, testFile, (short)2, 30000);
            RemoteIterator it = fs.listLocatedStatus(testFile);
            Assert.assertTrue((String)"Expected file to be present", (boolean)it.hasNext());
            LocatedFileStatus stat = (LocatedFileStatus)it.next();
            BlockLocation[] locs = stat.getBlockLocations();
            Assert.assertEquals((String)"Unexpected number of locations", (long)10L, (long)locs.length);
            HashSet<String> dnStorageIds = new HashSet<String>();
            for (DataNode d : cluster.getDataNodes()) {
                FsDatasetSpi.FsVolumeReferences volumes = d.getFSDataset().getFsVolumeReferences();
                Throwable throwable = null;
                try {
                    for (FsVolumeSpi vol : volumes) {
                        dnStorageIds.add(vol.getStorageID());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (volumes == null) continue;
                    if (throwable != null) {
                        try {
                            volumes.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    volumes.close();
                }
            }
            for (BlockLocation loc : locs) {
                String[] ids = loc.getStorageIds();
                HashSet storageIds = new HashSet();
                Collections.addAll(storageIds, ids);
                Assert.assertEquals((String)"Unexpected num storage ids", (long)2L, (long)storageIds.size());
                Assert.assertTrue((String)"Unknown storage IDs found!", (boolean)dnStorageIds.containsAll(storageIds));
                StorageType[] types = loc.getStorageTypes();
                Assert.assertEquals((String)"Unexpected num storage types", (long)2L, (long)types.length);
                for (StorageType t : types) {
                    Assert.assertEquals((String)"Unexpected storage type", (Object)StorageType.DEFAULT, (Object)t);
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testGetFileBlockStorageLocationsBatching() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        GenericTestUtils.setLogLevel((Logger)ProtobufRpcEngine.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)BlockStorageLocationUtil.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.TRACE);
        conf.setBoolean("dfs.datanode.hdfs-blocks-metadata.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            String name;
            VolumeId id;
            int i;
            final DistributedFileSystem fs = cluster.getFileSystem();
            final Path tmpFile1 = new Path("/tmpfile1.dat");
            final Path tmpFile2 = new Path("/tmpfile2.dat");
            DFSTestUtil.createFile((FileSystem)fs, tmpFile1, 1024L, (short)2, 0xDEADDEADL);
            DFSTestUtil.createFile((FileSystem)fs, tmpFile2, 1024L, (short)2, 0xDEADDEADL);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        ArrayList list = Lists.newArrayList();
                        list.addAll(Arrays.asList(fs.getFileBlockLocations(tmpFile1, 0L, 1024L)));
                        list.addAll(Arrays.asList(fs.getFileBlockLocations(tmpFile2, 0L, 1024L)));
                        int totalRepl = 0;
                        for (BlockLocation loc : list) {
                            totalRepl += loc.getHosts().length;
                        }
                        if (totalRepl == 4) {
                            return true;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return false;
                }
            }, (int)500, (int)30000);
            Object[] blockLocs1 = fs.getFileBlockLocations(tmpFile1, 0L, 1024L);
            Object[] blockLocs2 = fs.getFileBlockLocations(tmpFile2, 0L, 1024L);
            BlockLocation[] blockLocs = (BlockLocation[])ArrayUtils.addAll((Object[])blockLocs1, (Object[])blockLocs2);
            BlockStorageLocation[] locs = fs.getFileBlockStorageLocations(Arrays.asList(blockLocs));
            int counter = 0;
            for (BlockStorageLocation l : locs) {
                for (i = 0; i < l.getVolumeIds().length; ++i) {
                    id = l.getVolumeIds()[i];
                    name = l.getNames()[i];
                    if (id == null) continue;
                    System.out.println("Datanode " + name + " has block " + counter + " on volume id " + id.toString());
                }
                ++counter;
            }
            Assert.assertEquals((String)"Expected two HdfsBlockLocations for two 1-block files", (long)2L, (long)locs.length);
            for (BlockStorageLocation l : locs) {
                Assert.assertEquals((String)"Expected two replicas for each block", (long)2L, (long)l.getVolumeIds().length);
                for (i = 0; i < l.getVolumeIds().length; ++i) {
                    id = l.getVolumeIds()[i];
                    name = l.getNames()[i];
                    Assert.assertTrue((String)("Expected block to be valid on datanode " + name), (id != null ? 1 : 0) != 0);
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testGetFileBlockStorageLocationsError() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.datanode.hdfs-blocks-metadata.enabled", true);
        conf.setInt("dfs.client.file-block-storage-locations.timeout.millis", 1500);
        conf.setInt("ipc.client.connect.max.retries", 0);
        MiniDFSCluster cluster = null;
        try {
            BlockStorageLocation[] locs;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            cluster.getDataNodes();
            final DistributedFileSystem fs = cluster.getFileSystem();
            final Path tmpFile1 = new Path("/errorfile1.dat");
            final Path tmpFile2 = new Path("/errorfile2.dat");
            DFSTestUtil.createFile((FileSystem)fs, tmpFile1, 1024L, (short)2, 0xDEADDEADL);
            DFSTestUtil.createFile((FileSystem)fs, tmpFile2, 1024L, (short)2, 0xDEADDEADL);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        ArrayList list = Lists.newArrayList();
                        list.addAll(Arrays.asList(fs.getFileBlockLocations(tmpFile1, 0L, 1024L)));
                        list.addAll(Arrays.asList(fs.getFileBlockLocations(tmpFile2, 0L, 1024L)));
                        int totalRepl = 0;
                        for (BlockLocation loc : list) {
                            totalRepl += loc.getHosts().length;
                        }
                        if (totalRepl == 4) {
                            return true;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return false;
                }
            }, (int)500, (int)30000);
            BlockLocation[] blockLocs1 = fs.getFileBlockLocations(tmpFile1, 0L, 1024L);
            BlockLocation[] blockLocs2 = fs.getFileBlockLocations(tmpFile2, 0L, 1024L);
            ArrayList allLocs = Lists.newArrayList();
            allLocs.addAll(Arrays.asList(blockLocs1));
            allLocs.addAll(Arrays.asList(blockLocs2));
            DataNodeFaultInjector injector = (DataNodeFaultInjector)Mockito.mock(DataNodeFaultInjector.class);
            ((DataNodeFaultInjector)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    Thread.sleep(3000L);
                    return null;
                }
            }).when((Object)injector)).getHdfsBlocksMetadata();
            DataNodeFaultInjector.set((DataNodeFaultInjector)injector);
            for (BlockStorageLocation loc : locs = fs.getFileBlockStorageLocations((List)allLocs)) {
                Assert.assertEquals((String)"Found more than 0 cached hosts although RPCs supposedly timed out", (long)0L, (long)loc.getCachedHosts().length);
            }
            DataNodeFaultInjector.set((DataNodeFaultInjector)new DataNodeFaultInjector());
            MiniDFSCluster.DataNodeProperties stoppedNode = cluster.stopDataNode(0);
            locs = fs.getFileBlockStorageLocations((List)allLocs);
            Assert.assertEquals((String)"Expected two HdfsBlockLocation for two 1-block files", (long)2L, (long)locs.length);
            for (BlockStorageLocation l : locs) {
                Assert.assertEquals((String)"Expected two replicas for each block", (long)2L, (long)l.getHosts().length);
                Assert.assertEquals((String)"Expected two VolumeIDs for each block", (long)2L, (long)l.getVolumeIds().length);
                Assert.assertTrue((String)"Expected one valid and one invalid volume", (boolean)(l.getVolumeIds()[0] == null ^ l.getVolumeIds()[1] == null));
            }
            cluster.restartDataNode(stoppedNode, true);
            cluster.waitActive();
            fs.delete(tmpFile2, true);
            HATestUtil.waitForNNToIssueDeletions(cluster.getNameNode());
            cluster.triggerHeartbeats();
            HATestUtil.waitForDNDeletions(cluster);
            locs = fs.getFileBlockStorageLocations((List)allLocs);
            Assert.assertEquals((String)"Expected two HdfsBlockLocations for two 1-block files", (long)2L, (long)locs.length);
            Assert.assertNotNull((Object)locs[0].getVolumeIds()[0]);
            Assert.assertNotNull((Object)locs[0].getVolumeIds()[1]);
            Assert.assertNull((Object)locs[1].getVolumeIds()[0]);
            Assert.assertNull((Object)locs[1].getVolumeIds()[1]);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateWithCustomChecksum() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        Path testBasePath = new Path("/test/csum");
        Path path1 = new Path(testBasePath, "file_wtih_crc1");
        Path path2 = new Path(testBasePath, "file_with_crc2");
        Options.ChecksumOpt opt1 = new Options.ChecksumOpt(DataChecksum.Type.CRC32C, 512);
        Options.ChecksumOpt opt2 = new Options.ChecksumOpt(DataChecksum.Type.CRC32, 512);
        FsPermission perm = FsPermission.getDefault().applyUMask(FsPermission.getUMask((Configuration)conf));
        EnumSet<CreateFlag> flags = EnumSet.of(CreateFlag.OVERWRITE, CreateFlag.CREATE);
        short repl = 1;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(testBasePath);
            FSDataOutputStream out1 = dfs.create(path1, perm, flags, 4096, repl, 131072L, null, opt1);
            FSDataOutputStream out2 = dfs.create(path2, perm, flags, 4096, repl, 131072L, null, opt2);
            for (int i = 0; i < 1024; ++i) {
                out1.write(i);
                out2.write(i);
            }
            out1.close();
            out2.close();
            MD5MD5CRC32FileChecksum sum1 = (MD5MD5CRC32FileChecksum)dfs.getFileChecksum(path1);
            MD5MD5CRC32FileChecksum sum2 = (MD5MD5CRC32FileChecksum)dfs.getFileChecksum(path2);
            Assert.assertFalse((boolean)sum1.equals((Object)sum2));
            Assert.assertEquals((Object)DataChecksum.Type.CRC32C, (Object)sum1.getCrcType());
            Assert.assertEquals((Object)DataChecksum.Type.CRC32, (Object)sum2.getCrcType());
        }
        finally {
            if (cluster != null) {
                cluster.getFileSystem().delete(testBasePath, true);
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFileCloseStatus() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path file = new Path("/simpleFlush.dat");
            FSDataOutputStream output = fs.create(file);
            output.writeBytes("Some test data");
            output.flush();
            Assert.assertFalse((String)"File status should be open", (boolean)fs.isFileClosed(file));
            output.close();
            Assert.assertTrue((String)"File status should be closed", (boolean)fs.isFileClosed(file));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testListFiles() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path relative = new Path("relative");
            fs.create(new Path(relative, "foo")).close();
            ArrayList<Object> retVal = new ArrayList<Object>();
            RemoteIterator iter = fs.listFiles(relative, true);
            while (iter.hasNext()) {
                retVal.add(iter.next());
            }
            System.out.println("retVal = " + retVal);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDFSClientPeerReadTimeout() throws IOException {
        int timeout = 1000;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.socket-timeout", 1000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            ServerSocket socket = new ServerSocket(0);
            Peer peer = dfs.getClient().newConnectedPeer((InetSocketAddress)socket.getLocalSocketAddress(), null, null);
            long start = Time.now();
            try {
                peer.getInputStream().read();
                Assert.fail((String)"read should timeout");
            }
            catch (SocketTimeoutException ste) {
                long delta = Time.now() - start;
                if ((double)delta < 900.0) {
                    throw new IOException("read timedout too soon in " + delta + " ms.", ste);
                }
                if ((double)delta > 1100.0) {
                    throw new IOException("read timedout too late in " + delta + " ms.", ste);
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testGetServerDefaults() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            FsServerDefaults fsServerDefaults = dfs.getServerDefaults();
            Assert.assertNotNull((Object)fsServerDefaults);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDFSClientPeerWriteTimeout() throws IOException {
        int timeout = 1000;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.socket-timeout", 1000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            ServerSocket socket = new ServerSocket(0);
            Peer peer = dfs.getClient().newConnectedPeer((InetSocketAddress)socket.getLocalSocketAddress(), null, null);
            long start = Time.now();
            try {
                byte[] buf = new byte[0xA00000];
                peer.getOutputStream().write(buf);
                long delta = Time.now() - start;
                Assert.fail((String)("write finish in " + delta + " msbut should timedout"));
            }
            catch (SocketTimeoutException ste) {
                long delta = Time.now() - start;
                if ((double)delta < 900.0) {
                    throw new IOException("write timedout too soon in " + delta + " ms.", ste);
                }
                if ((double)delta > 1200.0) {
                    throw new IOException("write timedout too late in " + delta + " ms.", ste);
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testTotalDfsUsed() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSDataOutputStream File1 = fs.create(new Path("/File1"));
            File1.write("hi".getBytes());
            File1.close();
            FSDataOutputStream File2 = fs.create(new Path("/Folder1/File2"));
            File2.write("hi".getBytes());
            File2.close();
            Assert.assertEquals((long)2L, (long)fs.getUsed(new Path("/Folder1")));
            Assert.assertEquals((long)4L, (long)fs.getUsed());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
                cluster = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSCloseFilesBeingWritten() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            fileSys.create(new Path("/test/dfsclose/file-0"));
            fileSys.delete(new Path("/test/dfsclose/file-0"), true);
            DFSClient dfsClient = fileSys.getClient();
            DFSClient newDfsClient = new DFSClient(cluster.getFileSystem(0).getUri(), (Configuration)conf);
            LeaseRenewer leaseRenewer = newDfsClient.getLeaseRenewer();
            dfsClient.closeAllFilesBeingWritten(false);
            leaseRenewer.closeClient(newDfsClient);
            Assert.assertEquals((Object)true, (Object)leaseRenewer.isEmpty());
            Assert.assertEquals((Object)true, (Object)dfsClient.isFilesBeingWrittenEmpty());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void testBuilderSetters(DistributedFileSystem fs) {
        Path testFilePath = new Path("/testBuilderSetters");
        DistributedFileSystem.HdfsDataOutputStreamBuilder builder = fs.createFile(testFilePath);
        ((DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem.HdfsDataOutputStreamBuilder)builder.append()).overwrite(false)).newBlock().lazyPersist().noLocalWrite();
        EnumSet flags = builder.getFlags();
        Assert.assertTrue((boolean)flags.contains(CreateFlag.APPEND));
        Assert.assertTrue((boolean)flags.contains(CreateFlag.CREATE));
        Assert.assertTrue((boolean)flags.contains(CreateFlag.NEW_BLOCK));
        Assert.assertTrue((boolean)flags.contains(CreateFlag.NO_LOCAL_WRITE));
        Assert.assertFalse((boolean)flags.contains(CreateFlag.OVERWRITE));
        Assert.assertFalse((boolean)flags.contains(CreateFlag.SYNC_BLOCK));
    }

    @Test
    public void testHdfsDataOutputStreamBuilderSetParameters() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            this.testBuilderSetters(fs);
        }
    }

    @Test
    public void testDFSDataOutputStreamBuilderForCreation() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        String testFile = "/testDFSDataOutputStreamBuilder";
        Path testFilePath = new Path(testFile);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            Throwable throwable;
            FSDataOutputStream out4;
            DistributedFileSystem fs = cluster.getFileSystem();
            DistributedFileSystem.HdfsDataOutputStreamBuilder builder = (DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem.HdfsDataOutputStreamBuilder)fs.createFile(testFilePath).blockSize(4096L)).replication((short)1);
            Assert.assertFalse((boolean)fs.exists(testFilePath));
            try (FSDataOutputStream out2 = fs.createFile(testFilePath).build();){
                LOG.info("Test create an empty file");
            }
            String content = "This is a test!";
            try (FSDataOutputStream out1 = ((DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem.HdfsDataOutputStreamBuilder)fs.createFile(testFilePath).bufferSize(4096)).replication((short)1)).blockSize(4096L)).build();){
                byte[] contentOrigin = content.getBytes("UTF8");
                out1.write(contentOrigin);
            }
            ContractTestUtils.verifyFileContents((FileSystem)fs, (Path)testFilePath, (byte[])content.getBytes());
            try {
                var10_15 = null;
                try (FSDataOutputStream out3 = ((DistributedFileSystem.HdfsDataOutputStreamBuilder)fs.createFile(testFilePath).overwrite(false)).build();){
                    Assert.fail((String)"it should fail to overwrite an existing file");
                }
                catch (Throwable throwable2) {
                    var10_15 = throwable2;
                    throw throwable2;
                }
            }
            catch (FileAlreadyExistsException out3) {
                // empty catch block
            }
            Path nonParentFile = new Path("/parent/test");
            try {
                out4 = fs.createFile(nonParentFile).build();
                throwable = null;
                try {
                    Assert.fail((String)"parent directory not exist");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (out4 != null) {
                        if (throwable != null) {
                            try {
                                out4.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            out4.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException out4) {
                // empty catch block
            }
            Assert.assertFalse((String)"parent directory should not be created", (boolean)fs.exists(new Path("/parent")));
            out4 = ((DistributedFileSystem.HdfsDataOutputStreamBuilder)fs.createFile(nonParentFile).recursive()).build();
            throwable = null;
            try {
                out4.write(1);
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (out4 != null) {
                    if (throwable != null) {
                        try {
                            out4.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        out4.close();
                    }
                }
            }
            Assert.assertTrue((String)"parent directory has not been created", (boolean)fs.exists(new Path("/parent")));
        }
    }

    @Test
    public void testDFSDataOutputStreamBuilderForAppend() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        String testFile = "/testDFSDataOutputStreamBuilderForAppend";
        Path path = new Path(testFile);
        Random random = new Random();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            Throwable throwable;
            FSDataOutputStream out;
            DistributedFileSystem fs = cluster.getFileSystem();
            byte[] buf = new byte[16];
            random.nextBytes(buf);
            try {
                out = fs.appendFile(path).build();
                throwable = null;
                try {
                    out.write(buf);
                    Assert.fail((String)"should fail on appending to non-existent file");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains((String)"non-existent", (Throwable)e);
            }
            random.nextBytes(buf);
            out = fs.createFile(path).build();
            throwable = null;
            try {
                out.write(buf);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
            random.nextBytes(buf);
            out = fs.appendFile(path).build();
            throwable = null;
            try {
                out.write(buf);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
            FileStatus status = fs.getFileStatus(path);
            Assert.assertEquals((long)32L, (long)status.getLen());
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.ALL);
    }

    private static class MyDistributedFileSystem
    extends DistributedFileSystem {
        MyDistributedFileSystem() {
            this.dfs = (DFSClient)Mockito.mock(DFSClient.class);
        }

        public boolean exists(Path p) {
            return true;
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            return this.dfs.delete(f.toUri().getPath(), recursive);
        }
    }
}

