/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.mount;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3Utils;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.mount.MountEntry;
import org.apache.hadoop.mount.MountInterface;
import org.apache.hadoop.mount.MountResponse;
import org.apache.hadoop.nfs.AccessPrivilege;
import org.apache.hadoop.nfs.NfsExports;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcProgramMountd
extends RpcProgram
implements MountInterface {
    private static final Logger LOG = LoggerFactory.getLogger(RpcProgramMountd.class);
    public static final int PROGRAM = 100005;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    private final List<MountEntry> mounts;
    private final HashMap<String, URI> exports;
    private final NfsConfiguration config;
    private final NfsExports hostsMatcher;

    public RpcProgramMountd(NfsConfiguration config, DatagramSocket registrationSocket, boolean allowInsecurePorts) throws IOException {
        super("mountd", "localhost", config.getInt("nfs.mountd.port", 4242), 100005, 1, 3, registrationSocket, allowInsecurePorts, config.getInt("nfs.udp.client.portmap.timeout.millis", 500));
        this.config = config;
        this.exports = new HashMap();
        this.addExports();
        this.hostsMatcher = NfsExports.getInstance((Configuration)config);
        this.mounts = Collections.synchronizedList(new ArrayList());
        UserGroupInformation.setConfiguration((Configuration)config);
        SecurityUtil.login((Configuration)config, (String)"nfs.keytab.file", (String)"nfs.kerberos.principal");
    }

    private void addExports() throws IOException {
        String[] exportsPath;
        FileSystem fs = FileSystem.get((Configuration)this.config);
        for (String exportPath : exportsPath = this.config.getStrings("nfs.export.point", new String[]{"/"})) {
            URI exportURI = Nfs3Utils.getResolvedURI(fs, exportPath);
            LOG.info("FS:" + fs.getScheme() + " adding export Path:" + exportPath + " with URI: " + exportURI.toString());
            this.exports.put(exportPath, exportURI);
        }
    }

    public XDR nullOp(XDR out, int xid, InetAddress client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MOUNT NULLOP :  client: " + client);
        }
        return RpcAcceptedReply.getAcceptInstance((int)xid, (Verifier)new VerifierNone()).write(out);
    }

    public XDR mnt(XDR xdr, XDR out, int xid, InetAddress client) {
        URI exportURI;
        if (this.hostsMatcher == null) {
            return MountResponse.writeMNTResponse((int)13, (XDR)out, (int)xid, null);
        }
        AccessPrivilege accessPrivilege = this.hostsMatcher.getAccessPrivilege(client);
        if (accessPrivilege == AccessPrivilege.NONE) {
            return MountResponse.writeMNTResponse((int)13, (XDR)out, (int)xid, null);
        }
        String path = xdr.readString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("MOUNT MNT path: " + path + " client: " + client);
        }
        String host = client.getHostName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got host: " + host + " path: " + path);
        }
        if ((exportURI = this.exports.get(path)) == null) {
            LOG.info("Path " + path + " is not shared.");
            MountResponse.writeMNTResponse((int)2, (XDR)out, (int)xid, null);
            return out;
        }
        DFSClient dfsClient = null;
        try {
            dfsClient = new DFSClient(exportURI, (Configuration)this.config);
        }
        catch (Exception e) {
            LOG.error("Can't get handle for export:" + path, (Throwable)e);
            MountResponse.writeMNTResponse((int)2, (XDR)out, (int)xid, null);
            return out;
        }
        FileHandle handle = null;
        try {
            HdfsFileStatus exFileStatus = dfsClient.getFileInfo(exportURI.getPath());
            handle = new FileHandle(exFileStatus.getFileId(), Nfs3Utils.getNamenodeId((Configuration)this.config, exportURI));
        }
        catch (IOException e) {
            LOG.error("Can't get handle for export:" + path, (Throwable)e);
            MountResponse.writeMNTResponse((int)2, (XDR)out, (int)xid, null);
            return out;
        }
        assert (handle != null);
        LOG.info("Giving handle (fileHandle:" + handle.dumpFileHandle() + " file URI: " + exportURI + ") to client for export " + path);
        this.mounts.add(new MountEntry(host, path));
        MountResponse.writeMNTResponse((int)0, (XDR)out, (int)xid, (byte[])handle.getContent());
        return out;
    }

    public XDR dump(XDR out, int xid, InetAddress client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MOUNT NULLOP :  client: " + client);
        }
        ArrayList<MountEntry> copy = new ArrayList<MountEntry>(this.mounts);
        MountResponse.writeMountList((XDR)out, (int)xid, copy);
        return out;
    }

    public XDR umnt(XDR xdr, XDR out, int xid, InetAddress client) {
        String path = xdr.readString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("MOUNT UMNT path: " + path + " client: " + client);
        }
        String host = client.getHostName();
        this.mounts.remove(new MountEntry(host, path));
        RpcAcceptedReply.getAcceptInstance((int)xid, (Verifier)new VerifierNone()).write(out);
        return out;
    }

    public XDR umntall(XDR out, int xid, InetAddress client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MOUNT UMNTALL :  client: " + client);
        }
        this.mounts.clear();
        return RpcAcceptedReply.getAcceptInstance((int)xid, (Verifier)new VerifierNone()).write(out);
    }

    public void handleInternal(ChannelHandlerContext ctx, RpcInfo info) {
        RpcCall rpcCall = (RpcCall)info.header();
        MountInterface.MNTPROC mntproc = MountInterface.MNTPROC.fromValue((int)rpcCall.getProcedure());
        int xid = rpcCall.getXid();
        byte[] data = new byte[info.data().readableBytes()];
        info.data().readBytes(data);
        XDR xdr = new XDR(data);
        XDR out = new XDR();
        InetAddress client = ((InetSocketAddress)info.remoteAddress()).getAddress();
        if (mntproc == MountInterface.MNTPROC.NULL) {
            out = this.nullOp(out, xid, client);
        } else if (mntproc == MountInterface.MNTPROC.MNT) {
            out = !this.doPortMonitoring(info.remoteAddress()) ? MountResponse.writeMNTResponse((int)13, (XDR)out, (int)xid, null) : this.mnt(xdr, out, xid, client);
        } else if (mntproc == MountInterface.MNTPROC.DUMP) {
            out = this.dump(out, xid, client);
        } else if (mntproc == MountInterface.MNTPROC.UMNT) {
            out = this.umnt(xdr, out, xid, client);
        } else if (mntproc == MountInterface.MNTPROC.UMNTALL) {
            this.umntall(out, xid, client);
        } else if (mntproc == MountInterface.MNTPROC.EXPORT) {
            ArrayList<NfsExports> hostsMatchers = new ArrayList<NfsExports>();
            if (this.hostsMatcher != null) {
                List<String> exportsList = this.getExports();
                for (int i = 0; i < exportsList.size(); ++i) {
                    hostsMatchers.add(this.hostsMatcher);
                }
                out = MountResponse.writeExportList((XDR)out, (int)xid, exportsList, hostsMatchers);
            } else {
                RpcAcceptedReply.getInstance((int)xid, (RpcAcceptedReply.AcceptState)RpcAcceptedReply.AcceptState.PROC_UNAVAIL, (Verifier)new VerifierNone()).write(out);
            }
        } else {
            RpcAcceptedReply.getInstance((int)xid, (RpcAcceptedReply.AcceptState)RpcAcceptedReply.AcceptState.PROC_UNAVAIL, (Verifier)new VerifierNone()).write(out);
        }
        ChannelBuffer buf = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
        RpcResponse rsp = new RpcResponse(buf, info.remoteAddress());
        RpcUtil.sendRpcResponse((ChannelHandlerContext)ctx, (RpcResponse)rsp);
    }

    protected boolean isIdempotent(RpcCall call) {
        return false;
    }

    @VisibleForTesting
    public List<String> getExports() {
        return new ArrayList<String>(this.exports.keySet());
    }
}

