/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import com.squareup.okhttp.mockwebserver.MockResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlMockWebServer;
import org.apache.hadoop.fs.adl.TestADLResponseData;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestListStatus
extends AdlMockWebServer {
    private static final Logger LOG = LoggerFactory.getLogger(TestListStatus.class);

    @Test
    public void listStatusReturnsAsExpected() throws IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getListFileStatusJSONResponse(10)));
        long startTime = Time.monotonicNow();
        FileStatus[] ls = this.getMockAdlFileSystem().listStatus(new Path("/test1/test2"));
        long endTime = Time.monotonicNow();
        LOG.debug("Time : " + (endTime - startTime));
        Assert.assertEquals((long)10L, (long)ls.length);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getListFileStatusJSONResponse(200)));
        startTime = Time.monotonicNow();
        ls = this.getMockAdlFileSystem().listStatus(new Path("/test1/test2"));
        endTime = Time.monotonicNow();
        LOG.debug("Time : " + (endTime - startTime));
        Assert.assertEquals((long)200L, (long)ls.length);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getListFileStatusJSONResponse(2048)));
        startTime = Time.monotonicNow();
        ls = this.getMockAdlFileSystem().listStatus(new Path("/test1/test2"));
        endTime = Time.monotonicNow();
        LOG.debug("Time : " + (endTime - startTime));
        Assert.assertEquals((long)2048L, (long)ls.length);
    }

    @Test
    public void listStatusOnFailure() throws IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getErrorIllegalArgumentExceptionJSONResponse()));
        FileStatus[] ls = null;
        long startTime = Time.monotonicNow();
        try {
            ls = this.getMockAdlFileSystem().listStatus(new Path("/test1/test2"));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid"));
        }
        long endTime = Time.monotonicNow();
        LOG.debug("Time : " + (endTime - startTime));
        for (int i = 0; i < 10; ++i) {
            this.getMockServer().enqueue(new MockResponse().setResponseCode(500).setBody(TestADLResponseData.getErrorInternalServerExceptionJSONResponse()));
        }
        startTime = Time.monotonicNow();
        try {
            ls = this.getMockAdlFileSystem().listStatus(new Path("/test1/test2"));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Internal Server Error"));
        }
        endTime = Time.monotonicNow();
        LOG.debug("Time : " + (endTime - startTime));
    }

    @Test
    public void listStatusAclBit() throws URISyntaxException, IOException {
        int i;
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getListFileStatusJSONResponse(true)));
        FileStatus[] ls = null;
        long startTime = Time.monotonicNow();
        ls = this.getMockAdlFileSystem().listStatus(new Path("/test1/test2"));
        long endTime = Time.monotonicNow();
        LOG.debug("Time : " + (endTime - startTime));
        for (i = 0; i < ls.length; ++i) {
            Assert.assertTrue((boolean)ls[i].isDirectory());
            Assert.assertEquals((Object)true, (Object)ls[i].getPermission().getAclBit());
        }
        ls = null;
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getListFileStatusJSONResponse(false)));
        startTime = Time.monotonicNow();
        ls = this.getMockAdlFileSystem().listStatus(new Path("/test1/test2"));
        endTime = Time.monotonicNow();
        LOG.debug("Time : " + (endTime - startTime));
        for (i = 0; i < ls.length; ++i) {
            Assert.assertTrue((boolean)ls[i].isDirectory());
            Assert.assertEquals((Object)false, (Object)ls[i].getPermission().getAclBit());
        }
    }
}

