/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import com.squareup.okhttp.mockwebserver.MockResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlMockWebServer;
import org.apache.hadoop.fs.adl.TestADLResponseData;
import org.apache.hadoop.fs.adl.TestableAdlFileSystem;
import org.apache.hadoop.fs.adl.TokenProviderType;
import org.apache.hadoop.fs.adl.common.CustomMockTokenProvider;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestCustomTokenProvider
extends AdlMockWebServer {
    private static final long TEN_MINUTES_IN_MILIS = 600000L;
    private int backendCallCount;
    private int expectedCallbackToAccessToken;
    private TestableAdlFileSystem[] fileSystems;
    private Class typeOfTokenProviderClass;
    private long expiryFromNow;
    private int fsObjectCount;

    public TestCustomTokenProvider(Class typeOfTokenProviderClass, long expiryFromNow, int fsObjectCount, int backendCallCount, int expectedCallbackToAccessToken) throws IllegalAccessException, InstantiationException, URISyntaxException, IOException {
        this.typeOfTokenProviderClass = typeOfTokenProviderClass;
        this.expiryFromNow = expiryFromNow;
        this.fsObjectCount = fsObjectCount;
        this.backendCallCount = backendCallCount;
        this.expectedCallbackToAccessToken = expectedCallbackToAccessToken;
    }

    @Parameterized.Parameters(name="{index}")
    public static Collection testDataForTokenProvider() {
        return Arrays.asList({CustomMockTokenProvider.class, 0, 1, 1, 1}, {CustomMockTokenProvider.class, 600000L, 1, 1, 1}, {CustomMockTokenProvider.class, 600000L, 2, 1, 2}, {CustomMockTokenProvider.class, 600000L, 10, 10, 10});
    }

    public void init() throws IOException, URISyntaxException {
        Configuration configuration = new Configuration();
        configuration.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.Custom);
        configuration.set("fs.adl.oauth2.access.token.provider", this.typeOfTokenProviderClass.getName());
        this.fileSystems = new TestableAdlFileSystem[this.fsObjectCount];
        URI uri = new URI("adl://localhost:" + this.getPort());
        for (int i = 0; i < this.fsObjectCount; ++i) {
            this.fileSystems[i] = new TestableAdlFileSystem();
            this.fileSystems[i].initialize(uri, configuration);
            ((CustomMockTokenProvider)this.fileSystems[i].getAzureTokenProvider()).setExpiryTimeInMillisAfter(this.expiryFromNow);
        }
    }

    @Test
    public void testCustomTokenManagement() throws IOException, URISyntaxException {
        int accessTokenCallbackDuringExec = 0;
        this.init();
        for (TestableAdlFileSystem tfs : this.fileSystems) {
            for (int i = 0; i < this.backendCallCount; ++i) {
                this.getMockServer().enqueue(new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getGetFileStatusJSONResponse()));
                FileStatus fileStatus = tfs.getFileStatus(new Path("/test1/test2"));
                Assert.assertTrue((boolean)fileStatus.isFile());
                Assert.assertEquals((Object)("adl://" + this.getMockServer().getHostName() + ":" + this.getMockServer().getPort() + "/test1/test2"), (Object)fileStatus.getPath().toString());
                Assert.assertEquals((long)0x400000L, (long)fileStatus.getLen());
                Assert.assertEquals((long)0x10000000L, (long)fileStatus.getBlockSize());
                Assert.assertEquals((long)1L, (long)fileStatus.getReplication());
                Assert.assertEquals((Object)new FsPermission("777"), (Object)fileStatus.getPermission());
                Assert.assertEquals((Object)"NotSupportYet", (Object)fileStatus.getOwner());
                Assert.assertEquals((Object)"NotSupportYet", (Object)fileStatus.getGroup());
            }
            accessTokenCallbackDuringExec += ((CustomMockTokenProvider)tfs.getAzureTokenProvider()).getAccessTokenRequestCount();
        }
        Assert.assertEquals((long)this.expectedCallbackToAccessToken, (long)accessTokenCallbackDuringExec);
    }
}

