/*
 * Decompiled with CFR 0.152.
 */
package com.bc.wps.spi.mockproviders;

import com.bc.wps.api.WpsRequestContext;
import com.bc.wps.api.WpsServiceInstance;
import com.bc.wps.api.exceptions.WpsServiceException;
import com.bc.wps.api.schema.AddressType;
import com.bc.wps.api.schema.Capabilities;
import com.bc.wps.api.schema.ComplexDataCombinationType;
import com.bc.wps.api.schema.ComplexDataCombinationsType;
import com.bc.wps.api.schema.ComplexDataDescriptionType;
import com.bc.wps.api.schema.ContactType;
import com.bc.wps.api.schema.DCP;
import com.bc.wps.api.schema.DomainMetadataType;
import com.bc.wps.api.schema.Execute;
import com.bc.wps.api.schema.ExecuteResponse;
import com.bc.wps.api.schema.HTTP;
import com.bc.wps.api.schema.InputDescriptionType;
import com.bc.wps.api.schema.Languages;
import com.bc.wps.api.schema.LanguagesType;
import com.bc.wps.api.schema.LiteralOutputType;
import com.bc.wps.api.schema.Operation;
import com.bc.wps.api.schema.OperationsMetadata;
import com.bc.wps.api.schema.OutputDescriptionType;
import com.bc.wps.api.schema.ProcessBriefType;
import com.bc.wps.api.schema.ProcessDescriptionType;
import com.bc.wps.api.schema.ProcessOfferings;
import com.bc.wps.api.schema.ProcessStartedType;
import com.bc.wps.api.schema.RequestMethodType;
import com.bc.wps.api.schema.ResponsiblePartySubsetType;
import com.bc.wps.api.schema.ServiceIdentification;
import com.bc.wps.api.schema.ServiceProvider;
import com.bc.wps.api.schema.StatusType;
import com.bc.wps.api.schema.SupportedComplexDataInputType;
import com.bc.wps.api.schema.TelephoneType;
import com.bc.wps.api.schema.ValueType;
import com.bc.wps.api.utils.CapabilitiesBuilder;
import com.bc.wps.api.utils.InputDescriptionTypeBuilder;
import com.bc.wps.api.utils.WpsTypeConverter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class MockInstanceTwo
implements WpsServiceInstance {
    public Capabilities getCapabilities(WpsRequestContext context) throws WpsServiceException {
        return this.getMockCapabilities();
    }

    public List<ProcessDescriptionType> describeProcess(WpsRequestContext context, String processId) throws WpsServiceException {
        ArrayList<ProcessDescriptionType> processes = new ArrayList<ProcessDescriptionType>();
        processes.add(this.getMockProcess("Process1"));
        processes.add(this.getMockProcess("Process2"));
        return processes;
    }

    public ExecuteResponse doExecute(WpsRequestContext context, Execute executeRequest) throws WpsServiceException {
        String processId = executeRequest.getIdentifier().getValue();
        return this.getMockAcceptedResponse(context, processId);
    }

    public ExecuteResponse getStatus(WpsRequestContext context, String jobId) throws WpsServiceException {
        return this.getMockStartedResponse();
    }

    public void dispose() {
    }

    private ExecuteResponse getMockStartedResponse() throws WpsServiceException {
        ExecuteResponse startedResponse = new ExecuteResponse();
        StatusType startedStatus = new StatusType();
        ProcessStartedType processStarted = new ProcessStartedType();
        processStarted.setValue("RUNNING");
        processStarted.setPercentCompleted(Integer.valueOf(65));
        startedStatus.setProcessStarted(processStarted);
        startedStatus.setCreationTime(this.getXmlGregorianCalendar());
        startedResponse.setStatus(startedStatus);
        startedResponse.setServiceInstance("http://companyUrl/serviceName?");
        startedResponse.setService("WPS");
        startedResponse.setVersion("1.0.0");
        startedResponse.setLang("en");
        return startedResponse;
    }

    private ExecuteResponse getMockAcceptedResponse(WpsRequestContext context, String processId) throws WpsServiceException {
        ExecuteResponse mockAcceptedResponse = new ExecuteResponse();
        ProcessBriefType process = new ProcessBriefType();
        process.setProcessVersion("1.0");
        process.setIdentifier(WpsTypeConverter.str2CodeType((String)"process1"));
        process.setTitle(WpsTypeConverter.str2LanguageStringType((String)"Process 1"));
        process.setAbstract(WpsTypeConverter.str2LanguageStringType((String)"Process 1 description"));
        mockAcceptedResponse.setProcess(process);
        StatusType acceptedStatus = new StatusType();
        acceptedStatus.setProcessAccepted("The request has been accepted. The job is being handled by processor '" + processId + "'.");
        acceptedStatus.setCreationTime(this.getXmlGregorianCalendar());
        mockAcceptedResponse.setStatus(acceptedStatus);
        mockAcceptedResponse.setStatusLocation(context.getServerContext().getHostAddress() + "/" + context.getUserName());
        mockAcceptedResponse.setServiceInstance("http://companyUrl/serviceName?");
        mockAcceptedResponse.setService("WPS");
        mockAcceptedResponse.setVersion("1.0.0");
        mockAcceptedResponse.setLang("en");
        return mockAcceptedResponse;
    }

    private XMLGregorianCalendar getXmlGregorianCalendar() throws WpsServiceException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
        }
        catch (DatatypeConfigurationException exception) {
            throw new WpsServiceException("Unable to create new Gregorian Calendar.", (Throwable)exception);
        }
    }

    private Capabilities getMockCapabilities() {
        ServiceIdentification mockServiceIdentification = this.getMockServiceIdentification();
        ServiceProvider mockServiceProvider = this.getMockServiceProvider();
        OperationsMetadata mockOperationsMetadata = this.getMockOperationsMetadata();
        ProcessOfferings mockProcessOfferings = this.getMockProcessOfferings();
        Languages mockLanguages = this.getMockLanguages();
        return CapabilitiesBuilder.create().withServiceIdentification(mockServiceIdentification).withServiceProvider(mockServiceProvider).withOperationsMetadata(mockOperationsMetadata).withProcessOfferings(mockProcessOfferings).withLanguages(mockLanguages).build();
    }

    private Languages getMockLanguages() {
        Languages mockLanguages = new Languages();
        Languages.Default defaultLanguage = new Languages.Default();
        defaultLanguage.setLanguage("EN");
        mockLanguages.setDefault(defaultLanguage);
        LanguagesType supportedLanguages = new LanguagesType();
        supportedLanguages.getLanguage().add("EN");
        supportedLanguages.getLanguage().add("DE");
        mockLanguages.setSupported(supportedLanguages);
        return mockLanguages;
    }

    private OperationsMetadata getMockOperationsMetadata() {
        OperationsMetadata mockOperationsMetadata = new OperationsMetadata();
        Operation operation1 = new Operation();
        operation1.setName("GetCapabilities");
        DCP getCapabilitiesDcp = new DCP();
        HTTP getCapabilitiesHttp = new HTTP();
        RequestMethodType getCapabilitiesRequestMethod = new RequestMethodType();
        getCapabilitiesRequestMethod.setHref("http://companyUrl/serviceName?");
        getCapabilitiesHttp.setGet(getCapabilitiesRequestMethod);
        getCapabilitiesDcp.setHTTP(getCapabilitiesHttp);
        operation1.getDCP().add(getCapabilitiesDcp);
        mockOperationsMetadata.getOperation().add(operation1);
        Operation operation2 = new Operation();
        operation2.setName("DescribeProcess");
        DCP describeProcessDcp = new DCP();
        HTTP describeProcessHttp = new HTTP();
        RequestMethodType describeProcessRequestMethod = new RequestMethodType();
        describeProcessRequestMethod.setHref("http://companyUrl/serviceName?");
        describeProcessHttp.setGet(describeProcessRequestMethod);
        describeProcessDcp.setHTTP(describeProcessHttp);
        operation2.getDCP().add(describeProcessDcp);
        mockOperationsMetadata.getOperation().add(operation2);
        Operation operation3 = new Operation();
        operation3.setName("Execute");
        DCP executeDcp = new DCP();
        HTTP executeHttp = new HTTP();
        RequestMethodType executeRequestMethod = new RequestMethodType();
        executeRequestMethod.setHref("http://companyUrl/serviceName");
        executeHttp.setPost(executeRequestMethod);
        executeDcp.setHTTP(executeHttp);
        operation3.getDCP().add(executeDcp);
        mockOperationsMetadata.getOperation().add(operation3);
        Operation operation4 = new Operation();
        operation4.setName("GetStatus");
        DCP getStatusDcp = new DCP();
        HTTP getStatusHttp = new HTTP();
        RequestMethodType getStatusRequestMethod = new RequestMethodType();
        getStatusRequestMethod.setHref("http://companyUrl/serviceName?");
        getStatusHttp.setGet(getStatusRequestMethod);
        getStatusDcp.setHTTP(getStatusHttp);
        operation4.getDCP().add(getStatusDcp);
        mockOperationsMetadata.getOperation().add(operation4);
        return mockOperationsMetadata;
    }

    private ServiceProvider getMockServiceProvider() {
        ServiceProvider mockServiceProvider = new ServiceProvider();
        mockServiceProvider.setProviderName("Fantasy World");
        mockServiceProvider.setProviderSite(WpsTypeConverter.str2OnlineResourceType((String)"http://fantasy-world.com"));
        ResponsiblePartySubsetType mockServiceContact = new ResponsiblePartySubsetType();
        mockServiceContact.setIndividualName("John Doe");
        mockServiceContact.setPositionName("System Administrator");
        ContactType mockContactInfo = new ContactType();
        TelephoneType phoneInfo = new TelephoneType();
        phoneInfo.getVoice().add("+49 12345 6789");
        phoneInfo.getFacsimile().add("+49 98765 4321");
        mockContactInfo.setPhone(phoneInfo);
        AddressType mockAddress = new AddressType();
        mockAddress.getDeliveryPoint().add("Room 1, Building A, Fantasy Avenue");
        mockAddress.setCity("Fantasyville");
        mockAddress.setAdministrativeArea("FF");
        mockAddress.setPostalCode("1234");
        mockAddress.setCountry("Kingdom of Fantasy");
        mockAddress.getElectronicMailAddress().add("admin@fantasy-world.com");
        mockContactInfo.setAddress(mockAddress);
        mockServiceContact.setContactInfo(mockContactInfo);
        mockServiceProvider.setServiceContact(mockServiceContact);
        return mockServiceProvider;
    }

    private ServiceIdentification getMockServiceIdentification() {
        ServiceIdentification mockServiceIdentification = new ServiceIdentification();
        mockServiceIdentification.setTitle(WpsTypeConverter.str2LanguageStringType((String)"A mock WPS server"));
        mockServiceIdentification.setAbstract(WpsTypeConverter.str2LanguageStringType((String)"A mock WPS server to be used as a reference for any WPS implementations."));
        mockServiceIdentification.setServiceType(WpsTypeConverter.str2CodeType((String)"WPS"));
        mockServiceIdentification.getServiceTypeVersion().add("1.0.0");
        mockServiceIdentification.getServiceTypeVersion().add("2.0.0");
        mockServiceIdentification.setFees("gratis");
        return mockServiceIdentification;
    }

    private ProcessOfferings getMockProcessOfferings() {
        ProcessOfferings processOfferings = new ProcessOfferings();
        ProcessBriefType process = new ProcessBriefType();
        process.setIdentifier(WpsTypeConverter.str2CodeType((String)"process1"));
        process.setTitle(WpsTypeConverter.str2LanguageStringType((String)"Process 1"));
        process.setAbstract(WpsTypeConverter.str2LanguageStringType((String)"This is a mock process from mock provider 2"));
        process.setProcessVersion("0.1");
        processOfferings.getProcess().add(process);
        return processOfferings;
    }

    private ProcessDescriptionType getMockProcess(String processName) {
        ProcessDescriptionType process = new ProcessDescriptionType();
        process.setProcessVersion("1.0");
        process.setIdentifier(WpsTypeConverter.str2CodeType((String)processName));
        process.setTitle(WpsTypeConverter.str2LanguageStringType((String)processName));
        process.setAbstract(WpsTypeConverter.str2LanguageStringType((String)"Description"));
        ProcessDescriptionType.DataInputs dataInputs = new ProcessDescriptionType.DataInputs();
        ArrayList<ValueType> allowedValues = new ArrayList<ValueType>();
        ValueType valueType = new ValueType();
        valueType.setValue("allowedValue");
        allowedValues.add(valueType);
        allowedValues.add(valueType);
        InputDescriptionType input = InputDescriptionTypeBuilder.create().withIdentifier("input1").withTitle("input title").withAbstract("input description").withDataType("String").withDefaultValue("default").withAllowedValues(allowedValues).build();
        dataInputs.getInput().add(input);
        InputDescriptionType inputWithoutAllowedValues = InputDescriptionTypeBuilder.create().withIdentifier("input2").withTitle("input without allowed values").withAbstract("input without allowed values description").withDataType("String").build();
        dataInputs.getInput().add(inputWithoutAllowedValues);
        InputDescriptionType complexInput = this.getComplexInputTypeWithSchema("schema.xsd");
        dataInputs.getInput().add(complexInput);
        process.setDataInputs(dataInputs);
        ProcessDescriptionType.ProcessOutputs processOutputs = new ProcessDescriptionType.ProcessOutputs();
        OutputDescriptionType processOutput = new OutputDescriptionType();
        processOutput.setIdentifier(WpsTypeConverter.str2CodeType((String)"output1"));
        processOutput.setTitle(WpsTypeConverter.str2LanguageStringType((String)"Output 1"));
        processOutput.setAbstract(WpsTypeConverter.str2LanguageStringType((String)"This is output 1"));
        LiteralOutputType literalOutputType = new LiteralOutputType();
        DomainMetadataType outputDataType = this.getDomainMetadataType();
        literalOutputType.setDataType(outputDataType);
        processOutput.setLiteralOutput(literalOutputType);
        processOutputs.getOutput().add(processOutput);
        process.setProcessOutputs(processOutputs);
        return process;
    }

    private DomainMetadataType getDomainMetadataType() {
        DomainMetadataType dataType = new DomainMetadataType();
        dataType.setValue("data type");
        dataType.setReference("data type reference");
        return dataType;
    }

    private InputDescriptionType getComplexInputTypeWithSchema(String schemaUrl) {
        InputDescriptionType l3ParametersComplexType = new InputDescriptionType();
        l3ParametersComplexType.setMinOccurs(BigInteger.ZERO);
        l3ParametersComplexType.setMaxOccurs(BigInteger.ONE);
        l3ParametersComplexType.setIdentifier(WpsTypeConverter.str2CodeType((String)"complex.parameter"));
        l3ParametersComplexType.setTitle(WpsTypeConverter.str2LanguageStringType((String)"An example of complex parameter"));
        l3ParametersComplexType.setAbstract(WpsTypeConverter.str2LanguageStringType((String)"Description for the parameter"));
        SupportedComplexDataInputType l3Parameters = new SupportedComplexDataInputType();
        ComplexDataCombinationType complexDataCombinationType = new ComplexDataCombinationType();
        ComplexDataDescriptionType complexDataDescriptionType = new ComplexDataDescriptionType();
        complexDataDescriptionType.setMimeType("application/xml");
        complexDataDescriptionType.setSchema(schemaUrl);
        complexDataCombinationType.setFormat(complexDataDescriptionType);
        l3Parameters.setDefault(complexDataCombinationType);
        ComplexDataCombinationsType complexDataCombinationsType = new ComplexDataCombinationsType();
        complexDataCombinationsType.getFormat().add(complexDataDescriptionType);
        l3Parameters.setSupported(complexDataCombinationsType);
        l3ParametersComplexType.setComplexData(l3Parameters);
        return l3ParametersComplexType;
    }
}

