/*
 * Decompiled with CFR 0.152.
 */
package scala.testing;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.rmi.RemoteException;
import scala.Function1;
import scala.Iterator;
import scala.Predef$;
import scala.Product;
import scala.Product$class;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.StringBuilder;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.testing.SUnit$;
import scala.testing.SUnit$Assert$class;
import scala.testing.SUnit$TestResult$;
import scala.testing.SUnit$TestSuite$;

public final class SUnit {
    public static final int $tag() throws RemoteException {
        return SUnit$.MODULE$.$tag();
    }

    public static interface Test {
        public void run(TestResult var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Assert
    extends ScalaObject {
        public <A> void fail(String var1, A var2, A var3);

        public void fail(String var1);

        public void assertTrue(boolean var1);

        public void assertTrue(String var1, boolean var2);

        public void assertEq(Object var1, Object var2);

        public void assertEq(String var1, Object var2, Object var3);

        public void assertNull(Object var1);

        public void assertNull(String var1, Object var2);

        public void assertNotEq(Object var1, Object var2);

        public void assertNotEq(String var1, Object var2, Object var3);

        public void assertNotNull(Object var1);

        public void assertNotNull(String var1, Object var2);

        public void assertFalse(boolean var1);

        public void assertFalse(String var1, boolean var2);

        public <A> void assertEquals(A var1, A var2);

        public <A> void assertEquals(String var1, A var2, A var3);

        public <A> void assertSameElements(Seq<A> var1, Seq<A> var2);

        public boolean enableStackTrace();
    }

    public static abstract class TestCase
    implements Test,
    Assert,
    ScalaObject {
        private final String name;

        public TestCase(String name) {
            this.name = name;
            SUnit$Assert$class.$init$(this);
        }

        public String toString() {
            return this.name();
        }

        public void tearDown() {
        }

        public void setUp() {
        }

        public void run(TestResult r) {
            try {
                this.runTest();
            }
            catch (Throwable throwable) {
                r.addFailure(this, throwable);
            }
        }

        public abstract void runTest();

        public String name() {
            return this.name;
        }

        public int $tag() throws RemoteException {
            return ScalaObject$class.$tag(this);
        }

        public void fail(String x$1, Object x$2, Object x$3) {
            SUnit$Assert$class.fail(this, x$1, x$2, x$3);
        }

        public void fail(String x$1) {
            SUnit$Assert$class.fail(this, x$1);
        }

        public void assertTrue(boolean x$1) {
            SUnit$Assert$class.assertTrue(this, x$1);
        }

        public void assertTrue(String x$1, boolean x$2) {
            SUnit$Assert$class.assertTrue(this, x$1, x$2);
        }

        public void assertEq(Object x$1, Object x$2) {
            SUnit$Assert$class.assertEq(this, x$1, x$2);
        }

        public void assertEq(String x$1, Object x$2, Object x$3) {
            SUnit$Assert$class.assertEq(this, x$1, x$2, x$3);
        }

        public void assertNull(Object x$1) {
            SUnit$Assert$class.assertNull(this, x$1);
        }

        public void assertNull(String x$1, Object x$2) {
            SUnit$Assert$class.assertNull(this, x$1, x$2);
        }

        public void assertNotEq(Object x$1, Object x$2) {
            SUnit$Assert$class.assertNotEq(this, x$1, x$2);
        }

        public void assertNotEq(String x$1, Object x$2, Object x$3) {
            SUnit$Assert$class.assertNotEq(this, x$1, x$2, x$3);
        }

        public void assertNotNull(Object x$1) {
            SUnit$Assert$class.assertNotNull(this, x$1);
        }

        public void assertNotNull(String x$1, Object x$2) {
            SUnit$Assert$class.assertNotNull(this, x$1, x$2);
        }

        public void assertFalse(boolean x$1) {
            SUnit$Assert$class.assertFalse(this, x$1);
        }

        public void assertFalse(String x$1, boolean x$2) {
            SUnit$Assert$class.assertFalse(this, x$1, x$2);
        }

        public void assertEquals(Object x$1, Object x$2) {
            SUnit$Assert$class.assertEquals(this, x$1, x$2);
        }

        public void assertEquals(String x$1, Object x$2, Object x$3) {
            SUnit$Assert$class.assertEquals(this, x$1, x$2, x$3);
        }

        public void assertSameElements(Seq x$1, Seq x$2) {
            SUnit$Assert$class.assertSameElements(this, x$1, x$2);
        }

        public boolean enableStackTrace() {
            return SUnit$Assert$class.enableStackTrace(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestSuite
    implements Test,
    ScalaObject {
        private final ArrayBuffer buf = new ArrayBuffer();

        public TestSuite(Seq<Test> tests) {
            this.buf().$plus$plus$eq(tests);
        }

        @Override
        public void run(TestResult r$1) {
            this.buf().foreach((Function1<Test, Object>)new TestSuite$$anonfun$run$1(this, r$1));
        }

        public void addTest(Test t) {
            this.buf().$plus$eq(t);
        }

        public ArrayBuffer<Test> buf() {
            return this.buf;
        }

        public TestSuite(Seq<String> names, Function1<String, Test> constr) {
            this(names.map(constr));
        }

        @Override
        public int $tag() throws RemoteException {
            return ScalaObject$class.$tag(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestResult
    implements ScalaObject {
        private final ArrayBuffer buf = new ArrayBuffer();

        public Iterator<TestFailure> failures() {
            return this.buf().elements().map(new TestResult$$anonfun$failures$1(this));
        }

        public int failureCount() {
            return this.buf().length();
        }

        public void addFailure(Test test2, Throwable t) {
            this.buf().$plus$eq(new Tuple2<Test, Throwable>(test2, t));
        }

        public ArrayBuffer<Tuple2<Test, Throwable>> buf() {
            return this.buf;
        }

        @Override
        public int $tag() throws RemoteException {
            return ScalaObject$class.$tag(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestFailure
    implements ScalaObject {
        private final Throwable thrownException;
        private final Test failedTest;

        public TestFailure(Test failedTest, Throwable thrownException) {
            this.failedTest = failedTest;
            this.thrownException = thrownException;
        }

        public String trace() {
            return Predef$.MODULE$.exceptionWrapper(this.thrownException()).getStackTraceString();
        }

        public String toString() {
            return new StringBuilder().append((Object)this.failedTest().toString()).append((Object)" failed due to ").append((Object)this.thrownException().toString()).toString();
        }

        public TestFailure(Tuple2<Test, Throwable> p) {
            this(p._1(), p._2());
        }

        public Throwable thrownException() {
            return this.thrownException;
        }

        public Test failedTest() {
            return this.failedTest;
        }

        @Override
        public int $tag() throws RemoteException {
            return ScalaObject$class.$tag(this);
        }
    }

    public static class AssertFailed
    extends RuntimeException
    implements ScalaObject,
    Product,
    Serializable {
        private final String msg0;
        private final boolean stackTrace;
        private final String msg;

        public AssertFailed(String msg, boolean stackTrace) {
            String string2;
            this.msg = msg;
            this.stackTrace = stackTrace;
            Product$class.$init$(this);
            if (stackTrace) {
                StringWriter wrt = new StringWriter();
                this.printStackTrace(new PrintWriter(wrt));
                string2 = wrt.toString();
            } else {
                string2 = msg;
            }
            this.msg0 = string2;
        }

        private final /* synthetic */ boolean gd1$1(String x$1, boolean x$2) {
            String string2 = x$1;
            String string3 = this.msg();
            return !(string2 != null ? !string2.equals(string3) : string3 != null) && x$2 == this.stackTrace();
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
                case 0: {
                    object = this.msg();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean(this.stackTrace());
                }
            }
            return object;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AssertFailed";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (!(x$1 instanceof Object)) return false;
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AssertFailed)) return false;
            AssertFailed assertFailed = (AssertFailed)object;
            boolean bl = this.gd1$1(assertFailed.msg(), assertFailed.stackTrace());
            if (!bl) return false;
            return true;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public int $tag() {
            return 1450022304;
        }

        public String toString() {
            return this.msg0() == null ? new StringBuilder().append((Object)"failed assertion: ").append((Object)this.msg()).toString() : this.msg0();
        }

        private String msg0() {
            return this.msg0;
        }

        public boolean stackTrace() {
            return this.stackTrace;
        }

        public String msg() {
            return this.msg;
        }
    }

    public static interface TestConsoleMain
    extends ScalaObject {
        public void main(String[] var1);

        public TestSuite suite();
    }
}

