/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.profile.StackProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.renjin.gcc.kmns;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.MILLISECONDS)
@Fork(value=1, jvmArgsAppend={"-XX:+UnlockDiagnosticVMOptions", "-XX:+TraceClassLoading", "-XX:+LogCompilation", "-XX:LogFile=kmeans.log", "-XX:+PrintAssembly"})
public class KmeansBenchmark {
    double[] a;
    int m = 3467;
    int n = 3467;
    double[] c;
    int k = 25;
    int[] ic1;
    int[] ic2;
    int[] nc;
    double[] an1;
    double[] an2;
    int[] ncp;
    double[] d;
    int[] itran;
    int[] live;
    int iter = 10;
    double[] wss;
    int[] ifault;

    @Setup(value=Level.Invocation)
    public void prepare() {
        this.a = new double[this.m * this.n];
        int ai = 0;
        for (int column = 0; column < this.m; ++column) {
            for (int row = 0; row < this.n; ++row) {
                this.a[ai++] = (double)row / (double)this.n;
            }
        }
        int ci = 0;
        this.c = new double[this.m * this.k];
        for (int column = 0; column < this.m; ++column) {
            for (int row = 0; row < this.k; ++row) {
                this.c[ci++] = (double)row / (double)this.k;
            }
        }
        this.ic1 = new int[this.m];
        this.ic2 = new int[this.m];
        this.nc = new int[this.k];
        this.an1 = new double[this.k];
        this.an2 = new double[this.k];
        this.ncp = new int[this.k];
        this.d = new double[this.m];
        this.itran = new int[this.k];
        this.live = new int[this.k];
        this.wss = new double[this.k];
        this.ifault = new int[1];
    }

    @Benchmark
    public double[] benchmark() {
        kmns.kmns_(new DoublePtr(this.a), new IntPtr(new int[]{this.m}), new IntPtr(new int[]{this.n}), new DoublePtr(this.c), new IntPtr(new int[]{this.k}), new IntPtr(this.ic1), new IntPtr(this.ic2), new IntPtr(this.nc), new DoublePtr(this.an1), new DoublePtr(this.an2), new IntPtr(this.ncp), new DoublePtr(this.d), new IntPtr(this.itran), new IntPtr(this.live), new IntPtr(new int[]{this.iter}), new DoublePtr(this.wss), new IntPtr(this.ifault));
        return this.wss;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(KmeansBenchmark.class.getName() + ".*").addProfiler(StackProfiler.class).forks(1).build();
        new Runner(opt).run();
    }
}

