/*$************************************************************************************************
 **
 ** $Id: RangeAxis.java 1376 2009-03-31 21:57:26Z Jive $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/trunk/geoapi-pending/src/main/java/org/opengis/sld/RangeAxis.java $
 **
 ** Copyright (C) 2008 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.sld;

import org.opengis.annotation.Extension;
import org.opengis.annotation.XmlElement;

/**
 * RangeAxis describes a range subset defined by a constraining parameter. The name of
 * that parameter matches the name of an AxisDescription element in the range set
 * description of the selected coverage offering. The value is one of the acceptable values
 * defined in the corresponding AxisDescription element.
 * 
 * @version <A HREF="http://www.opengeospatial.org/standards/sld">Implementation specification 1.1.0</A>
 * @author Open Geospatial Consortium
 * @author Johann Sorel (Geomatys)
 * @since GeoAPI 2.2
 */
@XmlElement("RangeAxis")
public interface RangeAxis {

    @XmlElement("Name")
    String getName();

    @XmlElement("Value")
    String getValue();
    
    /**
     * calls the visit method of a SLDVisitor
     *
     * @param visitor the sld visitor
     */
    @Extension
    Object accept(SLDVisitor visitor, Object extraData);
    
}
