/*$************************************************************************************************
 **
 ** $Id: Process.java 1389 2009-04-28 15:31:06Z eclesia $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/trunk/geoapi-pending/src/main/java/org/opengis/observation/Process.java $
 **
 ** Copyright (C) 2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.observation;

import org.opengis.annotation.UML;

import static org.opengis.annotation.Specification.*;

/**
 * The description of Observation procedures is beyond the scope of this specification.
 * 
 * NOTE: It is expected that standard process model descriptions will be published in a standard location
 *  (e.g. ISO 19135 register) enabling them to be used by-reference.
 *
 *
 * @version <A HREF="http://www.opengeospatial.org/standards/om">Implementation specification 1.0</A>
 * @author Open Geospatial Consortium
 * @author Guilhem Legal (Geomatys)
 * @since GeoAPI 2.3
 */
@UML(identifier="Process", specification=OGC_07022)
public interface Process {
}