/*$************************************************************************************************
 **
 ** $Id: PropertyIsEqualTo.java 1154 2007-12-19 22:29:42Z jive $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/trunk/geoapi-pending/src/main/java/org/opengis/filter/PropertyIsEqualTo.java $
 **
 ** Copyright (C) 2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.filter;

// Annotations
import org.opengis.annotation.XmlElement;


/**
 * Filter operator that compares that its two sub-expressions are equal to each other.
 *
 * @version <A HREF="http://www.opengis.org/docs/02-059.pdf">Implementation specification 1.0</A>
 * @author Chris Dillard (SYS Technologies)
 * @since GeoAPI 2.0
 */
@XmlElement("PropertyIsEqualTo")
public interface PropertyIsEqualTo extends BinaryComparisonOperator {
	/** Operator name used to check FilterCapabilities */
	public static String NAME = "EqualTo";
}
