/*$************************************************************************************************
 **
 ** $Id: GridValuesMatrix.java 1263 2008-07-09 17:25:51Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/trunk/geoapi-pending/src/main/java/org/opengis/coverage/grid/quadrilateral/GridValuesMatrix.java $
 **
 ** Copyright (C) 2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.coverage.grid.quadrilateral;

import java.util.List;
import org.opengis.util.Record;
import org.opengis.annotation.UML;
import org.opengis.annotation.Extension;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.SequenceRule;

import static org.opengis.annotation.Obligation.*;
import static org.opengis.annotation.Specification.*;


/**
 * A modified copy of {@link org.opengis.coverage.grid.GridValuesMatrix} which does not inherit
 * {@link org.opengis.coverage.grid.Grid}. The later is replaced by a composition to be
 * queried by {@link #getGrid}.
 *
 * @issue http://jira.codehaus.org/browse/GEO-82
 *
 * @version ISO 19123:2004
 * @author  Wim Koolhoven
 * @author  Martin Schouwenburg
 * @author  Alexander Petkov
 */
@UML(identifier="CV_GridValuesMatrix", specification=ISO_19123)
public interface GridValuesMatrix {
    /**
     * Returns a sequence of <var>N</var> feature attribute value records where <var>N</var> is the
     * number of {@linkplain GridPoint grid points} within the section of the grid specified by
     * the {@linkplain #getExtent extent}.
     *
     * @todo Comment (Wim): Both extracting an image for display and operation chaining require
     *       memory effiecient and fast access to the data. How should the data be structured per
     *       record? Some use cases:
     *       <table border=1>
     *         <tr><td>DTM<td>double<td>List&lt;double&gt;
     *         <tr><td>TM image<td>7 bytes<td>
     *         <tr><td>Landuse map<td>string<td>{@code List<double>} with look up table for the strings
     *       </table>
     */
    @UML(identifier="values", obligation=MANDATORY, specification=ISO_19123)
    List<Record> getValues();

    /**
     * Describes how the grid points are ordered for association to the elements of the sequence
     * values.
     */
    @UML(identifier="sequencingRule", obligation=MANDATORY, specification=ISO_19123)
    SequenceRule getSequencingRule();

    /**
     * Identifies the grid point to be associated with the first record
     * in the values sequence.
     */
    @UML(identifier="startSequence", obligation=MANDATORY, specification=ISO_19123)
    GridCoordinates getStartSequence();

    /**
     * Returns the limits of a section of the grid. This envelope can not be empty.
     */
    @UML(identifier="extent", obligation=OPTIONAL, specification=ISO_19123)
    GridEnvelope getExtent();

    /**
     * Associates this GridValuesMatrix with a geometric description provided by the Grid object.
     * The extent attribute of the associated Grid object must be synchronized with the extent
     * attribute of this object.
     */
    @Extension
    Grid getGrid();
}
