/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.FeatureTypeImpl;
import org.geotools.gml3.XSDIdRegistry;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.util.Converters;
import org.geotools.xlink.XLINK;
import org.geotools.xml.Schemas;
import org.geotools.xs.XS;
import org.geotools.xs.bindings.XSAnyTypeBinding;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.Identifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class ComplexSupportXSAnyTypeBinding
extends XSAnyTypeBinding {
    private XSDIdRegistry idSet;

    public ComplexSupportXSAnyTypeBinding(XSDIdRegistry idRegistry) {
        this.idSet = idRegistry;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if (object instanceof ComplexAttribute) {
            ComplexAttribute complex = (ComplexAttribute)object;
            Property property = complex.getProperty(ComplexSupportXSAnyTypeBinding.toTypeName(name));
            if (property != null && !(property instanceof ComplexAttribute)) {
                return property.getValue();
            }
            if ("id".equals(name.getLocalPart())) {
                return complex.getIdentifier();
            }
        }
        return null;
    }

    private static Name toTypeName(QName name) {
        if ("".equals(name.getNamespaceURI())) {
            return new NameImpl(name.getLocalPart());
        }
        return new NameImpl(name.getNamespaceURI(), name.getLocalPart());
    }

    public List getProperties(Object object, XSDElementDeclaration element) throws Exception {
        ArrayList<Object[]> properties;
        block25: {
            ArrayList anyElementParticles;
            XSDElementDeclaration wrapper;
            XSDParticle substitutedChildParticle;
            boolean isAnyType;
            if (object == null) {
                return null;
            }
            properties = new ArrayList<Object[]>();
            XSDTypeDefinition typeDef = element.getTypeDefinition();
            boolean bl = isAnyType = typeDef.getName() != null && typeDef.getTargetNamespace() != null && typeDef.getName().equals(XS.ANYTYPE.getLocalPart()) && typeDef.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema");
            if (isAnyType) {
                Collection complexAtts;
                if (object instanceof Collection) {
                    complexAtts = (Collection)object;
                } else if (object instanceof ComplexAttribute) {
                    complexAtts = ((ComplexAttribute)object).getProperties();
                } else {
                    return null;
                }
                for (Object complex : complexAtts) {
                    Object propertyElement;
                    AttributeDescriptor descriptor;
                    if (!(complex instanceof ComplexAttribute) || (descriptor = ((Attribute)complex).getDescriptor()).getUserData() == null || (propertyElement = descriptor.getUserData().get(XSDElementDeclaration.class)) == null || !(propertyElement instanceof XSDElementDeclaration)) continue;
                    XSDParticle substitutedChildParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
                    substitutedChildParticle2.setMaxOccurs(descriptor.getMaxOccurs());
                    substitutedChildParticle2.setMinOccurs(descriptor.getMinOccurs());
                    XSDElementDeclaration wrapper2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    wrapper2.setResolvedElementDeclaration((XSDElementDeclaration)propertyElement);
                    substitutedChildParticle2.setContent((XSDParticleContent)wrapper2);
                    properties.add(new Object[]{substitutedChildParticle2, complex});
                }
                return properties;
            }
            if (object instanceof ComplexAttribute) {
                ComplexAttribute complex = (ComplexAttribute)object;
                for (XSDParticle childParticle : Schemas.getChildElementParticles((XSDTypeDefinition)element.getTypeDefinition(), (boolean)true)) {
                    XSDElementDeclaration childElement = (XSDElementDeclaration)childParticle.getContent();
                    if (childElement.isElementDeclarationReference()) {
                        childElement = childElement.getResolvedElementDeclaration();
                    }
                    for (XSDElementDeclaration e : childElement.getSubstitutionGroup()) {
                        NameImpl name = new NameImpl(e.getTargetNamespace(), e.getName());
                        Collection nameProperties = complex.getProperties((Name)name);
                        if (nameProperties.isEmpty()) continue;
                        substitutedChildParticle = XSDFactory.eINSTANCE.createXSDParticle();
                        substitutedChildParticle.setMaxOccurs(childParticle.getMaxOccurs());
                        substitutedChildParticle.setMinOccurs(childParticle.getMinOccurs());
                        wrapper = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                        wrapper.setResolvedElementDeclaration(e);
                        substitutedChildParticle.setContent((XSDParticleContent)wrapper);
                        for (Property property : nameProperties) {
                            if (property instanceof ComplexAttribute) {
                                properties.add(new Object[]{substitutedChildParticle, property});
                                continue;
                            }
                            if (!(property instanceof GeometryAttribute)) continue;
                            Object attType = complex.getType().getUserData().get(XSDTypeDefinition.class);
                            boolean duplicate = false;
                            if (attType != null && attType instanceof XSDTypeDefinition) {
                                XSDTypeDefinition attTypeDef = (XSDTypeDefinition)attType;
                                for (XSDParticle attChild : Schemas.getChildElementParticles((XSDTypeDefinition)attTypeDef, (boolean)true)) {
                                    XSDElementDeclaration childEl = (XSDElementDeclaration)attChild.getContent();
                                    if (childEl.isElementDeclarationReference()) {
                                        childEl = childEl.getResolvedElementDeclaration();
                                    }
                                    if (!childEl.equals(e)) continue;
                                    duplicate = true;
                                    break;
                                }
                            }
                            if (duplicate) continue;
                            properties.add(new Object[]{substitutedChildParticle, property.getValue()});
                        }
                    }
                }
            }
            if ((anyElementParticles = new ArrayList(Schemas.getAnyElementParticles((XSDTypeDefinition)element.getTypeDefinition()))).size() <= 0) break block25;
            Collection complexAtts = null;
            if (object instanceof Collection) {
                complexAtts = (Collection)object;
            } else if (object instanceof ComplexAttribute) {
                complexAtts = ((ComplexAttribute)object).getProperties();
            }
            if (properties.isEmpty()) {
                for (Object complex : complexAtts) {
                    Object propertyElement;
                    ComplexAttribute newComplexAtt;
                    AttributeDescriptor descriptor;
                    if (!(complex instanceof ComplexAttribute) || (descriptor = (newComplexAtt = (ComplexAttribute)complex).getDescriptor()).getUserData() == null || (propertyElement = descriptor.getUserData().get(XSDElementDeclaration.class)) == null || !(propertyElement instanceof XSDElementDeclaration)) continue;
                    XSDParticle substitutedChildParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
                    substitutedChildParticle3.setMaxOccurs(descriptor.getMaxOccurs());
                    substitutedChildParticle3.setMinOccurs(descriptor.getMinOccurs());
                    XSDElementDeclaration wrapper3 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    wrapper3.setResolvedElementDeclaration((XSDElementDeclaration)propertyElement);
                    substitutedChildParticle3.setContent((XSDParticleContent)wrapper3);
                    properties.add(new Object[]{substitutedChildParticle3, newComplexAtt});
                }
            } else {
                ArrayList elementParticles = new ArrayList(Schemas.getChildElementParticles((XSDTypeDefinition)element.getTypeDefinition(), (boolean)false));
                for (Object complex : complexAtts) {
                    Object propertyElement;
                    if (!(complex instanceof ComplexAttribute)) continue;
                    ComplexAttribute newComplexAtt = (ComplexAttribute)complex;
                    AttributeDescriptor descriptor = ((Attribute)complex).getDescriptor();
                    if (descriptor.getUserData() == null || (propertyElement = descriptor.getUserData().get(XSDElementDeclaration.class)) == null || !(propertyElement instanceof XSDElementDeclaration)) continue;
                    substitutedChildParticle = XSDFactory.eINSTANCE.createXSDParticle();
                    substitutedChildParticle.setMaxOccurs(descriptor.getMaxOccurs());
                    substitutedChildParticle.setMinOccurs(descriptor.getMinOccurs());
                    wrapper = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    wrapper.setResolvedElementDeclaration((XSDElementDeclaration)propertyElement);
                    substitutedChildParticle.setContent((XSDParticleContent)wrapper);
                    boolean propertyExist = false;
                    for (XSDParticle childParticle : elementParticles) {
                        String newName;
                        String existingName;
                        XSDElementDeclaration childElement = (XSDElementDeclaration)childParticle.getContent();
                        if (childElement.isElementDeclarationReference()) {
                            childElement = childElement.getResolvedElementDeclaration();
                        }
                        if (!(existingName = childElement.getName()).equals(newName = newComplexAtt.getDescriptor().getName().getLocalPart())) continue;
                        propertyExist = true;
                        break;
                    }
                    if (propertyExist) continue;
                    properties.add(new Object[]{substitutedChildParticle, newComplexAtt});
                }
            }
        }
        return properties;
    }

    private void checkXlinkHref(Object value, ComplexAttribute att) {
        if (value != null && value instanceof ComplexAttribute) {
            ComplexAttribute object = (ComplexAttribute)value;
            if (!(object.getType() instanceof FeatureTypeImpl)) {
                return;
            }
            Identifier ident = object.getIdentifier();
            if (ident == null) {
                return;
            }
            String id = (String)Converters.convert((Object)ident.getID(), String.class);
            if (this.idSet.idExists(id)) {
                Object clientProperties = att.getUserData().get(Attributes.class);
                HashMap<Name, String> map = null;
                if (clientProperties == null) {
                    map = new HashMap<Name, String>();
                    att.getUserData().put(Attributes.class, map);
                } else {
                    map = (HashMap<Name, String>)clientProperties;
                }
                map.put(ComplexSupportXSAnyTypeBinding.toTypeName(XLINK.HREF), "#" + id.toString());
                att.setValue(Collections.emptyList());
            }
        }
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        if (object instanceof ComplexAttribute) {
            ComplexAttribute complex = (ComplexAttribute)object;
            if (complex.getProperties().size() == 1) {
                Property prop = (Property)complex.getProperties().iterator().next();
                this.checkXlinkHref(prop, complex);
            }
            GML3EncodingUtils.encodeClientProperties((Property)complex, value);
            GML3EncodingUtils.encodeSimpleContent(complex, document, value);
        }
        return value;
    }
}

