/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.net.URI;
import java.net.URISyntaxException;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.ElementGroupingHandler;
import org.geotools.xml.handlers.xsi.SchemaHandler;
import org.geotools.xml.schema.Any;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AnyHandler
extends ElementGroupingHandler {
    public static final String LOCALNAME = "any";
    public static final int STRICT = 0;
    public static final int LAX = 1;
    public static final int SKIP = 2;
    private String id;
    private URI namespace;
    private int minOccurs;
    private int maxOccurs;
    private DefaultAny cache = null;

    @Override
    public int hashCode() {
        return LOCALNAME.hashCode() * (this.id == null ? 1 : this.id.hashCode()) + this.minOccurs * this.maxOccurs;
    }

    @Override
    public XSIElementHandler getHandler(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, Attributes atts) throws SAXException {
        String namespace1;
        String max;
        String min;
        this.id = atts.getValue("", "id");
        if (this.id == null) {
            this.id = atts.getValue(namespaceURI, "id");
        }
        if ((min = atts.getValue("", "minOccurs")) == null) {
            min = atts.getValue(namespaceURI, "minOccurs");
        }
        if ((max = atts.getValue("", "maxOccurs")) == null) {
            max = atts.getValue(namespaceURI, "maxOccurs");
        }
        if ((namespace1 = atts.getValue("", "namespace")) == null) {
            namespace1 = atts.getValue(namespaceURI, "namespace");
        }
        try {
            if (namespace1 != null) {
                if (namespace1.toLowerCase().equals("##any")) {
                    this.namespace = Any.ALL;
                } else if (namespace1.toLowerCase().equals("##other")) {
                    this.namespace = Any.ALL;
                } else if (namespace1.toLowerCase().equals("##targetNamespace")) {
                    try {
                        this.namespace = new URI(namespaceURI);
                    }
                    catch (URISyntaxException e) {
                        logger.warning(e.toString());
                        this.namespace = new URI(namespace1);
                    }
                } else {
                    this.namespace = new URI(namespace1);
                }
            }
        }
        catch (URISyntaxException e) {
            logger.warning(e.toString());
            throw new SAXException(e);
        }
        this.minOccurs = null == min || "".equalsIgnoreCase(min) ? 1 : Integer.parseInt(min);
        this.maxOccurs = null == max || "".equalsIgnoreCase(max) ? 1 : ("unbounded".equalsIgnoreCase(max) ? Integer.MAX_VALUE : Integer.parseInt(max));
    }

    @Override
    public String getLocalName() {
        return LOCALNAME;
    }

    public static int findProcess(String process) throws SAXException {
        if (process == null || "".equalsIgnoreCase(process)) {
            return 0;
        }
        if ("lax".equalsIgnoreCase(process)) {
            return 1;
        }
        if ("skip".equalsIgnoreCase(process)) {
            return 2;
        }
        if ("strict".equalsIgnoreCase(process)) {
            return 0;
        }
        throw new SAXException("Unknown Process Type: '" + process + "'");
    }

    public static String writeProcess(int process) {
        switch (process) {
            case 1: {
                return "lax";
            }
            case 2: {
                return "skip";
            }
        }
        return "strict";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ElementGrouping compress(SchemaHandler parent) {
        AnyHandler anyHandler = this;
        synchronized (anyHandler) {
            if (this.cache != null) {
                return this.cache;
            }
            this.cache = new DefaultAny();
        }
        this.cache.id = this.id;
        this.cache.namespace = this.namespace;
        this.cache.minOccurs = this.minOccurs;
        this.cache.maxOccurs = this.maxOccurs;
        this.id = null;
        this.namespace = null;
        return this.cache;
    }

    @Override
    public int getHandlerType() {
        return 0;
    }

    @Override
    public void endElement(String namespaceURI, String localName) {
    }

    private static class DefaultAny
    implements Any {
        String id;
        URI namespace;
        int maxOccurs;
        int minOccurs;

        private DefaultAny() {
        }

        @Override
        public Element findChildElement(String name) {
            return null;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public int getMaxOccurs() {
            return this.maxOccurs;
        }

        @Override
        public int getMinOccurs() {
            return this.minOccurs;
        }

        @Override
        public URI getNamespace() {
            return this.namespace;
        }

        @Override
        public int getGrouping() {
            return 4;
        }

        @Override
        public Element findChildElement(String localName, URI namespaceURI) {
            return null;
        }
    }
}

