/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.index.quadtree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.CloseableIterator;
import org.geotools.data.shapefile.index.Data;
import org.geotools.data.shapefile.index.DataDefinition;
import org.geotools.data.shapefile.index.quadtree.Node;
import org.geotools.data.shapefile.index.quadtree.QuadTree;
import org.geotools.data.shapefile.shp.IndexFile;
import org.locationtech.jts.geom.Envelope;

public class LazySearchIterator
implements CloseableIterator<Data> {
    static final int[] ZERO = new int[0];
    static final DataDefinition DATA_DEFINITION = new DataDefinition("US-ASCII");
    private static final int MAX_INDICES = 32768;
    Data next = null;
    Node current;
    int idIndex = 0;
    private boolean closed;
    private Envelope bounds;
    Iterator data;
    private IndexFile indexfile;
    ArrayList<Node> parents = new ArrayList();
    Indices indices = new Indices();
    QuadTree tree;

    public LazySearchIterator(QuadTree tree, Envelope bounds) {
        this.tree = tree;
        this.indexfile = tree.getIndexfile();
        tree.registerIterator((Iterator)((Object)this));
        this.current = tree.getRoot();
        this.bounds = bounds;
        this.closed = false;
        this.next = null;
    }

    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed!");
        }
        if (this.next != null) {
            return true;
        }
        if (this.data != null && this.data.hasNext()) {
            this.next = (Data)this.data.next();
        } else {
            this.data = null;
            this.fillCache();
            if (this.data != null && this.data.hasNext()) {
                this.next = (Data)this.data.next();
            }
        }
        return this.next != null;
    }

    private void fillCache() {
        this.indices.clear();
        ArrayList<Data> dataList = null;
        try {
            int i;
            while (this.indices.size() < 32768 && this.current != null) {
                if (this.idIndex < this.current.getNumShapeIds() && !this.current.isVisited() && this.current.getBounds().intersects(this.bounds)) {
                    this.indices.add(this.current.getShapeId(this.idIndex));
                    ++this.idIndex;
                    continue;
                }
                this.current.setShapesId(new int[0]);
                this.idIndex = 0;
                boolean foundUnvisited = false;
                for (i = 0; i < this.current.getNumSubNodes(); ++i) {
                    Node node = this.current.getSubNode(i);
                    if (node.isVisited() || !node.getBounds().intersects(this.bounds)) continue;
                    foundUnvisited = true;
                    this.parents.add(this.current);
                    this.current = node;
                    break;
                }
                if (foundUnvisited) continue;
                this.current.setVisited(true);
                this.current.clean();
                if (this.parents.isEmpty()) {
                    this.current = null;
                    continue;
                }
                this.current = this.parents.remove(this.parents.size() - 1);
            }
            this.indices.sort();
            int size = this.indices.size();
            dataList = new ArrayList<Data>(size);
            for (i = 0; i < size; ++i) {
                int recno = this.indices.get(i);
                Data data = new Data(DATA_DEFINITION);
                data.addValue(recno + 1);
                data.addValue(this.indexfile.getOffsetInBytes(recno));
                dataList.add(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.data = dataList.iterator();
    }

    public Data next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        Data temp = this.next;
        this.next = null;
        return temp;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.tree.close((Iterator)((Object)this));
        this.tree.close();
        this.closed = true;
    }

    static {
        DATA_DEFINITION.addField(Integer.class);
        DATA_DEFINITION.addField(Long.class);
    }

    class Indices {
        int curr = -1;
        int[] indices = new int[100];

        int size() {
            return this.curr + 1;
        }

        void add(int index) {
            ++this.curr;
            if (this.curr * 2 + 1 >= this.indices.length) {
                int newSize = this.indices.length * 3 / 2;
                if (newSize < 10) {
                    newSize = 10;
                }
                int[] resized = new int[newSize];
                System.arraycopy(this.indices, 0, resized, 0, this.indices.length);
                this.indices = resized;
            }
            this.indices[this.curr] = index;
        }

        void clear() {
            this.curr = -1;
        }

        int get(int position) {
            return this.indices[position];
        }

        void sort() {
            Arrays.sort(this.indices, 0, this.curr + 1);
        }
    }
}

