/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.memory.MemoryEntry;
import org.geotools.data.memory.MemoryFeatureReader;
import org.geotools.data.memory.MemoryState;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MemoryFeatureSource
extends ContentFeatureSource {
    public MemoryFeatureSource(ContentEntry entry) {
        this(entry, Query.ALL);
    }

    public MemoryFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
    }

    @Override
    public MemoryDataStore getDataStore() {
        return (MemoryDataStore)super.getDataStore();
    }

    @Override
    public MemoryState getState() {
        return (MemoryState)super.getState();
    }

    @Override
    public MemoryEntry getEntry() {
        return (MemoryEntry)super.getEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.getReaderInternal(query);
            CoordinateReferenceSystem crs = ((SimpleFeatureType)featureReader.getFeatureType()).getCoordinateReferenceSystem();
            ReferencedEnvelope bounds = ReferencedEnvelope.create((CoordinateReferenceSystem)crs);
            try {
                while (featureReader.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureReader.next();
                    bounds.include(feature.getBounds());
                }
            }
            finally {
                featureReader.close();
            }
            return bounds;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getCountInternal(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            MemoryEntry entry;
            MemoryEntry memoryEntry = entry = this.getEntry();
            synchronized (memoryEntry) {
                return entry.memory.size();
            }
        }
        return -1;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new MemoryFeatureReader(this.getState(), query);
    }

    @Override
    protected SimpleFeatureType buildFeatureType() {
        return this.getState().getEntry().schema;
    }

    @Override
    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }
}

