/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import javax.media.jai.Interpolation;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CannotReprojectException;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.coverage.processing.operation.Resampler2D;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Resample
extends Operation2D {
    private static final long serialVersionUID = -2022393087647420577L;
    public static final ParameterDescriptor<Object> INTERPOLATION_TYPE = new DefaultParameterDescriptor(Citations.OGC, "InterpolationType", Object.class, null, (Object)"NearestNeighbor", null, null, null, false);
    public static final ParameterDescriptor<CoordinateReferenceSystem> COORDINATE_REFERENCE_SYSTEM = new DefaultParameterDescriptor(Citations.OGC, "CoordinateReferenceSystem", CoordinateReferenceSystem.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<GridGeometry> GRID_GEOMETRY = new DefaultParameterDescriptor(Citations.OGC, "GridGeometry", GridGeometry.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<double[]> BACKGROUND_VALUES = new DefaultParameterDescriptor(Citations.JAI, "BackgroundValues", double[].class, null, null, null, null, null, false);
    public static final String OPERATION = "method";
    public static final String WARP_TYPE = "warpType";
    public static final String GRID_DIMENSIONS = "gridDimensions";

    public Resample() {
        super((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(Citations.OGC, "Resample", (GeneralParameterDescriptor[])new ParameterDescriptor[]{SOURCE_0, INTERPOLATION_TYPE, COORDINATE_REFERENCE_SYSTEM, GRID_GEOMETRY, BACKGROUND_VALUES}));
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        GridCoverage2D source = (GridCoverage2D)((Object)parameters.parameter("Source").getValue());
        Interpolation interpolation = ImageUtilities.toInterpolation(parameters.parameter("InterpolationType").getValue());
        CoordinateReferenceSystem targetCRS = (CoordinateReferenceSystem)parameters.parameter("CoordinateReferenceSystem").getValue();
        if (targetCRS == null) {
            targetCRS = source.getCoordinateReferenceSystem();
        }
        GridGeometry2D targetGG = GridGeometry2D.wrap((GridGeometry)parameters.parameter("GridGeometry").getValue());
        ParameterValue bgValueParam = parameters.parameter("BackgroundValues");
        double[] bgValues = bgValueParam != null && bgValueParam instanceof Parameter ? (double[])((Parameter)bgValueParam).getValue() : null;
        try {
            return Resampler2D.reproject(source, targetCRS, targetGG, interpolation, hints instanceof Hints ? hints : new Hints((RenderingHints)hints), bgValues);
        }
        catch (FactoryException exception) {
            throw new CannotReprojectException(Errors.format((int)30, (Object)source.getName()), exception);
        }
        catch (TransformException exception) {
            throw new CannotReprojectException(Errors.format((int)30, (Object)source.getName()), exception);
        }
    }

    public static GridGeometry computeGridGeometry(GridCoverage source, Envelope target) throws TransformException {
        CoordinateReferenceSystem targetCRS = target.getCoordinateReferenceSystem();
        CoordinateReferenceSystem sourceCRS = source.getCoordinateReferenceSystem();
        CoordinateReferenceSystem reducedCRS = target.getDimension() == 2 && sourceCRS.getCoordinateSystem().getDimension() != 2 ? CoverageUtilities.getCRS2D((Coverage)source) : sourceCRS;
        GridGeometry gridGeometry = source.getGridGeometry();
        if (targetCRS == null || CRS.equalsIgnoreMetadata((Object)reducedCRS, (Object)targetCRS)) {
            Object gridToCRS = reducedCRS == sourceCRS ? gridGeometry.getGridToCRS() : GridGeometry2D.wrap(gridGeometry).getGridToCRS2D();
            gridGeometry = new GridGeometry2D(PixelInCell.CELL_CENTER, (MathTransform)gridToCRS, target, null);
        } else {
            try {
                MathTransform gridToCRS;
                Envelope reduced;
                GeneralEnvelope transformed = CRS.transform((CoordinateOperation)CRS.getCoordinateOperationFactory((boolean)true).createOperation(targetCRS, reducedCRS), (Envelope)target);
                if (reducedCRS == sourceCRS) {
                    reduced = source.getEnvelope();
                    gridToCRS = gridGeometry.getGridToCRS();
                } else {
                    reduced = CoverageUtilities.getEnvelope2D((Coverage)source);
                    gridToCRS = GridGeometry2D.wrap(gridGeometry).getGridToCRS2D();
                }
                transformed.intersect(reduced);
                gridGeometry = new GridGeometry2D(PixelInCell.CELL_CENTER, gridToCRS, (Envelope)transformed, null);
            }
            catch (FactoryException exception) {
                Resample.recoverableException("resample", (Exception)((Object)exception));
            }
            catch (TransformException exception) {
                Resample.recoverableException("resample", (Exception)((Object)exception));
            }
            GridEnvelope gridRange = gridGeometry.getGridRange();
            gridGeometry = new GridGeometry2D(gridRange, target);
        }
        return gridGeometry;
    }

    private static void recoverableException(String method, Exception exception) {
        Logging.recoverableException(Resample.class, (String)method, (Throwable)exception);
    }
}

