/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.operator;

import java.net.URL;
import org.esa.snap.watermask.operator.WatermaskClassifier;
import org.esa.snap.watermask.operator.WatermaskUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WatermaskClassifierTest {
    private WatermaskClassifier gcClassifier;

    @Before
    public void setUp() throws Exception {
        this.gcClassifier = new WatermaskClassifier(50);
    }

    @Test
    public void testGetWatermaskSampleAboveSixtyGC() throws Exception {
        Assert.assertEquals((long)1L, (long)this.gcClassifier.getWaterMaskSample(70.860275f, 29.205114f));
        Assert.assertEquals((long)1L, (long)this.gcClassifier.getWaterMaskSample(70.85397f, 29.21061f));
        Assert.assertEquals((long)0L, (long)this.gcClassifier.getWaterMaskSample(72.791664f, 105.28333f));
        Assert.assertEquals((long)0L, (long)this.gcClassifier.getWaterMaskSample(72.794586f, 105.27786f));
        Assert.assertEquals((long)1L, (long)this.gcClassifier.getWaterMaskSample(80.19444f, 25.963888f));
        Assert.assertEquals((long)0L, (long)this.gcClassifier.getWaterMaskSample(80.14856f, 25.95601f));
        Assert.assertEquals((long)1L, (long)this.gcClassifier.getWaterMaskSample(80.18703f, 26.04707f));
        Assert.assertEquals((long)0L, (long)this.gcClassifier.getWaterMaskSample(80.176834f, 26.054949f));
    }

    @Test
    public void testIsWaterCenter() throws Exception {
        Assert.assertFalse((boolean)this.gcClassifier.isWater(30.30539f, 111.55285f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(30.269484f, 111.55418f));
        Assert.assertFalse((boolean)this.gcClassifier.isWater(49.68f, 0.581f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(49.434505f, 0.156014f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(49.33615f, -0.0096f));
        Assert.assertFalse((boolean)this.gcClassifier.isWater(49.32062f, -0.005918f));
        Assert.assertFalse((boolean)this.gcClassifier.isWater(46.5f, 0.5f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(5.01f, 0.01f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(5.95f, 0.93f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(5.04f, 0.95f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(5.5f, 0.5f));
        Assert.assertFalse((boolean)this.gcClassifier.isWater(5.88f, 0.24f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(43.32236f, 4.157f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(43.511242f, 3.869841f));
        Assert.assertFalse((boolean)this.gcClassifier.isWater(45.981415f, -84.46296f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(45.967422f, -84.47718f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(53.5f, 5.92f));
        Assert.assertFalse((boolean)this.gcClassifier.isWater(53.45876f, 5.801733f));
        Assert.assertTrue((boolean)this.gcClassifier.isWater(-4.347463f, 11.443256f));
        Assert.assertFalse((boolean)this.gcClassifier.isWater(-4.2652f, 11.49324f));
    }

    @Test
    public void testGetZipfile() throws Exception {
        Assert.assertEquals((Object)"w002n51.img", (Object)WatermaskUtils.createImgFileName((float)51.007f, (float)-1.3f));
        Assert.assertFalse((boolean)"w001n51.img".equals(WatermaskUtils.createImgFileName((float)51.007f, (float)-1.3f)));
        Assert.assertEquals((Object)"w002n48.img", (Object)WatermaskUtils.createImgFileName((float)48.007f, (float)-1.83f));
        Assert.assertFalse((boolean)"w001n48.img".equals(WatermaskUtils.createImgFileName((float)48.007f, (float)-1.83f)));
        Assert.assertEquals((Object)"e000n51.img", (Object)WatermaskUtils.createImgFileName((float)51.007f, (float)0.3f));
        Assert.assertFalse((boolean)"e001n51.img".equals(WatermaskUtils.createImgFileName((float)51.007f, (float)0.3f)));
        Assert.assertEquals((Object)"e000n49.img", (Object)WatermaskUtils.createImgFileName((float)49.99396f, (float)0.0062302267f));
        Assert.assertFalse((boolean)"w001n49.img".equals(WatermaskUtils.createImgFileName((float)51.007f, (float)0.3f)));
        Assert.assertEquals((Object)"e001n51.img", (Object)WatermaskUtils.createImgFileName((float)51.007f, (float)1.3f));
        Assert.assertFalse((boolean)"e000n51.img".equals(WatermaskUtils.createImgFileName((float)51.007f, (float)1.3f)));
        Assert.assertEquals((Object)"e000n45.img", (Object)WatermaskUtils.createImgFileName((float)45.001f, (float)0.005f));
        Assert.assertFalse((boolean)"w000n45.img".equals(WatermaskUtils.createImgFileName((float)45.001f, (float)0.005f)));
        Assert.assertEquals((Object)"e111n30.img", (Object)WatermaskUtils.createImgFileName((float)30.27f, (float)111.581f));
        Assert.assertFalse((boolean)"e111n30.img".equals(WatermaskUtils.createImgFileName((float)29.01f, (float)112.01f)));
        Assert.assertEquals((Object)"w001s01.img", (Object)WatermaskUtils.createImgFileName((float)-0.01f, (float)-0.3f));
        Assert.assertFalse((boolean)"w000s01.img".equals(WatermaskUtils.createImgFileName((float)-0.01f, (float)-0.3f)));
        Assert.assertEquals((Object)"w002s02.img", (Object)WatermaskUtils.createImgFileName((float)-1.01f, (float)-1.3f));
        Assert.assertFalse((boolean)"w001s01.img".equals(WatermaskUtils.createImgFileName((float)-1.01f, (float)-1.3f)));
        Assert.assertEquals((Object)"e000s01.img", (Object)WatermaskUtils.createImgFileName((float)-0.01f, (float)0.3f));
        Assert.assertFalse((boolean)"e000s00.img".equals(WatermaskUtils.createImgFileName((float)-0.01f, (float)0.3f)));
        Assert.assertEquals((Object)"e001s01.img", (Object)WatermaskUtils.createImgFileName((float)-0.01f, (float)1.3f));
        Assert.assertFalse((boolean)"e001s00.img".equals(WatermaskUtils.createImgFileName((float)-0.01f, (float)1.3f)));
    }

    @Test
    public void testGetResource() throws Exception {
        URL resource = this.getClass().getResource("image.properties");
        Assert.assertNotNull((Object)resource);
    }
}

