/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.util;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.zip.ZipFile;
import org.esa.snap.watermask.operator.WatermaskUtils;
import org.esa.snap.watermask.util.ShapeFileRasterizer;
import org.junit.Assert;
import org.junit.Test;

public class ShapeFileRasterizerTest {
    @Test
    public void testImageCreation() throws Exception {
        File targetDir = new File("");
        ShapeFileRasterizer rasterizer = new ShapeFileRasterizer(targetDir);
        URL shapeUrl = this.getClass().getResource("e000n05f.shp");
        File shapeFile = new File(shapeUrl.getFile());
        int resolution = WatermaskUtils.computeSideLength((int)150);
        BufferedImage image = rasterizer.createImage(shapeFile, resolution);
        Raster imageData = image.getData();
        Assert.assertEquals((long)0L, (long)imageData.getSample(526, 92, 0));
        Assert.assertEquals((long)1L, (long)imageData.getSample(312, 115, 0));
        Assert.assertEquals((long)1L, (long)imageData.getSample(141, 187, 0));
        Assert.assertEquals((long)0L, (long)imageData.getSample(197, 27, 0));
        Assert.assertEquals((long)1L, (long)imageData.getSample(308, 701, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromZip() throws Exception {
        List tempFiles;
        File targetDir = new File("");
        ShapeFileRasterizer rasterizer = new ShapeFileRasterizer(targetDir);
        URL shapeUrl = this.getClass().getResource("e000n05f.zip");
        int tileSize = WatermaskUtils.computeSideLength((int)150);
        try (ZipFile zipFile = new ZipFile(shapeUrl.getFile());){
            tempFiles = rasterizer.createTempFiles(zipFile);
        }
        BufferedImage image = null;
        for (File file : tempFiles) {
            if (!file.getName().endsWith("shp")) continue;
            image = rasterizer.createImage(file, tileSize);
        }
        Assert.assertNotNull(image);
        Raster imageData = image.getData();
        Assert.assertEquals((long)0L, (long)imageData.getSample(526, 92, 0));
        Assert.assertEquals((long)1L, (long)imageData.getSample(312, 115, 0));
        Assert.assertEquals((long)1L, (long)imageData.getSample(141, 187, 0));
        Assert.assertEquals((long)0L, (long)imageData.getSample(197, 27, 0));
        Assert.assertEquals((long)1L, (long)imageData.getSample(308, 701, 0));
    }
}

